/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.server.service;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.app.Utils;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.NetworkUtils;

public class RegistryAdmin
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(RegistryAdmin.class);

    public boolean isRegistryReadOnly() {
        RegistryService registryService = org.wso2.carbon.registry.server.internal.Utils.getRegistryService();
        if (registryService == null) {
            log.error((Object)"Registry Service has not been set.");
        } else {
            try {
                RegistryContext context = registryService.getConfigSystemRegistry().getRegistryContext();
                if (context != null) {
                    return context.isReadOnly();
                }
            }
            catch (Exception e) {
                log.error((Object)"An error occurred while obtaining registry instance", (Throwable)e);
            }
        }
        return false;
    }

    public String getHTTPPermalink(String path) {
        return this.getPermalink(path, "http");
    }

    public String getHTTPSPermalink(String path) {
        return this.getPermalink(path, "https");
    }

    private String getPermalink(String path, String scheme) {
        String webContext;
        String host;
        try {
            host = NetworkUtils.getLocalHostname();
        }
        catch (Exception e) {
            log.error((Object)("An error occurred while constructing the permalink for the given path: " + path), (Throwable)e);
            return null;
        }
        int port = CarbonUtils.getTransportProxyPort((ConfigurationContext)this.getConfigContext(), (String)scheme);
        if (port == -1) {
            port = CarbonUtils.getTransportPort((ConfigurationContext)this.getConfigContext(), (String)scheme);
        }
        if ((webContext = ServerConfiguration.getInstance().getFirstProperty("WebContextRoot")) == null || webContext.equals("/")) {
            webContext = "";
        }
        RegistryService registryService = org.wso2.carbon.registry.server.internal.Utils.getRegistryService();
        String version = "";
        if (registryService == null) {
            log.error((Object)"Registry Service has not been set.");
        } else if (path != null) {
            try {
                String[] versions = registryService.getRegistry("wso2.system.user", CarbonContext.getThreadLocalCarbonContext().getTenantId()).getVersions(path);
                if (versions != null && versions.length > 0) {
                    version = versions[0].substring(versions[0].lastIndexOf(";version:"));
                }
            }
            catch (RegistryException e) {
                log.error((Object)("An error occurred while determining the latest version of the resource at the given path: " + path), (Throwable)e);
            }
        }
        if (host != null && port != -1 && path != null) {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            return scheme + "://" + host + ":" + port + webContext + (tenantDomain != null && !"carbon.super".equals(tenantDomain) ? "/t/" + tenantDomain : "") + "/registry/resource" + Utils.encodeRegistryPath((String)path) + version;
        }
        return null;
    }
}

