/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.server.internal;

import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.server.internal.Utils;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.registry.server", immediate=true)
public class RegistryServerServiceComponent {
    private static Log log = LogFactory.getLog(RegistryServerServiceComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        log.debug((Object)"Registry Service bundle is activated ");
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Registry Service bundle is deactivated ");
    }

    @Reference(name="registry.service", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        Utils.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        Utils.setRegistryService(null);
    }

    @Reference(name="config.context.service", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        try {
            if (contextService.getServerConfigContext() != null && contextService.getServerConfigContext().getAxisConfiguration() != null) {
                contextService.getServerConfigContext().getAxisConfiguration().engageModule("pagination");
            } else {
                log.error((Object)"Failed to pagination Activation Module.");
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Failed to pagination Module", (Throwable)e);
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
    }
}

