/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.message.tracer.handler.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.message.tracer.handler.stub.MessageTracerAdminStub;
import org.wso2.carbon.analytics.message.tracer.handler.stub.conf.EventingConfigData;

public class MessageTracerHandlerAdminClient {
    private static final Log log = LogFactory.getLog(MessageTracerHandlerAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.analytics.message.tracer.handler.ui.i18n.Resources";
    private MessageTracerAdminStub stub;
    private ResourceBundle bundle;

    public MessageTracerHandlerAdminClient(String cookie, String backendServerURL, ConfigurationContext configContext, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "MessageTracerAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new MessageTracerAdminStub(configContext, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void setEventingConfigData(EventingConfigData eventingConfigData) throws RemoteException {
        try {
            this.stub.configureEventing(eventingConfigData);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.set.eventing.config"), e);
        }
    }

    public EventingConfigData getEventingConfigData() throws RemoteException {
        try {
            return this.stub.getEventingConfigData();
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.eventing.config"), e);
            return null;
        }
    }

    public boolean isCloudDeployment() throws RemoteException {
        try {
            return this.stub.isCloudDeployment();
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("backend.server.unavailable"), e);
            return false;
        }
    }

    public String getBAMServerURL() throws RemoteException {
        try {
            return this.stub.getServerConfigBAMServerURL();
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("backend.server.unavailable"), e);
            return "";
        }
    }

    private void handleException(String msg, Exception e) throws RemoteException {
        log.error((Object)msg, (Throwable)e);
        throw new RemoteException(msg, e);
    }
}

