/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.xquery;

import java.util.List;
import javax.xml.namespace.QName;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.XdmNodeKind;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.xquery.MediatorBaseVariable;
import org.apache.synapse.mediators.xquery.MediatorCustomVariable;
import org.apache.synapse.mediators.xquery.MediatorVariable;
import org.apache.synapse.mediators.xquery.XQueryMediator;
import org.apache.synapse.util.xpath.SynapseXPath;

public class XQueryMediatorSerializer
extends AbstractMediatorSerializer {
    public OMElement serializeSpecificMediator(Mediator m) {
        List<MediatorVariable> list;
        List<MediatorProperty> pros;
        if (!(m instanceof XQueryMediator)) {
            this.handleException("Invalid Mediator has passed to serializer");
        }
        XQueryMediator queryMediator = (XQueryMediator)m;
        OMElement xquery = fac.createOMElement("xquery", synNS);
        Value key = queryMediator.getQueryKey();
        if (key != null) {
            ValueSerializer keySerializer = new ValueSerializer();
            keySerializer.serializeValue(key, "key", xquery);
        }
        XQueryMediatorSerializer.saveTracingState((OMElement)xquery, (Mediator)queryMediator);
        SynapseXPath targetXPath = queryMediator.getTarget();
        if (targetXPath != null && !"s11:Body/child::*[position()=1] | s12:Body/child::*[position()=1]".equals(targetXPath.toString())) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)targetXPath, (OMElement)xquery, (String)"target");
        }
        if ((pros = queryMediator.getProcessorProperties()) != null && !pros.isEmpty()) {
            OMElement dataSource = fac.createOMElement("dataSource", synNS);
            this.serializeProperties(dataSource, pros);
            xquery.addChild((OMNode)dataSource);
        }
        if ((list = queryMediator.getVariables()) != null && !list.isEmpty()) {
            for (MediatorVariable o : list) {
                SynapseXPath expression;
                QName name;
                MediatorVariable variable;
                if (o instanceof MediatorBaseVariable) {
                    variable = (MediatorBaseVariable)o;
                    name = variable.getName();
                    Object value = variable.getValue();
                    if (name == null || value == null) continue;
                    OMElement baseElement = fac.createOMElement("variable", synNS);
                    baseElement.addAttribute(fac.createOMAttribute("name", nullNS, name.getLocalPart()));
                    baseElement.addAttribute(fac.createOMAttribute("value", nullNS, (String)value));
                    String type = null;
                    ItemType variableType = variable.getType();
                    XdmNodeKind nodeKind = variable.getNodeKind();
                    if (ItemType.INT == variableType) {
                        type = "INT";
                    } else if (ItemType.INTEGER == variableType) {
                        type = "INTEGER";
                    } else if (ItemType.BOOLEAN == variableType) {
                        type = "BOOLEAN";
                    } else if (ItemType.BYTE == variableType) {
                        type = "BYTE";
                    } else if (ItemType.DOUBLE == variableType) {
                        type = "DOUBLE";
                    } else if (ItemType.SHORT == variableType) {
                        type = "SHORT";
                    } else if (ItemType.LONG == variableType) {
                        type = "LONG";
                    } else if (ItemType.FLOAT == variableType) {
                        type = "FLOAT";
                    } else if (ItemType.STRING == variableType) {
                        type = "STRING";
                    } else if (XdmNodeKind.DOCUMENT == nodeKind) {
                        type = "DOCUMENT";
                    } else if (XdmNodeKind.ELEMENT == nodeKind) {
                        type = "ELEMENT";
                    } else {
                        this.handleException("Unknown Type " + variableType);
                    }
                    if (type != null) {
                        baseElement.addAttribute(fac.createOMAttribute("type", nullNS, type));
                    }
                    xquery.addChild((OMNode)baseElement);
                    continue;
                }
                if (!(o instanceof MediatorCustomVariable) || (name = (variable = (MediatorCustomVariable)o).getName()) == null) continue;
                OMElement customElement = fac.createOMElement("variable", synNS);
                customElement.addAttribute(fac.createOMAttribute("name", nullNS, name.getLocalPart()));
                String regkey = ((MediatorCustomVariable)variable).getRegKey();
                if (regkey != null) {
                    customElement.addAttribute(fac.createOMAttribute("key", nullNS, regkey));
                }
                if ((expression = ((MediatorCustomVariable)variable).getExpression()) != null && !"s11:Body/child::*[position()=1] | s12:Body/child::*[position()=1]".equals(expression.toString())) {
                    SynapseXPathSerializer.serializeXPath((SynapseXPath)expression, (OMElement)customElement, (String)"expression");
                }
                String type = null;
                ItemType variableType = variable.getType();
                XdmNodeKind nodeKind = variable.getNodeKind();
                if (XdmNodeKind.DOCUMENT == nodeKind) {
                    type = "DOCUMENT";
                } else if (XdmNodeKind.ELEMENT == nodeKind) {
                    type = "ELEMENT";
                } else if (ItemType.INT == variableType) {
                    type = "INT";
                } else if (ItemType.INTEGER == variableType) {
                    type = "INTEGER";
                } else if (ItemType.BOOLEAN == variableType) {
                    type = "BOOLEAN";
                } else if (ItemType.BYTE == variableType) {
                    type = "BYTE";
                } else if (ItemType.DOUBLE == variableType) {
                    type = "DOUBLE";
                } else if (ItemType.SHORT == variableType) {
                    type = "SHORT";
                } else if (ItemType.LONG == variableType) {
                    type = "LONG";
                } else if (ItemType.FLOAT == variableType) {
                    type = "FLOAT";
                } else if (ItemType.STRING == variableType) {
                    type = "STRING";
                } else {
                    this.handleException("Unknown Type " + variableType);
                }
                if (type != null) {
                    customElement.addAttribute(fac.createOMAttribute("type", nullNS, type));
                }
                xquery.addChild((OMNode)customElement);
            }
        }
        this.serializeComments(xquery, queryMediator.getCommentsList());
        return xquery;
    }

    public String getMediatorClassName() {
        return XQueryMediator.class.getName();
    }
}

