/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.xquery;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.ItemTypeFactory;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmValue;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.xquery.MediatorVariable;
import org.apache.synapse.util.xpath.SourceXPathSupport;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.w3c.dom.Element;

public class XQueryMediator
extends AbstractMediator {
    private final List<MediatorProperty> processorProperties = new ArrayList<MediatorProperty>();
    private Value queryKey;
    private String querySource;
    private final SourceXPathSupport target = new SourceXPathSupport();
    private final List<MediatorVariable> variables = new ArrayList<MediatorVariable>();
    private final Object resourceLock = new Object();
    private boolean useDOMSource = false;
    private Processor cachedProcessor = null;
    private XQueryCompiler cachedQueryCompiler = null;
    private Map<String, XQueryEvaluator> cachedXQueryEvaluatorMap = new Hashtable<String, XQueryEvaluator>();

    public boolean mediate(MessageContext synCtx) {
        try {
            if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
                return true;
            }
            SynapseLog synLog = this.getLog(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((Object)"Start : XQuery mediator");
                if (synLog.isTraceTraceEnabled()) {
                    synLog.traceTrace((Object)("Message : " + synCtx.getEnvelope()));
                }
                synLog.traceOrDebug((Object)("Performing XQuery using query resource with key : " + this.queryKey));
            }
            this.performQuery(synCtx, synLog);
            JsonUtil.removeJsonStream((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext());
            synLog.traceOrDebug((Object)"End : XQuery mediator");
            return true;
        }
        catch (Exception e) {
            this.handleException("Unable to execute the query ", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performQuery(MessageContext synCtx, SynapseLog synLog) {
        Object dp;
        boolean reLoad = false;
        boolean needSet = false;
        XQueryEvaluator queryEvaluator = null;
        String generatedQueryKey = null;
        XQueryExecutable xQueryExecutable = null;
        boolean isQueryKeyGenerated = false;
        if (this.queryKey != null) {
            generatedQueryKey = this.queryKey.evaluateValue(synCtx);
        }
        if (generatedQueryKey != null) {
            isQueryKeyGenerated = true;
        }
        if (generatedQueryKey != null && !"".equals(generatedQueryKey) && (dp = synCtx.getConfiguration().getEntryDefinition(generatedQueryKey)) != null && dp.isDynamic() && (!dp.isCached() || dp.isExpired())) {
            reLoad = true;
        }
        try {
            XdmValue xdmValue;
            dp = this.resourceLock;
            synchronized (dp) {
                if (this.cachedProcessor == null) {
                    this.cachedProcessor = new Processor(false);
                    if (this.processorProperties != null && !this.processorProperties.isEmpty()) {
                        synLog.traceOrDebug((Object)"Setting up properties to the XQDataSource");
                        for (MediatorProperty processorProperty : this.processorProperties) {
                            if (processorProperty == null) continue;
                            this.cachedProcessor.setConfigurationProperty(processorProperty.getName(), (Object)processorProperty.getValue());
                        }
                    }
                }
                if (this.cachedQueryCompiler == null) {
                    synLog.traceOrDebug((Object)"Creating a compiler from the Processor ");
                    this.cachedQueryCompiler = this.cachedProcessor.newXQueryCompiler();
                }
                if (isQueryKeyGenerated) {
                    queryEvaluator = this.cachedXQueryEvaluatorMap.get(generatedQueryKey);
                }
                if (reLoad || queryEvaluator == null) {
                    if (this.querySource != null && !"".equals(this.querySource)) {
                        if (synLog.isTraceOrDebugEnabled()) {
                            synLog.traceOrDebug((Object)("Using in-lined query source - " + this.querySource));
                            synLog.traceOrDebug((Object)"Prepare an expression for the query ");
                        }
                        xQueryExecutable = this.cachedQueryCompiler.compile(this.querySource);
                        queryEvaluator = xQueryExecutable.load();
                        if (isQueryKeyGenerated) {
                            this.cachedXQueryEvaluatorMap.put(generatedQueryKey, queryEvaluator);
                        }
                        needSet = true;
                    } else {
                        DataHandler dataHandler;
                        Iterator<MediatorVariable> o = synCtx.getEntry(generatedQueryKey);
                        if (o == null) {
                            if (synLog.isTraceOrDebugEnabled()) {
                                synLog.traceOrDebug((Object)("Couldn't find the xquery source with a key " + this.queryKey));
                            }
                            throw new SynapseException("No object found for the key '" + generatedQueryKey + "'");
                        }
                        String sourceCode = null;
                        InputStream inputStream = null;
                        if (o instanceof OMElement) {
                            sourceCode = ((OMElement)o).getText();
                        } else if (o instanceof String) {
                            sourceCode = (String)((Object)o);
                        } else if (o instanceof OMText && (dataHandler = (DataHandler)((OMText)o).getDataHandler()) != null) {
                            try {
                                inputStream = dataHandler.getInputStream();
                                if (inputStream == null) {
                                    if (synLog.isTraceOrDebugEnabled()) {
                                        synLog.traceOrDebug((Object)("Couldn't get the stream from the xquery source with a key " + this.queryKey));
                                    }
                                    return;
                                }
                            }
                            catch (IOException e) {
                                this.handleException("Error in reading content as a stream ");
                            }
                        }
                        if ((sourceCode == null || "".equals(sourceCode)) && inputStream == null) {
                            if (synLog.isTraceOrDebugEnabled()) {
                                synLog.traceOrDebug((Object)("Couldn't find the xquery source with a key " + this.queryKey));
                            }
                            return;
                        }
                        if (synLog.isTraceOrDebugEnabled()) {
                            synLog.traceOrDebug((Object)("Picked up the xquery source from the key " + this.queryKey));
                            synLog.traceOrDebug((Object)"Prepare an expression for the query ");
                        }
                        try {
                            xQueryExecutable = sourceCode != null ? this.cachedQueryCompiler.compile(sourceCode) : this.cachedQueryCompiler.compile(inputStream);
                        }
                        catch (IOException e) {
                            this.handleException("Error during the query inputStream compilation");
                        }
                        queryEvaluator = xQueryExecutable.load();
                        if (isQueryKeyGenerated) {
                            this.cachedXQueryEvaluatorMap.put(generatedQueryKey, queryEvaluator);
                        }
                        needSet = true;
                    }
                }
                if (this.variables != null && !this.variables.isEmpty()) {
                    synLog.traceOrDebug((Object)"Binding  external variables to the DynamicContext");
                    for (MediatorVariable variable : this.variables) {
                        boolean hasValueChanged;
                        if (variable == null || !(hasValueChanged = variable.evaluateValue(synCtx)) && !needSet) continue;
                        this.setVariable(queryEvaluator, variable, synLog);
                    }
                }
                xdmValue = queryEvaluator.evaluate();
            }
            if (queryEvaluator == null) {
                synLog.traceOrDebug((Object)"Result Sequence is null");
                return;
            }
            dp = xdmValue.iterator();
            if (dp.hasNext()) {
                OMNode destination;
                XdmItem xdmItem = (XdmItem)dp.next();
                if (xdmItem == null) {
                    return;
                }
                XdmNodeKind xdmNodeKind = null;
                ItemType itemType = null;
                if (xdmItem.isAtomicValue()) {
                    itemType = XQueryMediator.getItemType(xdmItem, this.cachedProcessor);
                    if (itemType == null) {
                        return;
                    }
                } else {
                    xdmNodeKind = ((XdmNode)xdmItem).getNodeKind();
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)("The XQuery Result " + xdmItem.toString()));
                }
                if ((destination = this.target.selectOMNode(synCtx, synLog)) != null) {
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug((Object)("The target node " + destination));
                    }
                    if (XdmNodeKind.DOCUMENT == xdmNodeKind || XdmNodeKind.ELEMENT == xdmNodeKind) {
                        StAXOMBuilder builder = new StAXOMBuilder(XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xdmItem.toString())));
                        OMElement resultOM = builder.getDocumentElement();
                        if (resultOM != null) {
                            destination.insertSiblingAfter((OMNode)resultOM);
                            destination.detach();
                        }
                    } else if (ItemType.INTEGER == itemType || ItemType.INT == itemType) {
                        ((OMElement)destination).setText(String.valueOf(((XdmAtomicValue)xdmItem).getDecimalValue().intValue()));
                    } else if (ItemType.BOOLEAN == itemType) {
                        ((OMElement)destination).setText(String.valueOf(((XdmAtomicValue)xdmItem).getBooleanValue()));
                    } else if (ItemType.DOUBLE == itemType) {
                        ((OMElement)destination).setText(String.valueOf(((XdmAtomicValue)xdmItem).getDoubleValue()));
                    } else if (ItemType.FLOAT == itemType) {
                        ((OMElement)destination).setText(String.valueOf(((XdmAtomicValue)xdmItem).getDecimalValue().floatValue()));
                    } else if (ItemType.LONG == itemType) {
                        ((OMElement)destination).setText(String.valueOf(((XdmAtomicValue)xdmItem).getLongValue()));
                    } else if (ItemType.SHORT == itemType) {
                        ((OMElement)destination).setText(String.valueOf(((XdmAtomicValue)xdmItem).getDecimalValue().shortValue()));
                    } else if (ItemType.BYTE == itemType) {
                        ((OMElement)destination).setText(String.valueOf(((XdmAtomicValue)xdmItem).getDecimalValue().byteValue()));
                    } else if (ItemType.STRING == itemType) {
                        ((OMElement)destination).setText(String.valueOf(((XdmAtomicValue)xdmItem).getValue()));
                    }
                } else if (null == this.target.getXPath() && null == destination) {
                    StAXOMBuilder builder;
                    OMElement resultOM;
                    destination = synCtx.getEnvelope().getBody();
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug((Object)("The target node " + destination));
                    }
                    if ((XdmNodeKind.ELEMENT == xdmNodeKind || XdmNodeKind.DOCUMENT == xdmNodeKind) && (resultOM = (builder = new StAXOMBuilder(XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xdmItem.toString())))).getDocumentElement()) != null) {
                        ((OMElement)destination).addChild((OMNode)resultOM);
                    }
                }
            }
            queryEvaluator.close();
        }
        catch (SaxonApiException e) {
            this.handleException("Error during the querying " + e.getMessage(), (Exception)((Object)e));
        }
        catch (XMLStreamException e) {
            this.handleException("Error during retrieving  the Document Node as  the result " + e.getMessage(), e);
        }
    }

    private void setVariable(XQueryEvaluator queryEvaluator, MediatorVariable variable, SynapseLog synLog) throws SaxonApiException {
        QName name = new QName(variable.getName().getLocalPart());
        if (variable != null) {
            ItemType type = variable.getType();
            XdmNodeKind nodeKind = variable.getNodeKind();
            Object value = variable.getValue();
            if (value != null && (type != null || nodeKind != null)) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)("Binding a variable to the DynamicContext with a name : " + name + " and a value : " + value));
                }
                if (ItemType.BOOLEAN == type) {
                    boolean booleanValue = false;
                    if (value instanceof String) {
                        booleanValue = Boolean.parseBoolean((String)value);
                    } else if (value instanceof Boolean) {
                        booleanValue = (Boolean)value;
                    } else {
                        this.handleException("Incompatible type for the Boolean");
                    }
                    queryEvaluator.setExternalVariable(name, (XdmValue)new XdmAtomicValue(String.valueOf(booleanValue), ItemType.BOOLEAN));
                } else if (ItemType.INTEGER == type) {
                    int intValue = -1;
                    if (value instanceof String) {
                        try {
                            intValue = Integer.parseInt((String)value);
                        }
                        catch (NumberFormatException e) {
                            this.handleException("Incompatible value '" + value + "' for the Integer", e);
                        }
                    } else if (value instanceof Integer) {
                        intValue = (Integer)value;
                    } else {
                        this.handleException("Incompatible type for the Integer");
                    }
                    if (intValue != -1) {
                        queryEvaluator.setExternalVariable(name, (XdmValue)new XdmAtomicValue(String.valueOf(intValue), ItemType.INTEGER));
                    }
                } else if (ItemType.INT == type) {
                    int intValue = -1;
                    if (value instanceof String) {
                        try {
                            intValue = Integer.parseInt((String)value);
                        }
                        catch (NumberFormatException e) {
                            this.handleException("Incompatible value '" + value + "' for the Int", e);
                        }
                    } else if (value instanceof Integer) {
                        intValue = (Integer)value;
                    } else {
                        this.handleException("Incompatible type for the Int");
                    }
                    if (intValue != -1) {
                        queryEvaluator.setExternalVariable(name, (XdmValue)new XdmAtomicValue(String.valueOf(intValue), ItemType.INT));
                    }
                } else if (ItemType.LONG == type) {
                    long longValue = -1L;
                    if (value instanceof String) {
                        try {
                            longValue = Long.parseLong((String)value);
                        }
                        catch (NumberFormatException e) {
                            this.handleException("Incompatible value '" + value + "' for the long ", e);
                        }
                    } else if (value instanceof Long) {
                        longValue = (Long)value;
                    } else {
                        this.handleException("Incompatible type for the Long");
                    }
                    if (longValue != -1L) {
                        queryEvaluator.setExternalVariable(name, (XdmValue)new XdmAtomicValue(String.valueOf(longValue), ItemType.LONG));
                    }
                } else if (ItemType.SHORT == type) {
                    int shortValue = -1;
                    if (value instanceof String) {
                        try {
                            shortValue = Short.parseShort((String)value);
                        }
                        catch (NumberFormatException e) {
                            this.handleException("Incompatible value '" + value + "' for the short ", e);
                        }
                    } else if (value instanceof Short) {
                        shortValue = ((Short)value).shortValue();
                    } else {
                        this.handleException("Incompatible type for the Short");
                    }
                    if (shortValue != -1) {
                        queryEvaluator.setExternalVariable(name, (XdmValue)new XdmAtomicValue(String.valueOf(shortValue), ItemType.SHORT));
                    }
                } else if (ItemType.DOUBLE == type) {
                    double doubleValue = -1.0;
                    if (value instanceof String) {
                        try {
                            doubleValue = Double.parseDouble((String)value);
                        }
                        catch (NumberFormatException e) {
                            this.handleException("Incompatible value '" + value + "' for the double ", e);
                        }
                    } else if (value instanceof Double) {
                        doubleValue = (Double)value;
                    } else {
                        this.handleException("Incompatible type for the Double");
                    }
                    if (doubleValue != -1.0) {
                        queryEvaluator.setExternalVariable(name, (XdmValue)new XdmAtomicValue(String.valueOf(doubleValue), ItemType.DOUBLE));
                    }
                } else if (ItemType.FLOAT == type) {
                    float floatValue = -1.0f;
                    if (value instanceof String) {
                        try {
                            floatValue = Float.parseFloat((String)value);
                        }
                        catch (NumberFormatException e) {
                            this.handleException("Incompatible value '" + value + "' for the float ", e);
                        }
                    } else if (value instanceof Float) {
                        floatValue = ((Float)value).floatValue();
                    } else {
                        this.handleException("Incompatible type for the Float");
                    }
                    if (floatValue != -1.0f) {
                        queryEvaluator.setExternalVariable(name, (XdmValue)new XdmAtomicValue(String.valueOf(floatValue), ItemType.FLOAT));
                    }
                } else if (ItemType.BYTE == type) {
                    int byteValue = -1;
                    if (value instanceof String) {
                        try {
                            byteValue = Byte.parseByte((String)value);
                        }
                        catch (NumberFormatException e) {
                            this.handleException("Incompatible value '" + value + "' for the byte ", e);
                        }
                    } else if (value instanceof Byte) {
                        byteValue = ((Byte)value).byteValue();
                    } else {
                        this.handleException("Incompatible type for the Byte");
                    }
                    if (byteValue != -1) {
                        queryEvaluator.setExternalVariable(name, (XdmValue)new XdmAtomicValue(String.valueOf(byteValue), ItemType.BYTE));
                    }
                } else if (ItemType.STRING == type) {
                    if (value instanceof String) {
                        queryEvaluator.setExternalVariable(name, (XdmValue)new XdmAtomicValue(String.valueOf(value), ItemType.STRING));
                    } else {
                        this.handleException("Incompatible type for the String");
                    }
                } else if (XdmNodeKind.DOCUMENT == nodeKind || XdmNodeKind.ELEMENT == nodeKind) {
                    this.setOMNode(name, value, queryEvaluator, this.cachedProcessor);
                } else {
                    this.handleException("Unsupported  type for the binding type" + type + " in the variable name " + name);
                }
            }
        } else {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((Object)("Null variable value encountered for variable name: " + name));
            }
            queryEvaluator.setExternalVariable(name, null);
        }
    }

    private void setOMNode(QName name, Object value, XQueryEvaluator queryEvaluator, Processor processor) throws SaxonApiException {
        OMElement variableValue = null;
        if (value instanceof String) {
            variableValue = SynapseConfigUtils.stringToOM((String)((String)value));
        } else if (value instanceof OMElement) {
            variableValue = (OMElement)value;
        }
        if (variableValue != null) {
            DocumentBuilder documentBuilder = processor.newDocumentBuilder();
            if (this.useDOMSource) {
                XdmNode xdmNode = documentBuilder.build((Source)new DOMSource(((Element)ElementHelper.importOMElement((OMElement)variableValue, (OMFactory)DOOMAbstractFactory.getOMFactory())).getOwnerDocument()));
                queryEvaluator.setExternalVariable(name, (XdmValue)xdmNode);
            } else {
                StreamSource streamSource = new StreamSource(SynapseConfigUtils.getInputStream((Object)variableValue));
                XdmNode xdmNode = documentBuilder.build((Source)streamSource);
                queryEvaluator.setExternalVariable(name, (XdmValue)xdmNode);
            }
        }
    }

    private static ItemType getItemType(XdmItem item, Processor process) throws SaxonApiException {
        return new ItemTypeFactory(process).getAtomicType(((XdmAtomicValue)item).getPrimitiveTypeName());
    }

    private void handleException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }

    private void handleException(String msg) {
        this.log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public Value getQueryKey() {
        return this.queryKey;
    }

    public void setQueryKey(Value queryKey) {
        this.queryKey = queryKey;
    }

    public String getQuerySource() {
        return this.querySource;
    }

    public void setQuerySource(String querySource) {
        this.querySource = querySource;
    }

    public void addAllVariables(List<MediatorVariable> list) {
        this.variables.addAll(list);
    }

    public void addVariable(MediatorVariable variable) {
        this.variables.add(variable);
    }

    public List<MediatorProperty> getProcessorProperties() {
        return this.processorProperties;
    }

    public List<MediatorVariable> getVariables() {
        return this.variables;
    }

    public SynapseXPath getTarget() {
        return this.target.getXPath();
    }

    public void setTarget(SynapseXPath source) {
        this.target.setXPath(source);
    }

    public void addAllDataSourceProperties(List<MediatorProperty> list) {
        this.processorProperties.addAll(list);
    }

    public boolean isUseDOMSource() {
        return this.useDOMSource;
    }

    public void setUseDOMSource(boolean useDOMSource) {
        this.useDOMSource = useDOMSource;
    }

    public boolean isContentAltering() {
        return true;
    }
}

