/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.throttle;

import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SequenceMediatorFactory;
import org.apache.synapse.mediators.throttle.ThrottleMediator;

public class ThrottleMediatorFactory
extends AbstractMediatorFactory {
    private static final QName TAG_NAME = new QName("http://ws.apache.org/ns/synapse", "throttle");

    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        ThrottleMediator throttleMediator = new ThrottleMediator();
        OMElement policy = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "policy"));
        if (policy != null) {
            OMAttribute key = policy.getAttribute(new QName("", "key"));
            if (key != null) {
                String keyValue = key.getAttributeValue();
                if (keyValue != null && !"".equals(keyValue)) {
                    throttleMediator.setPolicyKey(keyValue);
                } else {
                    this.handleException("key attribute should have a value ");
                }
            } else {
                OMElement inLine = policy.getFirstElement();
                if (inLine != null) {
                    throttleMediator.setInLinePolicy(inLine);
                }
            }
        }
        this.processAuditStatus((Mediator)throttleMediator, elem);
        String id = elem.getAttributeValue(new QName("", "id"));
        if (id != null && !"".equals(id)) {
            throttleMediator.setId(id.trim());
        } else {
            this.handleException("Idy attribute must have defined ");
        }
        SequenceMediatorFactory mediatorFactory = new SequenceMediatorFactory();
        OMAttribute onReject = elem.getAttribute(new QName("", "onReject"));
        if (onReject != null) {
            String onRejectValue = onReject.getAttributeValue();
            if (onRejectValue != null) {
                throttleMediator.setOnRejectSeqKey(onRejectValue.trim());
            }
        } else {
            OMElement onRejectMediatorElement = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "onReject"));
            if (onRejectMediatorElement != null) {
                throttleMediator.setOnRejectMediator((Mediator)mediatorFactory.createAnonymousSequence(onRejectMediatorElement, properties));
            }
        }
        OMAttribute onAccept = elem.getAttribute(new QName("", "onAccept"));
        if (onAccept != null) {
            String onAcceptValue = onAccept.getAttributeValue();
            if (onAcceptValue != null) {
                throttleMediator.setOnAcceptSeqKey(onAcceptValue);
            }
        } else {
            OMElement onAcceptMediatorElement = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "onAccept"));
            if (onAcceptMediatorElement != null) {
                throttleMediator.setOnAcceptMediator((Mediator)mediatorFactory.createAnonymousSequence(onAcceptMediatorElement, properties));
            }
        }
        ThrottleMediatorFactory.addAllCommentChildrenToList((OMElement)elem, (List)throttleMediator.getCommentsList());
        return throttleMediator;
    }

    public QName getTagQName() {
        return TAG_NAME;
    }
}

