/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.throttle;

import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.commons.throttle.core.AccessInformation;
import org.apache.synapse.commons.throttle.core.AccessRateController;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessController;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessReplicator;
import org.apache.synapse.commons.throttle.core.Throttle;
import org.apache.synapse.commons.throttle.core.ThrottleConfiguration;
import org.apache.synapse.commons.throttle.core.ThrottleContext;
import org.apache.synapse.commons.throttle.core.ThrottleDataHolder;
import org.apache.synapse.commons.throttle.core.ThrottleException;
import org.apache.synapse.commons.throttle.core.ThrottleFactory;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.continuation.ReliantContinuationState;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.debug.constructs.EnclosedInlinedSequence;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.FlowContinuableMediator;
import org.apache.synapse.mediators.base.SequenceMediator;

public class ThrottleMediator
extends AbstractMediator
implements ManagedLifecycle,
FlowContinuableMediator,
EnclosedInlinedSequence {
    private String policyKey = null;
    private OMElement inLinePolicy = null;
    private String onRejectSeqKey = null;
    private Mediator onRejectMediator = null;
    private String onAcceptSeqKey = null;
    private Mediator onAcceptMediator = null;
    private String id;
    private AccessRateController accessControler;
    private ConcurrentAccessController concurrentAccessController = null;
    private ConcurrentAccessReplicator concurrentAccessReplicator;
    private ConfigurationContext configContext;
    private ThrottleDataHolder dataHolder;
    private String key;
    private boolean isClusteringEnable = false;
    private Throttle throttle;
    private final Object throttleLock = new Object();
    private long version;
    private static final String SYMBOL_UNDERSCORE = "_";

    /*
     * Enabled aggressive block sorting
     */
    public boolean mediate(MessageContext synCtx) {
        boolean canAccess;
        SynapseLog synLog;
        block21: {
            if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
                return true;
            }
            synLog = this.getLog(synCtx);
            boolean isResponse = synCtx.isResponse();
            canAccess = true;
            if (!isResponse) {
                Mediator mediator;
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)"Start : Throttle mediator");
                    if (synLog.isTraceTraceEnabled()) {
                        synLog.traceTrace((Object)("Message : " + synCtx.getEnvelope()));
                    }
                }
                this.doInitializeThrottleDynamicPolicy(synCtx, synLog);
                if (this.concurrentAccessController != null) {
                    canAccess = this.doThrottleByConcurrency(isResponse, synLog);
                }
                if (this.throttle != null && !isResponse && canAccess) {
                    org.apache.axis2.context.MessageContext axisMC = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                    canAccess = this.doThrottleByAccessRate(synCtx, axisMC, this.configContext, synLog);
                }
                if (this.concurrentAccessController != null) {
                    synCtx.setProperty("synapse.concurrency.throttle", (Object)true);
                    synCtx.setProperty("synapse.concurrency.throttle.key", (Object)this.key);
                    synCtx.setProperty("synapse.concurrent.access.controller", (Object)this.concurrentAccessController);
                }
                if (this.isClusteringEnable) {
                    synCtx.setProperty("synapse.concurrent.access.replicator", (Object)this.concurrentAccessReplicator);
                }
                if (canAccess) {
                    if (this.isClusteringEnable && this.concurrentAccessController != null) {
                        if (synLog.isTraceOrDebugEnabled()) {
                            synLog.traceOrDebug((Object)("Going to replicates the  states of the ConcurrentAccessController with key : " + this.key));
                        }
                        this.concurrentAccessReplicator.replicate(this.key, Boolean.valueOf(false));
                    }
                    synCtx.setProperty("synapse.is.concurrent.access.allowed", (Object)true);
                    if (this.onAcceptSeqKey != null) {
                        mediator = synCtx.getSequence(this.onAcceptSeqKey);
                        if (mediator != null) {
                            ContinuationStackManager.updateSeqContinuationState((MessageContext)synCtx, (int)this.getMediatorPosition());
                            return mediator.mediate(synCtx);
                        }
                        this.handleException("Unable to find onAccept sequence with key : " + this.onAcceptSeqKey, synCtx);
                        break block21;
                    } else {
                        if (this.onAcceptMediator == null) {
                            return true;
                        }
                        ContinuationStackManager.addReliantContinuationState((MessageContext)synCtx, (int)0, (int)this.getMediatorPosition());
                        boolean result = this.onAcceptMediator.mediate(synCtx);
                        if (result) {
                            ContinuationStackManager.removeReliantContinuationState((MessageContext)synCtx);
                        }
                        return result;
                    }
                }
                synCtx.setProperty("synapse.is.concurrent.access.allowed", (Object)false);
                if (this.onRejectSeqKey != null) {
                    mediator = synCtx.getSequence(this.onRejectSeqKey);
                    if (mediator != null) {
                        ContinuationStackManager.updateSeqContinuationState((MessageContext)synCtx, (int)this.getMediatorPosition());
                        return mediator.mediate(synCtx);
                    }
                    this.handleException("Unable to find onReject sequence with key : " + this.onRejectSeqKey, synCtx);
                } else {
                    if (this.onRejectMediator == null) {
                        return false;
                    }
                    ContinuationStackManager.addReliantContinuationState((MessageContext)synCtx, (int)1, (int)this.getMediatorPosition());
                    boolean result = this.onRejectMediator.mediate(synCtx);
                    if (result) {
                        ContinuationStackManager.removeReliantContinuationState((MessageContext)synCtx);
                    }
                    return result;
                }
            }
        }
        synLog.traceOrDebug((Object)"End : Throttle mediator");
        return canAccess;
    }

    public boolean mediate(MessageContext synCtx, ContinuationState continuationState) {
        boolean result;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"Throttle mediator : Mediating from ContinuationState");
        }
        boolean isStatisticsEnabled = RuntimeStatisticCollector.isStatisticsEnabled();
        int subBranch = ((ReliantContinuationState)continuationState).getSubBranch();
        if (subBranch == 0) {
            if (!continuationState.hasChild()) {
                result = ((SequenceMediator)this.onAcceptMediator).mediate(synCtx, continuationState.getPosition() + 1);
            } else {
                FlowContinuableMediator mediator = (FlowContinuableMediator)((SequenceMediator)this.onAcceptMediator).getChild(continuationState.getPosition());
                result = mediator.mediate(synCtx, continuationState.getChildContState());
                if (isStatisticsEnabled) {
                    ((Mediator)mediator).reportCloseStatistics(synCtx, null);
                }
            }
            if (isStatisticsEnabled) {
                this.onAcceptMediator.reportCloseStatistics(synCtx, null);
            }
        } else {
            if (!continuationState.hasChild()) {
                result = ((SequenceMediator)this.onRejectMediator).mediate(synCtx, continuationState.getPosition() + 1);
            } else {
                FlowContinuableMediator mediator = (FlowContinuableMediator)((SequenceMediator)this.onRejectMediator).getChild(continuationState.getPosition());
                result = mediator.mediate(synCtx, continuationState.getChildContState());
                if (isStatisticsEnabled) {
                    ((Mediator)mediator).reportCloseStatistics(synCtx, null);
                }
            }
            if (isStatisticsEnabled) {
                this.onRejectMediator.reportCloseStatistics(synCtx, null);
            }
        }
        return result;
    }

    private boolean doThrottleByConcurrency(boolean isResponse, SynapseLog synLog) {
        boolean canAccess = true;
        if (this.concurrentAccessController != null) {
            int concurrentLimit = this.concurrentAccessController.getLimit();
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((Object)("Concurrent access controller for ID : " + this.id + " allows : " + concurrentLimit + " concurrent accesses"));
            }
            if (!isResponse) {
                int available = this.concurrentAccessController.getAndDecrement();
                boolean bl = canAccess = available > 0;
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)("Concurrency Throttle : Access " + (canAccess ? "allowed" : "denied") + " :: " + available + " of available of " + concurrentLimit + " connections"));
                }
            }
        }
        return canAccess;
    }

    private boolean doThrottleByAccessRate(MessageContext synCtx, org.apache.axis2.context.MessageContext axisMC, ConfigurationContext cc, SynapseLog synLog) {
        AccessInformation accessInformation;
        ThrottleConfiguration config;
        ThrottleContext context;
        Object artifactName;
        String callerId = null;
        boolean canAccess = true;
        String remoteIP = (String)axisMC.getPropertyNonReplicable("REMOTE_ADDR");
        String domainName = (String)axisMC.getPropertyNonReplicable("REMOTE_HOST");
        Map headers = (Map)axisMC.getProperty("TRANSPORT_HEADERS");
        if (headers != null) {
            String xForwardHeader = (String)headers.get("X-Forwarded-For");
            String xForwardHost = (String)headers.get("X-Forwarded-Host");
            remoteIP = xForwardHeader != null ? xForwardHeader : remoteIP;
            domainName = xForwardHost != null ? xForwardHost : domainName;
        }
        String uniqueKey = (artifactName = synCtx.getProperty("ARTIFACT_NAME")) != null && !artifactName.toString().isEmpty() ? this.id + synCtx.getProperty("ARTIFACT_NAME") : this.id;
        uniqueKey = uniqueKey.concat(SYMBOL_UNDERSCORE);
        if (domainName != null) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((Object)("The Domain Name of the caller is :" + domainName));
            }
            if ((context = this.throttle.getThrottleContext("key_of_domain_based_throttle")) != null && (config = context.getThrottleConfiguration()) != null && (callerId = config.getConfigurationKeyOfCaller(domainName)) != null) {
                if (this.isClusteringEnable) {
                    context.setConfigurationContext(cc);
                    context.setThrottleId(uniqueKey + callerId);
                }
                try {
                    accessInformation = this.accessControler.canAccess(context, uniqueKey + callerId, 1);
                    canAccess = accessInformation.isAccessAllowed();
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug((Object)("Access " + (canAccess ? "allowed" : "denied") + " for Domain Name : " + domainName));
                    }
                    if (!canAccess && this.concurrentAccessController != null) {
                        this.concurrentAccessController.incrementAndGet();
                        if (this.isClusteringEnable) {
                            this.dataHolder.setConcurrentAccessController(this.key, this.concurrentAccessController);
                        }
                    }
                }
                catch (ThrottleException e) {
                    this.handleException("Error occurred during throttling", (Exception)((Object)e), synCtx);
                }
            }
        } else {
            synLog.traceOrDebug((Object)"The Domain name of the caller cannot be found");
        }
        if (callerId == null) {
            if (remoteIP == null) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)"The IP address of the caller cannot be found");
                }
                canAccess = true;
            } else {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)("The IP Address of the caller is :" + remoteIP));
                }
                try {
                    context = this.throttle.getThrottleContext("key_of_ip_based_throttle");
                    if (context != null && (config = context.getThrottleConfiguration()) != null && (callerId = config.getConfigurationKeyOfCaller(remoteIP)) != null) {
                        if (this.isClusteringEnable) {
                            context.setConfigurationContext(cc);
                            context.setThrottleId(uniqueKey + callerId);
                        }
                        accessInformation = this.accessControler.canAccess(context, uniqueKey + callerId, 0);
                        canAccess = accessInformation.isAccessAllowed();
                        if (synLog.isTraceOrDebugEnabled()) {
                            synLog.traceOrDebug((Object)("Access " + (canAccess ? "allowed" : "denied") + " for IP : " + remoteIP));
                        }
                        if (!canAccess && this.concurrentAccessController != null) {
                            this.concurrentAccessController.incrementAndGet();
                            if (this.isClusteringEnable) {
                                this.dataHolder.setConcurrentAccessController(this.key, this.concurrentAccessController);
                            }
                        }
                    }
                }
                catch (ThrottleException e) {
                    this.handleException("Error occurred during throttling", (Exception)((Object)e), synCtx);
                }
            }
        }
        return canAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitializeThrottleDynamicPolicy(MessageContext synCtx, SynapseLog synLog) {
        Entry entry;
        if (this.policyKey == null) {
            return;
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"Throttle mediator : Initializing dynamic Policy");
        }
        if ((entry = synCtx.getConfiguration().getEntryDefinition(this.policyKey)) == null) {
            this.handleException("Cannot find throttling policy using key : " + this.policyKey, synCtx);
        } else {
            boolean reCreate = false;
            if (entry.isDynamic() && (!entry.isCached() || entry.isExpired()) && this.version != entry.getVersion()) {
                reCreate = true;
                this.version = entry.getVersion();
            }
            if (reCreate || this.throttle == null) {
                Object entryValue = synCtx.getEntry(this.policyKey);
                if (entryValue == null) {
                    this.handleException("Null throttling policy returned by Entry : " + this.policyKey, synCtx);
                } else if (!(entryValue instanceof OMElement)) {
                    this.handleException("Policy returned from key : " + this.policyKey + " is not an OMElement", synCtx);
                } else {
                    if (this.isClusteringEnable && this.concurrentAccessController != null && this.throttle != null) {
                        this.concurrentAccessController = null;
                    }
                    try {
                        Object object = this.throttleLock;
                        synchronized (object) {
                            if (this.throttle == null) {
                                this.throttle = ThrottleFactory.createMediatorThrottle((Policy)PolicyEngine.getPolicy((OMElement)((OMElement)entryValue)));
                            }
                            if (!(this.throttle == null || this.concurrentAccessController != null && this.isClusteringEnable)) {
                                this.concurrentAccessController = this.throttle.getConcurrentAccessController();
                                if (this.concurrentAccessController != null) {
                                    this.dataHolder.setConcurrentAccessController(this.key, this.concurrentAccessController);
                                }
                            }
                        }
                    }
                    catch (ThrottleException e) {
                        this.handleException("Error processing the throttling policy", (Exception)((Object)e), synCtx);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(SynapseEnvironment se) {
        ClusteringAgent clusteringAgent;
        SequenceMediator onRejectSeq;
        SequenceMediator onAcceptSeq;
        if (this.onAcceptMediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.onAcceptMediator).init(se);
        } else if (this.onAcceptSeqKey != null && ((onAcceptSeq = (SequenceMediator)se.getSynapseConfiguration().getSequence(this.onAcceptSeqKey)) == null || onAcceptSeq.isDynamic())) {
            se.addUnavailableArtifactRef(this.onAcceptSeqKey);
        }
        if (this.onRejectMediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.onRejectMediator).init(se);
        } else if (this.onRejectSeqKey != null && ((onRejectSeq = (SequenceMediator)se.getSynapseConfiguration().getSequence(this.onRejectSeqKey)) == null || onRejectSeq.isDynamic())) {
            se.addUnavailableArtifactRef(this.onRejectSeqKey);
        }
        this.configContext = ((Axis2SynapseEnvironment)se).getAxis2ConfigurationContext();
        this.dataHolder = (ThrottleDataHolder)this.configContext.getProperty("throttle_info");
        if (this.dataHolder == null) {
            this.log.debug((Object)"Data holder not present in current Configuration Context");
            onRejectSeq = this.configContext;
            synchronized (onRejectSeq) {
                this.dataHolder = (ThrottleDataHolder)this.configContext.getProperty("throttle_info");
                if (this.dataHolder == null) {
                    this.dataHolder = new ThrottleDataHolder();
                    this.configContext.setNonReplicableProperty("throttle_info", (Object)this.dataHolder);
                }
            }
        }
        if ((clusteringAgent = this.configContext.getAxisConfiguration().getClusteringAgent()) != null) {
            this.isClusteringEnable = true;
        }
        if (this.inLinePolicy != null) {
            this.log.debug((Object)("Initializing using static throttling policy : " + this.inLinePolicy));
            try {
                this.throttle = ThrottleFactory.createMediatorThrottle((Policy)PolicyEngine.getPolicy((OMElement)this.inLinePolicy));
                if (this.throttle != null && this.concurrentAccessController == null) {
                    this.concurrentAccessController = this.throttle.getConcurrentAccessController();
                    if (this.concurrentAccessController != null) {
                        this.dataHolder.setConcurrentAccessController(this.key, this.concurrentAccessController);
                    }
                }
            }
            catch (ThrottleException e) {
                this.handleException("Error processing the throttling policy", (Exception)((Object)e), null);
            }
        }
        this.accessControler = new AccessRateController();
        if (this.isClusteringEnable) {
            this.concurrentAccessReplicator = new ConcurrentAccessReplicator(this.configContext);
        }
    }

    public void destroy() {
        if (this.configContext != null) {
            this.dataHolder.removeConcurrentAccessController(this.key);
        }
        if (this.onAcceptMediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.onAcceptMediator).destroy();
        }
        if (this.onRejectMediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.onRejectMediator).destroy();
        }
    }

    public String getPolicyKey() {
        return this.policyKey;
    }

    public void setPolicyKey(String policyKey) {
        this.policyKey = policyKey;
    }

    public OMElement getInLinePolicy() {
        return this.inLinePolicy;
    }

    public void setInLinePolicy(OMElement inLinePolicy) {
        this.inLinePolicy = inLinePolicy;
    }

    public String getOnRejectSeqKey() {
        return this.onRejectSeqKey;
    }

    public void setOnRejectSeqKey(String onRejectSeqKey) {
        this.onRejectSeqKey = onRejectSeqKey;
    }

    public Mediator getOnRejectMediator() {
        return this.onRejectMediator;
    }

    public void setOnRejectMediator(Mediator onRejectMediator) {
        this.onRejectMediator = onRejectMediator;
    }

    public String getOnAcceptSeqKey() {
        return this.onAcceptSeqKey;
    }

    public void setOnAcceptSeqKey(String onAcceptSeqKey) {
        this.onAcceptSeqKey = onAcceptSeqKey;
    }

    public Mediator getOnAcceptMediator() {
        return this.onAcceptMediator;
    }

    public void setOnAcceptMediator(Mediator onAcceptMediator) {
        this.onAcceptMediator = onAcceptMediator;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.key = "throttle_" + id + "_cac_key";
    }

    public boolean isContentAware() {
        return false;
    }

    public Mediator getInlineSequence(SynapseConfiguration synCfg, int inlinedSeqIdentifier) {
        if (inlinedSeqIdentifier == 0) {
            if (this.onRejectMediator != null) {
                return this.onRejectMediator;
            }
            if (this.onRejectSeqKey != null) {
                return synCfg.getSequence(this.onRejectSeqKey);
            }
        } else if (inlinedSeqIdentifier == 1) {
            if (this.onAcceptMediator != null) {
                return this.onAcceptMediator;
            }
            if (this.onAcceptSeqKey != null) {
                return synCfg.getSequence(this.onAcceptSeqKey);
            }
        }
        return null;
    }

    public void setComponentStatisticsId(ArtifactHolder holder) {
        String childId;
        if (this.getAspectConfiguration() == null) {
            this.configure(new AspectConfiguration(this.getMediatorName()));
        }
        String mediatorId = StatisticIdentityGenerator.getIdForFlowContinuableMediator((String)this.getMediatorName(), (ComponentType)ComponentType.MEDIATOR, (ArtifactHolder)holder);
        this.getAspectConfiguration().setUniqueId(mediatorId);
        if (this.onAcceptSeqKey != null) {
            childId = StatisticIdentityGenerator.getIdReferencingComponent((String)this.onAcceptSeqKey, (ComponentType)ComponentType.SEQUENCE, (ArtifactHolder)holder);
            StatisticIdentityGenerator.reportingEndEvent((String)childId, (ComponentType)ComponentType.SEQUENCE, (ArtifactHolder)holder);
        } else if (this.onAcceptMediator != null) {
            this.onAcceptMediator.setComponentStatisticsId(holder);
        }
        if (this.onRejectSeqKey != null) {
            childId = StatisticIdentityGenerator.getIdReferencingComponent((String)this.onRejectSeqKey, (ComponentType)ComponentType.SEQUENCE, (ArtifactHolder)holder);
            StatisticIdentityGenerator.reportingEndEvent((String)childId, (ComponentType)ComponentType.SEQUENCE, (ArtifactHolder)holder);
        } else if (this.onRejectMediator != null) {
            this.onRejectMediator.setComponentStatisticsId(holder);
        }
        StatisticIdentityGenerator.reportingFlowContinuableEndEvent((String)mediatorId, (ComponentType)ComponentType.MEDIATOR, (ArtifactHolder)holder);
    }
}

