/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.bsf;

import com.google.gson.JsonParser;
import com.sun.phobos.script.javascript.RhinoScriptEngineFactory;
import com.sun.script.groovy.GroovyScriptEngineFactory;
import com.sun.script.jruby.JRubyScriptEngineFactory;
import com.sun.script.jython.JythonScriptEngineFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.activation.DataHandler;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.bsf.xml.XMLHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.commons.util.MiscellaneousUtil;
import org.apache.synapse.config.Entry;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.bsf.CommonScriptMessageContext;
import org.apache.synapse.mediators.bsf.JavaScriptXmlHelper;
import org.apache.synapse.mediators.bsf.NashornJavaScriptMessageContext;
import org.apache.synapse.mediators.bsf.NashornJavaScriptXmlHelper;
import org.apache.synapse.mediators.bsf.ScriptEngineWrapper;
import org.apache.synapse.mediators.bsf.ScriptMessageContext;
import org.apache.synapse.mediators.eip.EIPUtils;
import org.mozilla.javascript.Context;

public class ScriptMediator
extends AbstractMediator {
    private static final Log logger = LogFactory.getLog((String)ScriptMediator.class.getName());
    private static final String MC_VAR_NAME = "mc";
    private static final String JAVA_SCRIPT = "js";
    private static final String NASHORN_JAVA_SCRIPT = "nashornJs";
    private static final String NASHORN = "nashorn";
    private Value key;
    private String language;
    private final Map<Value, Object> includes;
    private String function = "mediate";
    private String scriptSourceCode;
    protected ScriptEngine scriptEngine;
    protected ScriptEngine jsEngine;
    private boolean multiThreadedEngine;
    private ScriptObjectMirror emptyJsonObject;
    private ScriptObjectMirror jsonSerializer;
    private CompiledScript compiledScript;
    private XMLHelper xmlHelper;
    private ScriptEngineManager engineManager;
    private int DEFAULT_POOL_SIZE;
    private int poolSize = this.DEFAULT_POOL_SIZE = 15;
    private static String POOL_SIZE_PROPERTY = "synapse.script.mediator.pool.size";
    private BlockingQueue<ScriptEngineWrapper> pool;
    private JsonParser jsonParser;
    private ClassLoader loader;

    public ScriptMediator(String language, String scriptSourceCode, ClassLoader classLoader) {
        this.language = language;
        this.scriptSourceCode = scriptSourceCode;
        this.setLoader(classLoader);
        this.includes = new TreeMap<Value, Object>();
        this.initInlineScript();
    }

    public ScriptMediator(String language, Map<Value, Object> includeKeysMap, Value key, String function, ClassLoader classLoader) {
        this.language = language;
        this.key = key;
        this.setLoader(classLoader);
        this.includes = includeKeysMap;
        if (function != null) {
            this.function = function;
        }
        Properties properties = MiscellaneousUtil.loadProperties((String)"synapse.properties");
        this.poolSize = Integer.parseInt(properties.getProperty(POOL_SIZE_PROPERTY, String.valueOf(this.DEFAULT_POOL_SIZE)));
        this.initScriptEngine();
        if (!(this.scriptEngine instanceof Invocable)) {
            throw new SynapseException("Script engine is not an Invocable engine for language: " + language);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mediate(MessageContext synCtx) {
        boolean returnValue;
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"Start : Script mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)("Scripting language : " + this.language + " source " + (this.key == null ? ": specified inline " : " loaded with key : " + this.key) + (this.function != null ? " function : " + this.function : "")));
        }
        if (this.multiThreadedEngine) {
            returnValue = this.invokeScript(synCtx);
        } else {
            Class<?> clazz = this.scriptEngine.getClass();
            synchronized (clazz) {
                returnValue = this.invokeScript(synCtx);
            }
        }
        if (synLog.isTraceTraceEnabled()) {
            synLog.traceTrace((Object)("Result message after execution of script : " + synCtx.getEnvelope()));
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)("End : Script mediator return value : " + returnValue));
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeScript(MessageContext synCtx) {
        boolean returnValue;
        try {
            if (this.language.equals(JAVA_SCRIPT)) {
                Context cx = Context.enter();
                cx.setApplicationClassLoader(this.loader);
            }
            Object returnObject = this.key != null ? this.mediateWithExternalScript(synCtx) : this.mediateForInlineScript(synCtx);
            returnValue = returnObject == null || !(returnObject instanceof Boolean) || (Boolean)returnObject != false;
        }
        catch (ScriptException e) {
            this.handleException("The script engine returned an error executing the " + (this.key == null ? "inlined " : "external ") + this.language + " script" + (this.key != null ? " : " + this.key : "") + (this.function != null ? " function " + this.function : ""), e, synCtx);
            returnValue = false;
        }
        catch (NoSuchMethodException e) {
            this.handleException("The script engine returned a NoSuchMethodException executing the external " + this.language + " script : " + this.key + (this.function != null ? " function " + this.function : ""), e, synCtx);
            returnValue = false;
        }
        catch (Exception e) {
            this.handleException("The script engine returned an Exception executing the external " + this.language + " script : " + this.key + (this.function != null ? " function " + this.function : ""), e, synCtx);
            returnValue = false;
        }
        finally {
            if (this.language.equals(JAVA_SCRIPT)) {
                Context.exit();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object mediateWithExternalScript(MessageContext synCtx) throws ScriptException, NoSuchMethodException {
        Object obj;
        ScriptEngineWrapper sew = null;
        try {
            sew = this.prepareExternalScript(synCtx);
            XMLHelper helper = this.language.equalsIgnoreCase(JAVA_SCRIPT) || this.language.equals(NASHORN_JAVA_SCRIPT) ? this.xmlHelper : XMLHelper.getArgHelper((ScriptEngine)sew.getEngine());
            ScriptMessageContext scriptMC = this.getScriptMessageContext(synCtx, helper);
            this.processJSONPayload(synCtx, scriptMC);
            Invocable invocableScript = (Invocable)((Object)sew.getEngine());
            obj = invocableScript.invokeFunction(this.function, scriptMC);
        }
        finally {
            if (sew != null) {
                this.pool.offer(sew);
            }
        }
        return obj;
    }

    private ScriptMessageContext getScriptMessageContext(MessageContext synCtx, XMLHelper helper) {
        ScriptMessageContext scriptMC;
        if (this.language.equals(NASHORN_JAVA_SCRIPT)) {
            try {
                this.emptyJsonObject = (ScriptObjectMirror)this.scriptEngine.eval("({})");
                this.jsonSerializer = (ScriptObjectMirror)this.scriptEngine.eval("JSON");
            }
            catch (ScriptException e) {
                throw new SynapseException("Error occurred while evaluating empty json object", (Throwable)e);
            }
            scriptMC = new NashornJavaScriptMessageContext(synCtx, helper, this.emptyJsonObject, this.jsonSerializer);
        } else {
            scriptMC = new CommonScriptMessageContext(synCtx, helper);
        }
        return scriptMC;
    }

    private Object mediateForInlineScript(MessageContext synCtx) throws ScriptException {
        ScriptMessageContext scriptMC = this.getScriptMessageContext(synCtx, this.xmlHelper);
        this.processJSONPayload(synCtx, scriptMC);
        Bindings bindings = this.scriptEngine.createBindings();
        bindings.put(MC_VAR_NAME, (Object)scriptMC);
        Object response = this.compiledScript != null ? this.compiledScript.eval(bindings) : this.scriptEngine.eval(this.scriptSourceCode, bindings);
        return response;
    }

    private void processJSONPayload(MessageContext synCtx, ScriptMessageContext scriptMC) throws ScriptException {
        if (!(synCtx instanceof Axis2MessageContext)) {
            return;
        }
        org.apache.axis2.context.MessageContext messageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        String jsonString = (String)messageContext.getProperty("JSON_STRING");
        Object jsonObject = null;
        this.prepareForJSON(scriptMC);
        if (JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)messageContext)) {
            try {
                String jsonPayload = JsonUtil.jsonPayloadToString((org.apache.axis2.context.MessageContext)messageContext);
                if (NASHORN_JAVA_SCRIPT.equals(this.language)) {
                    jsonObject = this.jsonSerializer.callMember("parse", new Object[]{jsonPayload});
                }
                String scriptWithJsonParser = "JSON.parse(JSON.stringify(" + jsonPayload + "))";
                jsonObject = this.jsEngine.eval('(' + scriptWithJsonParser + ')');
            }
            catch (ScriptException e) {
                throw new ScriptException("Invalid JSON payload", e.getFileName(), e.getLineNumber(), e.getColumnNumber());
            }
        } else if (jsonString != null) {
            String jsonPayload = EIPUtils.tryParseJsonString((JsonParser)this.jsonParser, (String)jsonString).toString();
            jsonObject = this.jsEngine.eval('(' + jsonPayload + ')');
        }
        if (jsonObject != null) {
            scriptMC.setJsonObject(synCtx, jsonObject);
        }
    }

    private void prepareForJSON(ScriptMessageContext scriptMC) {
        if (this.jsonParser == null) {
            this.jsonParser = new JsonParser();
        }
        scriptMC.setScriptEngine(this.jsEngine);
    }

    protected void initInlineScript() {
        try {
            this.initScriptEngine();
            if (this.scriptEngine instanceof Compilable) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Script engine supports Compilable interface, compiling script code..");
                }
                this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(this.scriptSourceCode);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Script engine does not support the Compilable interface, in-lined script would be evaluated on each invocation..");
            }
        }
        catch (ScriptException e) {
            throw new SynapseException("Exception initializing inline script", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScriptEngineWrapper prepareExternalScript(MessageContext synCtx) throws ScriptException {
        String generatedScriptKey = this.key.evaluateValue(synCtx);
        Entry entry = synCtx.getConfiguration().getEntryDefinition(generatedScriptKey);
        boolean needsReload = entry != null && entry.isDynamic() && (!entry.isCached() || entry.isExpired());
        ScriptEngineWrapper sew = this.getNewScriptEngine();
        Bindings engineBinding = sew.getEngine().getBindings(100);
        engineBinding.clear();
        if (this.scriptSourceCode == null || needsReload || !sew.isInitialized()) {
            DataHandler dataHandler;
            Object o = synCtx.getEntry(generatedScriptKey);
            if (o instanceof OMElement) {
                this.scriptSourceCode = ((OMElement)o).getText();
                sew.getEngine().eval(this.scriptSourceCode, engineBinding);
            } else if (o instanceof String) {
                this.scriptSourceCode = (String)o;
                sew.getEngine().eval(this.scriptSourceCode, engineBinding);
            } else if (o instanceof OMText && (dataHandler = (DataHandler)((OMText)o).getDataHandler()) != null) {
                BufferedReader reader = null;
                try {
                    String currentLine;
                    reader = new BufferedReader(new InputStreamReader(dataHandler.getInputStream()));
                    StringBuilder scriptSB = new StringBuilder();
                    while ((currentLine = reader.readLine()) != null) {
                        scriptSB.append(currentLine).append('\n');
                    }
                    this.scriptSourceCode = scriptSB.toString();
                    sew.getEngine().eval(this.scriptSourceCode, engineBinding);
                }
                catch (IOException e) {
                    this.handleException("Error in reading script as a stream ", e, synCtx);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            this.handleException("Error in closing input stream ", e, synCtx);
                        }
                    }
                }
            }
        } else {
            sew.getEngine().eval(this.scriptSourceCode, engineBinding);
        }
        for (Value includeKey : this.includes.keySet()) {
            boolean includeEntryNeedsReload;
            String includeSourceCode = (String)this.includes.get(includeKey);
            String generatedKey = includeKey.evaluateValue(synCtx);
            Entry includeEntry = synCtx.getConfiguration().getEntryDefinition(generatedKey);
            boolean bl = includeEntryNeedsReload = includeEntry != null && includeEntry.isDynamic() && (!includeEntry.isCached() || includeEntry.isExpired());
            if (includeSourceCode == null || includeEntryNeedsReload || !sew.isInitialized()) {
                DataHandler dataHandler;
                this.log.debug((Object)("Re-/Loading the include script with key " + includeKey));
                Object o = synCtx.getEntry(generatedKey);
                if (o instanceof OMElement) {
                    includeSourceCode = ((OMElement)o).getText();
                    sew.getEngine().eval(includeSourceCode, engineBinding);
                } else if (o instanceof String) {
                    includeSourceCode = (String)o;
                    sew.getEngine().eval(includeSourceCode, engineBinding);
                } else if (o instanceof OMText && (dataHandler = (DataHandler)((OMText)o).getDataHandler()) != null) {
                    BufferedReader reader = null;
                    try {
                        String currentLine;
                        reader = new BufferedReader(new InputStreamReader(dataHandler.getInputStream()));
                        StringBuilder scriptSB = new StringBuilder();
                        while ((currentLine = reader.readLine()) != null) {
                            scriptSB.append(currentLine).append('\n');
                        }
                        includeSourceCode = scriptSB.toString();
                        sew.getEngine().eval(includeSourceCode, engineBinding);
                    }
                    catch (IOException e) {
                        this.handleException("Error in reading script as a stream ", e, synCtx);
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                this.handleException("Error in closing input stream ", e, synCtx);
                            }
                        }
                    }
                }
                this.includes.put(includeKey, includeSourceCode);
                continue;
            }
            sew.getEngine().eval(includeSourceCode, engineBinding);
        }
        sew.setInitialized(true);
        return sew;
    }

    protected void initScriptEngine() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing script mediator for language : " + this.language));
        }
        this.engineManager = new ScriptEngineManager();
        if (!this.language.equals(NASHORN_JAVA_SCRIPT)) {
            this.engineManager.registerEngineExtension("jsEngine", (ScriptEngineFactory)new RhinoScriptEngineFactory());
        }
        this.engineManager.registerEngineExtension(JAVA_SCRIPT, (ScriptEngineFactory)new RhinoScriptEngineFactory());
        this.engineManager.registerEngineExtension("groovy", (ScriptEngineFactory)new GroovyScriptEngineFactory());
        this.engineManager.registerEngineExtension("rb", (ScriptEngineFactory)new JRubyScriptEngineFactory());
        this.engineManager.registerEngineExtension("py", (ScriptEngineFactory)new JythonScriptEngineFactory());
        this.scriptEngine = this.language.equals(NASHORN_JAVA_SCRIPT) ? this.engineManager.getEngineByName(NASHORN) : this.engineManager.getEngineByExtension(this.language);
        this.pool = new LinkedBlockingQueue<ScriptEngineWrapper>(this.poolSize);
        for (int i = 0; i < this.poolSize; ++i) {
            ScriptEngineWrapper sew = this.language.equals(NASHORN_JAVA_SCRIPT) ? new ScriptEngineWrapper(this.engineManager.getEngineByName(NASHORN)) : new ScriptEngineWrapper(this.engineManager.getEngineByExtension(this.language));
            this.pool.add(sew);
        }
        this.jsEngine = this.language.equals(NASHORN_JAVA_SCRIPT) ? this.engineManager.getEngineByName(NASHORN) : this.engineManager.getEngineByExtension("jsEngine");
        if (this.scriptEngine == null) {
            this.handleException("No script engine found for language: " + this.language);
        }
        this.xmlHelper = this.language.equalsIgnoreCase(JAVA_SCRIPT) ? new JavaScriptXmlHelper() : (this.language.equals(NASHORN_JAVA_SCRIPT) ? new NashornJavaScriptXmlHelper() : XMLHelper.getArgHelper((ScriptEngine)this.scriptEngine));
        this.multiThreadedEngine = this.scriptEngine.getFactory().getParameter("THREADING") != null;
        this.log.debug((Object)("Script mediator for language : " + this.language + " supports multithreading? : " + this.multiThreadedEngine));
    }

    public String getLanguage() {
        return this.language;
    }

    public Value getKey() {
        return this.key;
    }

    public String getFunction() {
        return this.function;
    }

    public String getScriptSrc() {
        return this.scriptSourceCode;
    }

    private void handleException(String msg) {
        this.log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public Map<Value, Object> getIncludeMap() {
        return this.includes;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public ScriptEngineWrapper getNewScriptEngine() {
        ScriptEngineWrapper scriptEngineWrapper = (ScriptEngineWrapper)this.pool.poll();
        if (scriptEngineWrapper == null) {
            scriptEngineWrapper = this.language.equals(NASHORN_JAVA_SCRIPT) ? new ScriptEngineWrapper(this.engineManager.getEngineByName(NASHORN)) : new ScriptEngineWrapper(this.engineManager.getEngineByExtension(this.language));
        }
        return scriptEngineWrapper;
    }

    public boolean isContentAltering() {
        return true;
    }
}

