/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.email;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.core.Property;
import org.wso2.carbon.event.output.adapter.email.EmailEventAdapter;

public class EmailEventAdapterFactory
extends OutputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.output.adapter.email.i18n.Resources", Locale.getDefault());
    private static final Log log = LogFactory.getLog(EmailEventAdapterFactory.class);

    public String getType() {
        return "email";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportedMessageFormats = new ArrayList<String>();
        supportedMessageFormats.add("text");
        supportedMessageFormats.add("xml");
        supportedMessageFormats.add("json");
        return supportedMessageFormats;
    }

    public List<Property> getStaticPropertyList() {
        ArrayList<Property> staticpropertyList = new ArrayList<Property>();
        Property smtplUserName = new Property("mail.smtp.user");
        smtplUserName.setDisplayName(this.resourceBundle.getString("mail.smtp.user"));
        smtplUserName.setRequired(false);
        Property smtpPassword = new Property("mail.smtp.password");
        smtpPassword.setDisplayName(this.resourceBundle.getString("mail.smtp.password"));
        smtpPassword.setRequired(false);
        Property smtpAuth = new Property("mail.smtp.auth");
        smtpAuth.setDisplayName(this.resourceBundle.getString("mail.smtp.auth"));
        smtpAuth.setRequired(false);
        Property smtpFrom = new Property("mail.smtp.from");
        smtpFrom.setDisplayName(this.resourceBundle.getString("mail.smtp.from"));
        smtpFrom.setRequired(false);
        Property smtpHost = new Property("mail.smtp.host");
        smtpHost.setDisplayName(this.resourceBundle.getString("mail.smtp.host"));
        smtpHost.setRequired(false);
        Property smtpPort = new Property("mail.smtp.port");
        smtpPort.setDisplayName(this.resourceBundle.getString("mail.smtp.port"));
        smtpPort.setRequired(false);
        Property startTLSEnable = new Property("mail.smtp.starttls.enable");
        startTLSEnable.setDisplayName(this.resourceBundle.getString("mail.smtp.starttls.enable"));
        startTLSEnable.setRequired(false);
        Property senderSignature = new Property("mail.smtp.signature");
        startTLSEnable.setDisplayName(this.resourceBundle.getString("mail.smtp.signature"));
        startTLSEnable.setRequired(false);
        Property replyToAddress = new Property("mail.smtp.replyTo");
        startTLSEnable.setDisplayName(this.resourceBundle.getString("mail.smtp.replyTo"));
        startTLSEnable.setRequired(false);
        staticpropertyList.add(smtplUserName);
        staticpropertyList.add(smtpPassword);
        staticpropertyList.add(smtpAuth);
        staticpropertyList.add(smtpFrom);
        staticpropertyList.add(smtpHost);
        staticpropertyList.add(smtpPort);
        staticpropertyList.add(startTLSEnable);
        staticpropertyList.add(senderSignature);
        staticpropertyList.add(replyToAddress);
        return staticpropertyList;
    }

    public List<Property> getDynamicPropertyList() {
        ArrayList<Property> dynamicPropertyList = new ArrayList<Property>();
        Property emailAddress = new Property("email.address");
        emailAddress.setDisplayName(this.resourceBundle.getString("email.address"));
        emailAddress.setRequired(true);
        emailAddress.setHint(this.resourceBundle.getString("emailAddress.hint"));
        Property subject = new Property("email.subject");
        subject.setDisplayName(this.resourceBundle.getString("email.subject"));
        subject.setRequired(true);
        Property format = new Property("email.type");
        format.setDisplayName(this.resourceBundle.getString("email.type"));
        format.setRequired(false);
        format.setOptions(new String[]{"text/plain", "text/html"});
        format.setDefaultValue("text/plain");
        format.setHint(this.resourceBundle.getString("emailType.hint"));
        dynamicPropertyList.add(emailAddress);
        dynamicPropertyList.add(subject);
        dynamicPropertyList.add(format);
        return dynamicPropertyList;
    }

    public String getUsageTips() {
        return null;
    }

    public OutputEventAdapter createEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new EmailEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

