/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.email;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.ConnectionUnavailableException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;

public class EmailEventAdapter
implements OutputEventAdapter {
    private static final Log log = LogFactory.getLog(EmailEventAdapter.class);
    private static ThreadPoolExecutor threadPoolExecutor;
    private Session session;
    private OutputEventAdapterConfiguration eventAdapterConfiguration;
    private Map<String, String> globalProperties;
    private int tenantId;
    private InternetAddress smtpFromAddress = null;
    private InternetAddress[] smtpReplyToAddress = null;
    private String signature = null;

    public EmailEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
    }

    public void init() throws OutputEventAdapterException {
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (threadPoolExecutor == null) {
            int minThread = this.globalProperties.get("minThread") != null ? Integer.parseInt(this.globalProperties.get("minThread")) : 8;
            int maxThread = this.globalProperties.get("maxThread") != null ? Integer.parseInt(this.globalProperties.get("maxThread")) : 100;
            long defaultKeepAliveTime = this.globalProperties.get("keepAliveTimeInMillis") != null ? (long)Integer.parseInt(this.globalProperties.get("keepAliveTimeInMillis")) : 20000L;
            int jobQueSize = this.globalProperties.get("jobQueueSize") != null ? Integer.parseInt(this.globalProperties.get("jobQueueSize")) : 2000;
            threadPoolExecutor = new ThreadPoolExecutor(minThread, maxThread, defaultKeepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(jobQueSize));
        }
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("Test connection is not available");
    }

    public void connect() throws ConnectionUnavailableException {
        if (this.session == null) {
            Properties props = new Properties();
            props.putAll(this.globalProperties);
            String smtpFrom = props.getProperty("mail.smtp.from");
            String smtpHost = props.getProperty("mail.smtp.host");
            String smtpPort = props.getProperty("mail.smtp.port");
            this.signature = props.getProperty("mail.smtp.signature");
            if (smtpFrom == null) {
                String msg = "failed to connect to the mail server due to null smtpFrom value";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg);
                }
                throw new ConnectionUnavailableException("The adapter " + this.eventAdapterConfiguration.getName() + " " + msg);
            }
            if (smtpHost == null) {
                String msg = "failed to connect to the mail server due to null smtpHost value";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg);
                }
                throw new ConnectionUnavailableException("The adapter " + this.eventAdapterConfiguration.getName() + " " + msg);
            }
            if (smtpPort == null) {
                String msg = "failed to connect to the mail server due to null smtpPort value";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg);
                }
                throw new ConnectionUnavailableException("The adapter " + this.eventAdapterConfiguration.getName() + " " + msg);
            }
            String replyTo = props.getProperty("mail.smtp.replyTo");
            if (replyTo != null) {
                try {
                    this.smtpReplyToAddress = InternetAddress.parse((String)replyTo);
                }
                catch (AddressException e) {
                    log.error((Object)("Error in retrieving smtp replyTo address : " + smtpFrom), (Throwable)e);
                    String msg = "failed to connect to the mail server due to error in retrieving smtp replyTo address";
                    throw new ConnectionUnavailableException("The adapter " + this.eventAdapterConfiguration.getName() + " " + msg, (Throwable)e);
                }
            }
            try {
                this.smtpFromAddress = new InternetAddress(smtpFrom);
            }
            catch (AddressException e) {
                String msg = "failed to connect to the mail server due to error in retrieving smtp from address";
                if (log.isDebugEnabled()) {
                    log.debug((Object)(msg + ": " + smtpFrom));
                }
                throw new ConnectionUnavailableException("The adapter " + this.eventAdapterConfiguration.getName() + " " + msg, (Throwable)e);
            }
            final String smtpUsername = props.getProperty("mail.smtp.user");
            final String smtpPassword = props.getProperty("mail.smtp.password");
            if (smtpUsername != null && smtpPassword != null && !smtpUsername.isEmpty() && !smtpPassword.isEmpty()) {
                this.session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(smtpUsername, smtpPassword);
                    }
                });
            } else {
                this.session = Session.getInstance((Properties)props);
                log.info((Object)("Connecting adapter " + this.eventAdapterConfiguration.getName() + "without user authentication for tenant " + this.tenantId));
            }
        }
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        String subject = dynamicProperties.get("email.subject");
        String[] emailIds = dynamicProperties.get("email.address").replaceAll(" ", "").split(",");
        String emailType = dynamicProperties.get("email.type");
        for (String email : emailIds) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attempting to send an email to " + email));
            }
            try {
                threadPoolExecutor.submit(new EmailSender(email, subject, message.toString(), emailType));
            }
            catch (RejectedExecutionException e) {
                EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Job queue is full", (Throwable)e, (Log)log, (int)this.tenantId);
            }
        }
    }

    public void disconnect() {
    }

    public void destroy() {
    }

    public boolean isPolled() {
        return false;
    }

    private void LogMessagingException(MessagingException e, String mailRecipient, int recurseCount) {
        if (e instanceof SendFailedException) {
            Object[] unsent;
            Object[] invalid;
            ArrayList<String> sentMails = new ArrayList<String>();
            ArrayList<String> invalidMails = new ArrayList<String>();
            ArrayList<String> unsentMails = new ArrayList<String>();
            Object[] sent = ((SendFailedException)e).getValidSentAddresses();
            if (ArrayUtils.isNotEmpty((Object[])sent)) {
                for (Object address : sent) {
                    sentMails.add(address.toString());
                }
            }
            if (ArrayUtils.isNotEmpty((Object[])(invalid = ((SendFailedException)e).getInvalidAddresses()))) {
                for (Object address : invalid) {
                    invalidMails.add(address.toString());
                }
            }
            if (ArrayUtils.isNotEmpty((Object[])(unsent = ((SendFailedException)e).getValidUnsentAddresses()))) {
                for (Object address : unsent) {
                    unsentMails.add(address.toString());
                }
            }
            log.error((Object)String.format("Exception occurred when sending email to %s. %s. Sent email=%s, Invalid emails=%s, Unsent valid emails=%s", mailRecipient, e.getMessage(), StringUtils.join(sentMails, (String)","), StringUtils.join(invalidMails, (String)","), StringUtils.join(unsentMails, (String)",")), (Throwable)e);
        }
        log.error((Object)("Exception occurred when sending email to " + mailRecipient + ". " + e.getMessage()), (Throwable)e);
        Exception nextEx = e.getNextException();
        if (nextEx instanceof MessagingException) {
            if (recurseCount < 10) {
                this.LogMessagingException((MessagingException)((Object)nextEx), mailRecipient, recurseCount + 1);
            } else {
                log.warn((Object)("Over " + recurseCount + " chained exceptions found when logging MessagingExceptions. Stopping the exception check at this point."));
            }
        }
    }

    class EmailSender
    implements Runnable {
        String to;
        String subject;
        String body;
        String type;

        EmailSender(String to, String subject, String body, String type) {
            this.to = to;
            this.subject = subject;
            this.body = body;
            this.type = type;
        }

        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Format of the email: " + this.to + "->" + this.type));
            }
            MimeMessage message = new MimeMessage(EmailEventAdapter.this.session);
            try {
                if (EmailEventAdapter.this.signature != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Email Signature is configured as: " + EmailEventAdapter.this.signature));
                    }
                    message.setFrom((Address)new InternetAddress(EmailEventAdapter.this.smtpFromAddress.getAddress(), EmailEventAdapter.this.signature));
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Email Signature is not configured.");
                    }
                    message.setFrom((Address)EmailEventAdapter.this.smtpFromAddress);
                }
                if (EmailEventAdapter.this.smtpReplyToAddress != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Email reply to address is configured as: " + EmailEventAdapter.this.smtpReplyToAddress[0].getAddress()));
                    }
                    message.setReplyTo((Address[])EmailEventAdapter.this.smtpReplyToAddress);
                }
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.to));
                message.setSubject(this.subject);
                message.setSentDate(new Date());
                message.setContent((Object)this.body, this.type);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Meta data of the email configured successfully");
                }
                Transport.send((Message)message);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Mail sent to the EmailID " + this.to + " Successfully"));
                }
            }
            catch (MessagingException e) {
                EmailEventAdapter.this.LogMessagingException(e, this.to, 0);
                EventAdapterUtil.logAndDrop((String)EmailEventAdapter.this.eventAdapterConfiguration.getName(), (Object)message, (String)"Error in message format", (Throwable)e, (Log)log, (int)EmailEventAdapter.this.tenantId);
            }
            catch (Exception e) {
                EventAdapterUtil.logAndDrop((String)EmailEventAdapter.this.eventAdapterConfiguration.getName(), (Object)message, (String)("Error sending email to '" + this.to + "'"), (Throwable)e, (Log)log, (int)EmailEventAdapter.this.tenantId);
            }
        }
    }
}

