/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.view.appenders;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.logging.view.data.LogEvent;
import org.wso2.carbon.utils.logging.CircularBuffer;

public class LoggingAppender
implements PaxAppender {
    private CircularBuffer<LogEvent> circularBuffer;
    private static String ip;

    public LoggingAppender(CircularBuffer<LogEvent> logBuffer) {
        this.circularBuffer = logBuffer;
    }

    public void doAppend(PaxLoggingEvent paxLoggingEvent) {
        LogEvent logEvent = new LogEvent();
        logEvent.setMessage(paxLoggingEvent.getMessage());
        logEvent.setLogger(paxLoggingEvent.getLoggerName());
        logEvent.setPriority(paxLoggingEvent.getLevel().toString());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        logEvent.setLogTime(simpleDateFormat.format(paxLoggingEvent.getTimeStamp()));
        logEvent.setServerName(this.getServerName());
        logEvent.setTenantId(this.getTenantId());
        logEvent.setIp(ip);
        logEvent.setAppName(this.getAppName());
        if (paxLoggingEvent.getThrowableStrRep() != null) {
            logEvent.setStacktrace(String.join((CharSequence)"\n", paxLoggingEvent.getThrowableStrRep()));
        } else {
            logEvent.setStacktrace("");
        }
        this.circularBuffer.append((Object)logEvent);
    }

    private String getServerName() {
        return AccessController.doPrivileged(() -> ServerConfiguration.getInstance().getFirstProperty("ServerKey"));
    }

    private String getIp() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return localHost.getHostAddress();
        }
        catch (UnknownHostException var3) {
            return "127.0.0.1";
        }
    }

    private String getTenantId() {
        int tenantId = AccessController.doPrivileged(() -> CarbonContext.getThreadLocalCarbonContext().getTenantId());
        return String.valueOf(tenantId);
    }

    private String getAppName() {
        String appName = CarbonContext.getThreadLocalCarbonContext().getApplicationName();
        return appName != null ? appName : "";
    }

    static {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            ip = localHost.getHostAddress();
        }
        catch (UnknownHostException var3) {
            ip = "127.0.0.1";
        }
    }
}

