/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.idp.metadata.saml2.util;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.idp.metadata.saml2.IDPMetadataConstant;
import org.wso2.carbon.identity.idp.metadata.saml2.builder.DefaultIDPMetadataBuilder;
import org.wso2.carbon.identity.idp.metadata.saml2.internal.IDPMetadataSAMLServiceComponentHolder;
import org.wso2.carbon.identity.idp.metadata.saml2.util.SAML2SSOFederatedAuthenticatorConfigBuilder;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderSAMLException;
import org.wso2.carbon.idp.mgt.MetadataException;
import org.wso2.carbon.idp.mgt.util.MetadataConverter;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class SAMLMetadataConverter
implements MetadataConverter {
    public boolean canHandle(Property property) {
        if (property != null) {
            String meta = property.getName();
            if (meta != null && meta.contains(IDPMetadataConstant.SAML)) {
                return property.getValue() != null && property.getValue().length() > 0;
            }
            return false;
        }
        return false;
    }

    public boolean canDelete(int tenantId, String idPName) throws IdentityProviderManagementException {
        try {
            UserRegistry registry = IDPMetadataSAMLServiceComponentHolder.getInstance().getRegistryService().getGovernanceSystemRegistry(tenantId);
            return registry.resourceExists("repository/identity/provider/saml/" + idPName);
        }
        catch (RegistryException e) {
            throw new IdentityProviderManagementException("Error while checking the registry for the IDP.", (Throwable)e);
        }
    }

    public FederatedAuthenticatorConfig getFederatedAuthenticatorConfig(Property[] properties, StringBuilder builder) throws XMLStreamException, IdentityProviderManagementException {
        FederatedAuthenticatorConfig federatedAuthenticatorConfigMetadata;
        OMElement element;
        String metadata = "";
        String META_DATA_SAML = "meta_data_saml";
        for (Property property : properties) {
            if (property == null || !"meta_data_saml".equals(property.getName())) continue;
            metadata = property.getValue();
        }
        if (metadata.equals("")) {
            throw new IdentityProviderManagementException("No metadata found");
        }
        metadata = this.configureCertificate(metadata);
        try {
            element = AXIOMUtil.stringToOM((String)metadata);
        }
        catch (XMLStreamException ex) {
            throw new XMLStreamException("Invalid metadata content, Failed to convert to OMElement", ex);
        }
        try {
            federatedAuthenticatorConfigMetadata = SAML2SSOFederatedAuthenticatorConfigBuilder.build(element, builder);
        }
        catch (IdentityApplicationManagementException ex) {
            throw new IdentityProviderManagementException("Invalid file content", (Throwable)ex);
        }
        return federatedAuthenticatorConfigMetadata;
    }

    private Node getIDPSSODescriptor(Document document) {
        if (document.getElementsByTagName("IDPSSODescriptor").item(0) != null) {
            if (document.getElementsByTagName("IDPSSODescriptor").item(0).getNodeType() == 1) {
                return document.getElementsByTagName("IDPSSODescriptor").item(0);
            }
        } else if (document.getElementsByTagName("md:IDPSSODescriptor").item(0) != null && document.getElementsByTagName("md:IDPSSODescriptor").item(0).getNodeType() == 1) {
            return document.getElementsByTagName("md:IDPSSODescriptor").item(0);
        }
        return null;
    }

    private NodeList getKeyDescriptors(Element idpSSODescriptor) {
        if (idpSSODescriptor.getElementsByTagName("KeyDescriptor").item(0) != null) {
            return idpSSODescriptor.getElementsByTagName("KeyDescriptor");
        }
        if (idpSSODescriptor.getElementsByTagName("md:KeyDescriptor").item(0) != null) {
            return idpSSODescriptor.getElementsByTagName("md:KeyDescriptor");
        }
        return null;
    }

    private Node getKeyInfoImpl(Element keyDescriptor) {
        if (keyDescriptor.getElementsByTagName("KeyInfo").item(0) != null) {
            return keyDescriptor.getElementsByTagName("KeyInfo").item(0);
        }
        if (keyDescriptor.getElementsByTagName("ds:KeyInfo").item(0) != null) {
            return keyDescriptor.getElementsByTagName("ds:KeyInfo").item(0);
        }
        return null;
    }

    private Node getX509Data(Element keyInfo) {
        if (keyInfo.getElementsByTagName("X509Data").item(0) != null) {
            return keyInfo.getElementsByTagName("X509Data").item(0);
        }
        if (keyInfo.getElementsByTagName("ds:X509Data").item(0) != null) {
            return keyInfo.getElementsByTagName("ds:X509Data").item(0);
        }
        return null;
    }

    private Node getX509Certificate(Element X509Data2) {
        if (X509Data2.getElementsByTagName("X509Certificate").item(0) != null) {
            return X509Data2.getElementsByTagName("X509Certificate").item(0);
        }
        if (X509Data2.getElementsByTagName("ds:X509Certificate").item(0) != null) {
            return X509Data2.getElementsByTagName("ds:X509Certificate").item(0);
        }
        return null;
    }

    private String configureCertificate(String metadataOriginal) throws IdentityProviderManagementException {
        String metadata = "";
        DocumentBuilderFactory factory = IdentityUtil.getSecuredDocumentBuilderFactory();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(metadataOriginal.getBytes()));
            document.getDocumentElement().normalize();
            if (this.getIDPSSODescriptor(document) != null && this.getKeyDescriptors((Element)this.getIDPSSODescriptor(document)) != null) {
                for (int i = 0; i < this.getKeyDescriptors((Element)this.getIDPSSODescriptor(document)).getLength(); ++i) {
                    if (this.getKeyDescriptors((Element)this.getIDPSSODescriptor(document)).item(i).getNodeType() != 1 || !"signing".equalsIgnoreCase(((Element)this.getKeyDescriptors((Element)this.getIDPSSODescriptor(document)).item(i)).getAttribute("use")) || this.getKeyInfoImpl((Element)this.getKeyDescriptors((Element)this.getIDPSSODescriptor(document)).item(i)) == null || this.getX509Data((Element)this.getKeyInfoImpl((Element)this.getKeyDescriptors((Element)this.getIDPSSODescriptor(document)).item(i))) == null || this.getX509Certificate((Element)this.getX509Data((Element)this.getKeyInfoImpl((Element)this.getKeyDescriptors((Element)this.getIDPSSODescriptor(document)).item(i)))) == null) continue;
                    String cert = this.getX509Certificate((Element)this.getX509Data((Element)this.getKeyInfoImpl((Element)this.getKeyDescriptors((Element)this.getIDPSSODescriptor(document)).item(i)))).getTextContent();
                    if (!cert.contains("-----BEGIN CERTIFICATE-----") || !cert.contains("-----END CERTIFICATE-----")) {
                        cert = "\n-----BEGIN CERTIFICATE-----\n" + cert + "\n-----END CERTIFICATE-----\n";
                    }
                    this.getX509Certificate((Element)this.getX509Data((Element)this.getKeyInfoImpl((Element)this.getKeyDescriptors((Element)this.getIDPSSODescriptor(document)).item(i)))).setTextContent(cert);
                }
            }
            StringWriter stringWriter = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, streamResult);
            stringWriter.close();
            metadata = stringWriter.toString();
        }
        catch (Exception ex) {
            throw new IdentityProviderManagementException("Error Configuring certificate", (Throwable)ex);
        }
        return metadata;
    }

    public String getMetadataString(FederatedAuthenticatorConfig federatedAuthenticatorConfig) throws IdentityProviderSAMLException {
        DefaultIDPMetadataBuilder builder = new DefaultIDPMetadataBuilder();
        try {
            return builder.build(federatedAuthenticatorConfig);
        }
        catch (MetadataException ex) {
            throw new IdentityProviderSAMLException("Error invoking build in IDPMetadataBuilder", (Throwable)ex);
        }
    }

    public boolean canHandle(FederatedAuthenticatorConfig federatedAuthenticatorConfig) {
        return federatedAuthenticatorConfig != null && federatedAuthenticatorConfig.getName().equals("samlsso");
    }

    public void deleteMetadataString(int tenantId, String idPName) throws IdentityProviderManagementException {
        block9: {
            try {
                UserRegistry registry = IDPMetadataSAMLServiceComponentHolder.getInstance().getRegistryService().getGovernanceSystemRegistry(tenantId);
                String samlIdpPath = "repository/identity/provider/saml/";
                String path = samlIdpPath + idPName;
                try {
                    if (!registry.resourceExists(path)) break block9;
                    boolean isTransactionStarted = Transaction.isStarted();
                    try {
                        if (!isTransactionStarted) {
                            registry.beginTransaction();
                        }
                        registry.delete(path);
                        if (!isTransactionStarted) {
                            registry.commitTransaction();
                        }
                    }
                    catch (RegistryException e) {
                        if (!isTransactionStarted) {
                            registry.rollbackTransaction();
                        }
                        throw new IdentityProviderManagementException("Error while deleting metadata String in registry for " + idPName, (Throwable)e);
                    }
                }
                catch (RegistryException e) {
                    throw new IdentityProviderManagementException("Error while deleting Identity Provider", (Throwable)e);
                }
            }
            catch (RegistryException e) {
                throw new IdentityProviderManagementException("Error while setting a registry object in IdentityProviderManager", (Throwable)e);
            }
        }
    }

    public void saveMetadataString(int tenantId, String idpName, String fedAuthName, String metadata) throws IdentityProviderManagementException {
        try {
            UserRegistry registry = IDPMetadataSAMLServiceComponentHolder.getInstance().getRegistryService().getGovernanceSystemRegistry(tenantId);
            String identityPath = "repository/identity/";
            String identityProvidersPath = "repository/identity/provider/";
            String samlIdPPath = "repository/identity/provider/saml/" + idpName;
            String path = samlIdPPath + "/" + fedAuthName;
            Resource resource = registry.newResource();
            resource.setContent((Object)metadata);
            boolean isTransactionStarted = Transaction.isStarted();
            if (!isTransactionStarted) {
                registry.beginTransaction();
            }
            try {
                Collection idpCollection;
                if (!registry.resourceExists(identityPath)) {
                    idpCollection = registry.newCollection();
                    registry.put(identityPath, (Resource)idpCollection);
                }
                if (!registry.resourceExists(identityProvidersPath)) {
                    idpCollection = registry.newCollection();
                    registry.put(identityProvidersPath, (Resource)idpCollection);
                }
                if (!registry.resourceExists("repository/identity/provider/saml/")) {
                    Collection samlIdpCollection = registry.newCollection();
                    registry.put("repository/identity/provider/saml/", (Resource)samlIdpCollection);
                }
                if (!registry.resourceExists(samlIdPPath)) {
                    Collection samlIdPAuthCollection = registry.newCollection();
                    registry.put(samlIdPPath, (Resource)samlIdPAuthCollection);
                }
                if (!registry.resourceExists(path)) {
                    registry.put(path, resource);
                } else {
                    registry.delete(path);
                    registry.put(path, resource);
                }
                if (!isTransactionStarted) {
                    registry.commitTransaction();
                }
            }
            catch (RegistryException e) {
                if (!isTransactionStarted) {
                    registry.rollbackTransaction();
                }
                throw new IdentityProviderManagementException("Error while creating resource in registry", (Throwable)e);
            }
        }
        catch (RegistryException e) {
            throw new IdentityProviderManagementException("Error while setting a registry object in IdentityProviderManager", (Throwable)e);
        }
    }
}

