/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.idp.metadata.saml2.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.idp.metadata.saml2.util.BuilderUtil;

public class SAML2SSOFederatedAuthenticatorConfigBuilder {
    private static final Log log = LogFactory.getLog(SAML2SSOFederatedAuthenticatorConfigBuilder.class);
    private static final String SIGNING = "SIGNING";
    private static final String ENCRYPTION = "ENCRYPTION";

    private static EntityDescriptor generateMetadataObjectFromString(String metadataString) throws IdentityApplicationManagementException {
        EntityDescriptor entityDescriptor;
        try {
            BuilderUtil.doBootstrap();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(metadataString.trim().getBytes(StandardCharsets.UTF_8));
            entityDescriptor = (EntityDescriptor)XMLObjectSupport.unmarshallFromInputStream((ParserPool)XMLObjectProviderRegistrySupport.getParserPool(), (InputStream)inputStream);
        }
        catch (XMLParserException | UnmarshallingException e) {
            throw new IdentityApplicationManagementException("Error while converting file content to entity descriptor", e);
        }
        return entityDescriptor;
    }

    private static FederatedAuthenticatorConfig parse(EntityDescriptor entityDescriptor, FederatedAuthenticatorConfig federatedAuthenticatorConfig, StringBuilder builder) throws IdentityApplicationManagementException {
        if (entityDescriptor != null) {
            List roleDescriptors = entityDescriptor.getRoleDescriptors();
            if (CollectionUtils.isNotEmpty((Collection)roleDescriptors)) {
                RoleDescriptor roleDescriptor = (RoleDescriptor)roleDescriptors.get(0);
                if (roleDescriptor != null) {
                    KeyDescriptor descriptor;
                    IDPSSODescriptor idpssoDescriptor;
                    try {
                        idpssoDescriptor = (IDPSSODescriptor)roleDescriptor;
                    }
                    catch (ClassCastException ex) {
                        throw new IdentityApplicationManagementException("No IDP Descriptors found, invalid file content", (Throwable)ex);
                    }
                    Property[] properties = new Property[24];
                    Property property = new Property();
                    property.setName("IdPEntityId");
                    if (entityDescriptor.getEntityID() == null || entityDescriptor.getEntityID().length() <= 0) {
                        property.setValue("");
                        throw new IdentityApplicationManagementException("No Entity ID found, invalid file content");
                    }
                    property.setValue(entityDescriptor.getEntityID());
                    properties[0] = property;
                    property = new Property();
                    property.setName("SPEntityId");
                    property.setValue("");
                    properties[1] = property;
                    property = new Property();
                    property.setName("SSOUrl");
                    List singleSignOnServices = idpssoDescriptor.getSingleSignOnServices();
                    if (CollectionUtils.isNotEmpty((Collection)singleSignOnServices)) {
                        boolean found = false;
                        for (int j = 0; j < singleSignOnServices.size(); ++j) {
                            SingleSignOnService singleSignOnService = (SingleSignOnService)singleSignOnServices.get(j);
                            if (singleSignOnService == null || singleSignOnService.getLocation() == null) continue;
                            property.setValue(singleSignOnService.getLocation());
                            found = true;
                            break;
                        }
                        if (!found) {
                            property.setValue("");
                            throw new IdentityApplicationManagementException("No SSO URL, invalid file content");
                        }
                    } else {
                        property.setValue("");
                        throw new IdentityApplicationManagementException("No SSO URL, invalid file content");
                    }
                    properties[2] = property;
                    property = new Property();
                    property.setName("ISAuthnReqSigned");
                    if (idpssoDescriptor.getWantAuthnRequestsSigned() != null && idpssoDescriptor.getWantAuthnRequestsSigned().booleanValue()) {
                        property.setValue("true");
                    } else {
                        property.setValue("false");
                    }
                    properties[3] = property;
                    property = new Property();
                    property.setName("IsLogoutEnabled");
                    List singleLogoutServices = idpssoDescriptor.getSingleLogoutServices();
                    if (CollectionUtils.isNotEmpty((Collection)singleLogoutServices)) {
                        property.setValue("true");
                    } else {
                        property.setValue("false");
                    }
                    properties[4] = property;
                    property = new Property();
                    property.setName("LogoutReqUrl");
                    if (CollectionUtils.isNotEmpty((Collection)singleLogoutServices)) {
                        boolean foundSingleLogoutServicePostBinding = false;
                        for (SingleLogoutService singleLogoutService : singleLogoutServices) {
                            if (singleLogoutService == null || singleLogoutService.getBinding() == null || !singleLogoutService.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST") || singleLogoutService.getLocation() == null) continue;
                            property.setValue(singleLogoutService.getLocation());
                            foundSingleLogoutServicePostBinding = true;
                            break;
                        }
                        if (!foundSingleLogoutServicePostBinding) {
                            for (SingleLogoutService singleLogoutService : singleLogoutServices) {
                                if (singleLogoutService == null || singleLogoutService.getBinding() == null || singleLogoutService.getLocation() == null) continue;
                                property.setValue(singleLogoutService.getLocation());
                                foundSingleLogoutServicePostBinding = true;
                                break;
                            }
                        }
                        if (!foundSingleLogoutServicePostBinding) {
                            property.setValue("");
                        }
                    } else {
                        property.setValue("");
                    }
                    properties[5] = property;
                    property = new Property();
                    property.setName("IsLogoutReqSigned");
                    property.setValue("");
                    properties[6] = property;
                    property = new Property();
                    property.setName("IsAuthnRespSigned");
                    property.setValue("");
                    properties[7] = property;
                    property = new Property();
                    property.setName("IsUserIdInClaims");
                    property.setValue("");
                    properties[8] = property;
                    property = new Property();
                    property.setName("IsAssertionEncrypted");
                    property.setValue("");
                    properties[9] = property;
                    property = new Property();
                    property.setName("isAssertionSigned");
                    property.setValue("");
                    properties[10] = property;
                    List descriptors = idpssoDescriptor.getKeyDescriptors();
                    if (CollectionUtils.isNotEmpty((Collection)descriptors)) {
                        for (int i = 0; i < descriptors.size(); ++i) {
                            descriptor = (KeyDescriptor)descriptors.get(i);
                            if (descriptor == null) continue;
                            String use = "";
                            try {
                                use = descriptor.getUse().name().toString();
                            }
                            catch (Exception ex) {
                                log.error((Object)"Error !!!!", (Throwable)ex);
                            }
                            if (SIGNING.equals(use)) {
                                properties[10].setValue("true");
                                continue;
                            }
                            if (!ENCRYPTION.equals(use)) continue;
                            properties[9].setValue("true");
                        }
                    }
                    property = new Property();
                    property.setName("commonAuthQueryParams");
                    property.setValue("");
                    properties[11] = property;
                    property = new Property();
                    property.setName("RequestMethod");
                    property.setValue("");
                    properties[12] = property;
                    property = new Property();
                    property.setName("SignatureAlgorithm");
                    property.setValue("");
                    properties[13] = property;
                    property = new Property();
                    property.setName("DigestAlgorithm");
                    property.setValue("");
                    properties[14] = property;
                    property = new Property();
                    property.setName("AuthnContextComparisonLevel");
                    property.setValue("");
                    properties[15] = property;
                    property = new Property();
                    property.setName("IncludeNameIDPolicy");
                    property.setValue("");
                    properties[16] = property;
                    property = new Property();
                    property.setName("ForceAuthentication");
                    property.setValue("");
                    properties[17] = property;
                    property = new Property();
                    property.setName("SignatureAlgorithmPost");
                    property.setValue("");
                    properties[18] = property;
                    property = new Property();
                    property.setName("AuthnContextClassRef");
                    property.setValue("");
                    properties[19] = property;
                    property = new Property();
                    property.setName("AttributeConsumingServiceIndex");
                    property.setValue("");
                    properties[20] = property;
                    property = new Property();
                    property.setName("IncludeCert");
                    property.setValue("");
                    properties[21] = property;
                    property = new Property();
                    property.setName("IncludeAuthnContext");
                    property.setValue("");
                    properties[22] = property;
                    property = new Property();
                    property.setName("IncludeProtocolBinding");
                    property.setValue("");
                    properties[23] = property;
                    federatedAuthenticatorConfig.setProperties(properties);
                    if (CollectionUtils.isNotEmpty((Collection)descriptors)) {
                        for (int i = 0; i < descriptors.size(); ++i) {
                            descriptor = (KeyDescriptor)descriptors.get(i);
                            if (descriptor == null || descriptor.getUse() == null || !SIGNING.equals(descriptor.getUse().toString())) continue;
                            try {
                                String cert = null;
                                if (descriptor.getKeyInfo() == null || descriptor.getKeyInfo().getX509Datas() == null || descriptor.getKeyInfo().getX509Datas().size() <= 0) continue;
                                for (int k = 0; k < descriptor.getKeyInfo().getX509Datas().size(); ++k) {
                                    if (descriptor.getKeyInfo().getX509Datas().get(k) == null || ((X509Data)descriptor.getKeyInfo().getX509Datas().get(k)).getX509Certificates() == null || ((X509Data)descriptor.getKeyInfo().getX509Datas().get(0)).getX509Certificates().size() <= 0) continue;
                                    for (int y = 0; y < ((X509Data)descriptor.getKeyInfo().getX509Datas().get(k)).getX509Certificates().size(); ++y) {
                                        if (((X509Data)descriptor.getKeyInfo().getX509Datas().get(k)).getX509Certificates().get(y) == null || ((X509Certificate)((X509Data)descriptor.getKeyInfo().getX509Datas().get(k)).getX509Certificates().get(y)).getValue() == null || ((X509Certificate)((X509Data)descriptor.getKeyInfo().getX509Datas().get(k)).getX509Certificates().get(y)).getValue().length() <= 0) continue;
                                        cert = ((X509Certificate)((X509Data)descriptor.getKeyInfo().getX509Datas().get(k)).getX509Certificates().get(y)).getValue().toString();
                                        builder.append(Base64.encode((byte[])cert.getBytes()));
                                        return federatedAuthenticatorConfig;
                                    }
                                }
                                continue;
                            }
                            catch (Exception ex) {
                                log.error((Object)"Error While setting Certificate", (Throwable)ex);
                                break;
                            }
                        }
                    }
                }
            } else {
                throw new IdentityApplicationManagementException("No Role Descriptors found, invalid file content");
            }
        }
        return federatedAuthenticatorConfig;
    }

    public static FederatedAuthenticatorConfig build(OMElement saml2FederatedAuthenticatorConfigOM, StringBuilder builder) throws IdentityApplicationManagementException {
        FederatedAuthenticatorConfig federatedAuthenticatorConfig = new FederatedAuthenticatorConfig();
        EntityDescriptor entityDescriptor = SAML2SSOFederatedAuthenticatorConfigBuilder.generateMetadataObjectFromString(saml2FederatedAuthenticatorConfigOM.toString());
        if (entityDescriptor == null) {
            throw new IdentityApplicationManagementException("Error while trying to convert to metadata, Invalid file content");
        }
        federatedAuthenticatorConfig = SAML2SSOFederatedAuthenticatorConfigBuilder.parse(entityDescriptor, federatedAuthenticatorConfig, builder);
        return federatedAuthenticatorConfig;
    }
}

