/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.idp.metadata.saml2.util;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.wso2.carbon.identity.saml.common.util.SAMLInitializer;
import org.wso2.carbon.idp.mgt.MetadataException;

public class BuilderUtil {
    private static boolean isBootStrapped = false;
    private static final Log log = LogFactory.getLog(BuilderUtil.class);

    public static void doBootstrap() {
        if (!isBootStrapped) {
            try {
                SAMLInitializer.doBootstrap();
                isBootStrapped = true;
            }
            catch (InitializationException e) {
                log.error((Object)"Error in bootstrapping the OpenSAML3 library", (Throwable)e);
            }
        }
    }

    public static <T> T createSAMLObject(String namespaceURI, String localName, String namespacePrefix) throws MetadataException {
        BuilderUtil.doBootstrap();
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building the SAML Object with namespaceURI: " + namespaceURI + " prefix:" + namespacePrefix));
        }
        QName qName = new QName(namespaceURI, localName, namespacePrefix);
        XMLObject object = builderFactory.getBuilder(qName).buildObject(qName);
        return (T)object;
    }
}

