/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.idp.metadata.saml2.processor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityMessageContext;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityProcessor;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityRequest;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityResponse;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.idp.metadata.saml2.bean.SAMLMetadataErrorResponse;
import org.wso2.carbon.identity.idp.metadata.saml2.bean.SAMLMetadataResponse;
import org.wso2.carbon.identity.idp.metadata.saml2.internal.IDPMetadataSAMLServiceComponentHolder;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;

public class IDPMetadataPublishProcessor
extends IdentityProcessor {
    private static final Log log = LogFactory.getLog(IDPMetadataPublishProcessor.class);
    private String relyingParty;

    public String getName() {
        return "IDPMetadataPublishProcessor";
    }

    public int getPriority() {
        return 2;
    }

    public String getCallbackPath(IdentityMessageContext context) {
        return IdentityUtil.getServerURL((String)"identity", (boolean)false, (boolean)false);
    }

    public String getRelyingPartyId() {
        return this.relyingParty;
    }

    public String getRelyingPartyId(IdentityMessageContext identityMessageContext) {
        return this.getRelyingPartyId();
    }

    public boolean canHandle(IdentityRequest identityRequest) {
        return identityRequest.getRequestURI().contains("/metadata/saml2");
    }

    public IdentityResponse.IdentityResponseBuilder process(IdentityRequest identityRequest) throws FrameworkException {
        String tennantDomain = identityRequest.getTenantDomain();
        IdentityProviderManager identityProviderManager = (IdentityProviderManager)IDPMetadataSAMLServiceComponentHolder.getInstance().getIdpManager();
        String metadata = null;
        try {
            metadata = identityProviderManager.getResidentIDPMetadata(tennantDomain);
        }
        catch (IdentityProviderManagementException ex) {
            IdentityMessageContext context = new IdentityMessageContext(identityRequest);
            SAMLMetadataErrorResponse.SAMLMetadataErrorResponseBuilder responseBuilder = new SAMLMetadataErrorResponse.SAMLMetadataErrorResponseBuilder(context);
            responseBuilder.setMessage("Internal Server Error");
            return responseBuilder;
        }
        IdentityMessageContext context = new IdentityMessageContext(identityRequest);
        SAMLMetadataResponse.SAMLMetadataResponseBuilder responseBuilder = new SAMLMetadataResponse.SAMLMetadataResponseBuilder(context);
        responseBuilder.setMetadata(metadata);
        return responseBuilder;
    }
}

