/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.idp.metadata.saml2.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityResponseFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityProcessor;
import org.wso2.carbon.identity.idp.metadata.saml2.bean.HttpSAMLMetadataResponseFactory;
import org.wso2.carbon.identity.idp.metadata.saml2.internal.IDPMetadataSAMLServiceComponentHolder;
import org.wso2.carbon.identity.idp.metadata.saml2.processor.IDPMetadataPublishProcessor;
import org.wso2.carbon.identity.idp.metadata.saml2.util.SAMLMetadataConverter;
import org.wso2.carbon.idp.mgt.IdpManager;
import org.wso2.carbon.idp.mgt.util.MetadataConverter;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="identity.provider.saml.service.component", immediate=true)
public class SAMLMetadataServiceComponent {
    private static final Log log = LogFactory.getLog(SAMLMetadataServiceComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        SAMLMetadataConverter converter = new SAMLMetadataConverter();
        context.getBundleContext().registerService(MetadataConverter.class.getName(), (Object)converter, null);
        context.getBundleContext().registerService(IdentityProcessor.class.getName(), (Object)new IDPMetadataPublishProcessor(), null);
        context.getBundleContext().registerService(HttpIdentityResponseFactory.class.getName(), (Object)new HttpSAMLMetadataResponseFactory(), null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"SAML metadata converter is enabled");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Management bundle is de-activated");
        }
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService is set in IDP Metadata bundle");
        }
        IDPMetadataSAMLServiceComponentHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Realm Service is set in the IDP Metadata bundle");
        }
        IDPMetadataSAMLServiceComponentHolder.getInstance().setRealmService(null);
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        IDPMetadataSAMLServiceComponentHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in IDP Metadata bundle");
        }
        IDPMetadataSAMLServiceComponentHolder.getInstance().setRegistryService(null);
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configCtxService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuration Context Service is set in the SAML SSO bundle");
        }
        IDPMetadataSAMLServiceComponentHolder.getInstance().setConfigCtxService(configCtxService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configCtxService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuration Context Service is unset in the SAML SSO bundle");
        }
        IDPMetadataSAMLServiceComponentHolder.getInstance().setConfigCtxService(null);
    }

    @Reference(name="osgi.httpservice", service=HttpService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetHttpService")
    protected void setHttpService(HttpService httpService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"HTTP Service is set in the SAML SSO bundle");
        }
        IDPMetadataSAMLServiceComponentHolder.getInstance().setHttpService(httpService);
    }

    protected void unsetHttpService(HttpService httpService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"HTTP Service is unset in the SAML SSO bundle");
        }
        IDPMetadataSAMLServiceComponentHolder.getInstance().setHttpService(null);
    }

    protected void unsetIdpManager(IdpManager idpManager) {
        IDPMetadataSAMLServiceComponentHolder.getInstance().setIdpManager(null);
    }

    @Reference(name="IdentityProviderManager", service=IdpManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdpManager")
    protected void setIdpManager(IdpManager idpManager) {
        IDPMetadataSAMLServiceComponentHolder.getInstance().setIdpManager(idpManager);
    }
}

