/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.idp.metadata.saml2.builder;

import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.core.handler.AbstractIdentityHandler;
import org.wso2.carbon.identity.idp.metadata.saml2.IDPMetadataConstant;
import org.wso2.carbon.identity.idp.metadata.saml2.util.BuilderUtil;
import org.wso2.carbon.idp.mgt.MetadataException;

public abstract class IDPMetadataBuilder
extends AbstractIdentityHandler {
    static final long ONE_MINUTE_IN_MILLIS = 60000L;
    private boolean samlMetadataSigningEnabled;
    private boolean samlAuthRequestSigningEnabled;

    public String build(FederatedAuthenticatorConfig samlFederatedAuthenticatorConfig) throws MetadataException {
        EntityDescriptor entityDescriptor = this.buildEntityDescriptor(samlFederatedAuthenticatorConfig);
        IDPSSODescriptor idpSsoDesc = this.buildIDPSSODescriptor();
        this.setValidityPeriod(idpSsoDesc, samlFederatedAuthenticatorConfig);
        this.buildSupportedProtocol(idpSsoDesc);
        this.buildSingleSignOnService(idpSsoDesc, samlFederatedAuthenticatorConfig);
        String samlSsoURL = this.getFederatedAuthenticatorConfigProperty(samlFederatedAuthenticatorConfig, "SSOUrl").getValue();
        this.samlAuthRequestSigningEnabled = Boolean.parseBoolean(this.getFederatedAuthenticatorConfigProperty(samlFederatedAuthenticatorConfig, "samlAuthnRequestsSigningEnabled").getValue());
        for (Property property : samlFederatedAuthenticatorConfig.getProperties()) {
            if (StringUtils.equals((String)samlSsoURL, (String)property.getValue()) || !StringUtils.startsWith((String)property.getName(), (String)"DestinationURI")) continue;
            SingleSignOnService ssoHTTPPost = (SingleSignOnService)BuilderUtil.createSAMLObject("urn:oasis:names:tc:SAML:2.0:metadata", "SingleSignOnService", "");
            ssoHTTPPost.setBinding(IDPMetadataConstant.HTTP_BINDING_POST_SAML2);
            ssoHTTPPost.setLocation(property.getValue());
            idpSsoDesc.getSingleSignOnServices().add(ssoHTTPPost);
            SingleSignOnService ssoHTTPRedirect = (SingleSignOnService)BuilderUtil.createSAMLObject("urn:oasis:names:tc:SAML:2.0:metadata", "SingleSignOnService", "");
            ssoHTTPRedirect.setBinding(IDPMetadataConstant.HTTP_BINDING_REDIRECT_SAML2);
            ssoHTTPRedirect.setLocation(property.getValue());
            idpSsoDesc.getSingleSignOnServices().add(ssoHTTPRedirect);
        }
        this.buildSingleLogOutService(idpSsoDesc, samlFederatedAuthenticatorConfig);
        this.buildArtifactResolutionService(idpSsoDesc, samlFederatedAuthenticatorConfig);
        entityDescriptor.getRoleDescriptors().add(idpSsoDesc);
        this.buildKeyDescriptor(entityDescriptor);
        this.buildExtensions(idpSsoDesc);
        idpSsoDesc.setWantAuthnRequestsSigned(Boolean.valueOf(this.samlAuthRequestSigningEnabled));
        this.setSamlMetadataSigningEnabled(samlFederatedAuthenticatorConfig);
        return this.marshallDescriptor(entityDescriptor);
    }

    private FederatedAuthenticatorConfig getSAMLFederatedAuthenticatorConfig(IdentityProvider identityProvider) {
        for (FederatedAuthenticatorConfig config : identityProvider.getFederatedAuthenticatorConfigs()) {
            if (!"samlsso".equals(config.getName())) continue;
            return config;
        }
        return null;
    }

    private Property getFederatedAuthenticatorConfigProperty(FederatedAuthenticatorConfig samlFederatedAuthenticatorConfig, String name) {
        Property[] properties = samlFederatedAuthenticatorConfig.getProperties();
        if (properties != null) {
            for (Property property : properties) {
                if (name == null || property == null || !name.equals(property.getName())) continue;
                return property;
            }
        }
        return null;
    }

    protected abstract EntityDescriptor buildEntityDescriptor(FederatedAuthenticatorConfig var1) throws MetadataException;

    protected abstract IDPSSODescriptor buildIDPSSODescriptor() throws MetadataException;

    protected abstract void buildValidityPeriod(IDPSSODescriptor var1) throws MetadataException;

    protected abstract void buildSupportedProtocol(IDPSSODescriptor var1) throws MetadataException;

    protected abstract void buildKeyDescriptor(EntityDescriptor var1) throws MetadataException;

    protected abstract void buildNameIdFormat(IDPSSODescriptor var1) throws MetadataException;

    protected abstract void buildSingleSignOnService(IDPSSODescriptor var1, FederatedAuthenticatorConfig var2) throws MetadataException;

    protected abstract void buildSingleLogOutService(IDPSSODescriptor var1, FederatedAuthenticatorConfig var2) throws MetadataException;

    protected abstract void buildArtifactResolutionService(IDPSSODescriptor var1, FederatedAuthenticatorConfig var2) throws MetadataException;

    protected abstract void buildExtensions(IDPSSODescriptor var1) throws MetadataException;

    protected abstract String marshallDescriptor(EntityDescriptor var1) throws MetadataException;

    protected void setValidityPeriod(IDPSSODescriptor idpSsoDesc, FederatedAuthenticatorConfig samlFederatedAuthenticatorConfig) throws MetadataException {
        try {
            DateTime currentTime = new DateTime();
            String validiyPeriodStr = this.getFederatedAuthenticatorConfigProperty(samlFederatedAuthenticatorConfig, "SAMLMetadataValidityPeriod").getValue();
            if (validiyPeriodStr == null) {
                throw new MetadataException("Setting validity period failed. Null value found.");
            }
            int validityPeriod = Integer.parseInt(validiyPeriodStr);
            DateTime validUntil = new DateTime(currentTime.getMillis() + (long)validityPeriod * 60000L);
            idpSsoDesc.setValidUntil(validUntil);
        }
        catch (NumberFormatException e) {
            throw new MetadataException("Setting validity period failed.", (Throwable)e);
        }
    }

    protected void setSamlMetadataSigningEnabled(FederatedAuthenticatorConfig samlFederatedAuthenticatorConfig) {
        this.samlMetadataSigningEnabled = Boolean.parseBoolean(this.getFederatedAuthenticatorConfigProperty(samlFederatedAuthenticatorConfig, "SAMLMetadataSigningEnabled").getValue());
    }

    protected boolean getSamlMetadataSigningEnabled() {
        return this.samlMetadataSigningEnabled;
    }

    public boolean isWantAuthRequestSigned() {
        return this.samlAuthRequestSigningEnabled;
    }

    public void setWantAuthRequestSigned(boolean samlAuthRequestSignedEnabled) {
        this.samlAuthRequestSigningEnabled = samlAuthRequestSignedEnabled;
    }
}

