/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.idp.metadata.saml2.builder;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import org.w3c.dom.Document;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.idp.metadata.saml2.IDPMetadataConstant;
import org.wso2.carbon.identity.idp.metadata.saml2.MetadataCryptoProvider;
import org.wso2.carbon.identity.idp.metadata.saml2.builder.IDPMetadataBuilder;
import org.wso2.carbon.identity.idp.metadata.saml2.util.BuilderUtil;
import org.wso2.carbon.idp.mgt.MetadataException;

public class DefaultIDPMetadataBuilder
extends IDPMetadataBuilder {
    private static final int PRIORITY = 50;
    private static final Log log = LogFactory.getLog(DefaultIDPMetadataBuilder.class);

    public int getPriority() {
        return 50;
    }

    @Override
    public String build(FederatedAuthenticatorConfig samlFederatedAuthenticatorConfig) throws MetadataException {
        return super.build(samlFederatedAuthenticatorConfig);
    }

    private Property getFederatedAuthenticatorConfigProperty(FederatedAuthenticatorConfig samlFederatedAuthenticatorConfig, String name) {
        for (Property property : samlFederatedAuthenticatorConfig.getProperties()) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    @Override
    public void buildExtensions(IDPSSODescriptor idpSsoDesc) throws MetadataException {
    }

    @Override
    public EntityDescriptor buildEntityDescriptor(FederatedAuthenticatorConfig samlFederatedAuthenticatorConfig) throws MetadataException {
        EntityDescriptor entityDescriptor = (EntityDescriptor)BuilderUtil.createSAMLObject("urn:oasis:names:tc:SAML:2.0:metadata", "EntityDescriptor", "");
        entityDescriptor.setEntityID(this.getFederatedAuthenticatorConfigProperty(samlFederatedAuthenticatorConfig, "IdPEntityId").getValue());
        entityDescriptor.setNoNamespaceSchemaLocation("");
        return entityDescriptor;
    }

    @Override
    public IDPSSODescriptor buildIDPSSODescriptor() throws MetadataException {
        IDPSSODescriptor idpSsoDesc = (IDPSSODescriptor)BuilderUtil.createSAMLObject(IDPMetadataConstant.IDP_METADATA_SAML2, "IDPSSODescriptor", "");
        return idpSsoDesc;
    }

    @Override
    public void buildValidityPeriod(IDPSSODescriptor idpSsoDesc) throws MetadataException {
        char unit = 'h';
        idpSsoDesc.setValidUntil(this.validityPeriod(1L, unit));
    }

    @Override
    public void buildSupportedProtocol(IDPSSODescriptor idpSsoDesc) throws MetadataException {
        idpSsoDesc.addSupportedProtocol(IDPMetadataConstant.SUPPORTED_PROTOCOL_SAML2);
    }

    @Override
    public void buildKeyDescriptor(EntityDescriptor entityDescriptor) throws MetadataException {
        MetadataCryptoProvider cryptoProvider = new MetadataCryptoProvider();
        cryptoProvider.signMetadata(entityDescriptor);
    }

    @Override
    public String marshallDescriptor(EntityDescriptor entityDescriptor) throws MetadataException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = IdentityUtil.getSecuredDocumentBuilderFactory();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MetadataException("Error while creating the document.", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Marshalling the metadata element contents");
        }
        Document document = builder.newDocument();
        Marshaller out = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)entityDescriptor);
        Signature signature = null;
        if (this.getSamlMetadataSigningEnabled()) {
            MetadataCryptoProvider cryptoProvider = new MetadataCryptoProvider();
            signature = cryptoProvider.getSignature(entityDescriptor);
        }
        try {
            out.marshall((XMLObject)entityDescriptor, document);
            if (signature != null) {
                Signer.signObject((Signature)signature);
            }
        }
        catch (MarshallingException e) {
            throw new MetadataException("Error while marshalling the descriptor.", (Throwable)e);
        }
        catch (SignatureException e) {
            throw new MetadataException("Error while signing the descriptor.", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Marshalling metadata completed.");
        }
        Init.init();
        StringWriter stringWriter = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, streamResult);
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)"Error Occurred while creating XML transformer", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error Occurred while creating XML transformer", (Throwable)e);
        }
        catch (TransformerException e) {
            log.error((Object)"Error Occurred while creating XML transformer", (Throwable)e);
        }
        return stringWriter.toString();
    }

    @Override
    public void buildNameIdFormat(IDPSSODescriptor idpSsoDesc) throws MetadataException {
        NameIDFormat nameIdFormat = (NameIDFormat)BuilderUtil.createSAMLObject("urn:oasis:names:tc:SAML:2.0:metadata", "NameIDFormat", "");
        nameIdFormat.setFormat(IDPMetadataConstant.NAME_FORMAT_ID_SAML);
        idpSsoDesc.getNameIDFormats().add(nameIdFormat);
    }

    @Override
    public void buildSingleSignOnService(IDPSSODescriptor idpSsoDesc, FederatedAuthenticatorConfig samlFederatedAuthenticatorConfig) throws MetadataException {
        SingleSignOnService ssoHTTPPost = (SingleSignOnService)BuilderUtil.createSAMLObject("urn:oasis:names:tc:SAML:2.0:metadata", "SingleSignOnService", "");
        ssoHTTPPost.setBinding(IDPMetadataConstant.HTTP_BINDING_POST_SAML2);
        ssoHTTPPost.setLocation(this.getFederatedAuthenticatorConfigProperty(samlFederatedAuthenticatorConfig, "SSOUrl").getValue());
        idpSsoDesc.getSingleSignOnServices().add(ssoHTTPPost);
        SingleSignOnService ssoHTTPRedirect = (SingleSignOnService)BuilderUtil.createSAMLObject("urn:oasis:names:tc:SAML:2.0:metadata", "SingleSignOnService", "");
        ssoHTTPRedirect.setBinding(IDPMetadataConstant.HTTP_BINDING_REDIRECT_SAML2);
        ssoHTTPRedirect.setLocation(this.getFederatedAuthenticatorConfigProperty(samlFederatedAuthenticatorConfig, "SSOUrl").getValue());
        idpSsoDesc.getSingleSignOnServices().add(ssoHTTPRedirect);
        SingleSignOnService ssoSOAP = (SingleSignOnService)BuilderUtil.createSAMLObject("urn:oasis:names:tc:SAML:2.0:metadata", "SingleSignOnService", "");
        ssoSOAP.setBinding(IDPMetadataConstant.SOAP_BINDING_SAML2);
        ssoSOAP.setLocation(this.getFederatedAuthenticatorConfigProperty(samlFederatedAuthenticatorConfig, "ECPUrl").getValue());
    }

    @Override
    public void buildSingleLogOutService(IDPSSODescriptor idpSsoDesc, FederatedAuthenticatorConfig samlFederatedAuthenticatorConfig) throws MetadataException {
        this.addSingleLogoutService(idpSsoDesc, samlFederatedAuthenticatorConfig, IDPMetadataConstant.SOAP_BINDING_SAML2);
        this.addSingleLogoutService(idpSsoDesc, samlFederatedAuthenticatorConfig, IDPMetadataConstant.HTTP_BINDING_POST_SAML2);
        this.addSingleLogoutService(idpSsoDesc, samlFederatedAuthenticatorConfig, IDPMetadataConstant.HTTP_BINDING_REDIRECT_SAML2);
    }

    private void addSingleLogoutService(IDPSSODescriptor idpSsoDesc, FederatedAuthenticatorConfig samlFederatedAuthenticatorConfig, String binding) throws MetadataException {
        SingleLogoutService sloServiceDesc = (SingleLogoutService)BuilderUtil.createSAMLObject("urn:oasis:names:tc:SAML:2.0:metadata", "SingleLogoutService", "");
        sloServiceDesc.setBinding(binding);
        sloServiceDesc.setLocation(this.getFederatedAuthenticatorConfigProperty(samlFederatedAuthenticatorConfig, "LogoutReqUrl").getValue());
        sloServiceDesc.setResponseLocation(this.getFederatedAuthenticatorConfigProperty(samlFederatedAuthenticatorConfig, "LogoutReqUrl").getValue());
        idpSsoDesc.getSingleLogoutServices().add(sloServiceDesc);
    }

    @Override
    public void buildArtifactResolutionService(IDPSSODescriptor idpSsoDesc, FederatedAuthenticatorConfig samlFederatedAuthenticatorConfig) throws MetadataException {
        ArtifactResolutionService aresServiceDesc = (ArtifactResolutionService)BuilderUtil.createSAMLObject("urn:oasis:names:tc:SAML:2.0:metadata", "ArtifactResolutionService", "");
        aresServiceDesc.setBinding(IDPMetadataConstant.SOAP_BINDING_SAML2);
        aresServiceDesc.setLocation(this.getFederatedAuthenticatorConfigProperty(samlFederatedAuthenticatorConfig, "ArtifactResolveUrl").getValue());
        aresServiceDesc.setIndex(Integer.valueOf(1));
        idpSsoDesc.getArtifactResolutionServices().add(aresServiceDesc);
    }

    private DateTime validityPeriod(long timePeriod, char unit) {
        switch (unit) {
            case 's': {
                timePeriod *= 1000L;
                break;
            }
            case 'm': {
                timePeriod *= 60000L;
                break;
            }
            case 'h': {
                timePeriod *= 3600000L;
                break;
            }
            case 'd': {
                timePeriod *= 86400000L;
                break;
            }
            default: {
                timePeriod *= 3600000L;
            }
        }
        DateTime currentTime = new DateTime();
        DateTime validUntil = new DateTime(currentTime.getMillis() + timePeriod);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validity input : duration=" + timePeriod + " unit=" + unit + " output : calculated validUntil=" + validUntil));
        }
        return validUntil;
    }
}

