/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.idp.metadata.saml2.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityResponse;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityResponseFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityResponse;
import org.wso2.carbon.identity.idp.metadata.saml2.bean.SAMLMetadataErrorResponse;
import org.wso2.carbon.identity.idp.metadata.saml2.bean.SAMLMetadataResponse;

public class HttpSAMLMetadataResponseFactory
extends HttpIdentityResponseFactory {
    private static final Log log = LogFactory.getLog(HttpSAMLMetadataResponseFactory.class);

    public String getName() {
        return "HttpSAMLMetadataResponseFactory";
    }

    public boolean canHandle(IdentityResponse identityResponse) {
        return identityResponse instanceof SAMLMetadataResponse || identityResponse instanceof SAMLMetadataErrorResponse;
    }

    public HttpIdentityResponse.HttpIdentityResponseBuilder create(IdentityResponse identityResponse) {
        if (identityResponse instanceof SAMLMetadataResponse) {
            return this.sendResponse(identityResponse);
        }
        return this.sendErrorResponse(identityResponse);
    }

    private HttpIdentityResponse.HttpIdentityResponseBuilder sendResponse(IdentityResponse identityResponse) {
        SAMLMetadataResponse metadataResponse = (SAMLMetadataResponse)identityResponse;
        HttpIdentityResponse.HttpIdentityResponseBuilder builder = new HttpIdentityResponse.HttpIdentityResponseBuilder();
        String metadata = metadataResponse.getMetadata();
        StringBuilder out = new StringBuilder();
        out.append(metadata);
        builder.setBody(out.toString());
        builder.setContentType("application/xml");
        builder.setStatusCode(200);
        return builder;
    }

    public void create(HttpIdentityResponse.HttpIdentityResponseBuilder httpIdentityResponseBuilder, IdentityResponse identityResponse) {
    }

    private HttpIdentityResponse.HttpIdentityResponseBuilder sendErrorResponse(IdentityResponse identityResponse) {
        SAMLMetadataErrorResponse errorResponse = (SAMLMetadataErrorResponse)identityResponse;
        HttpIdentityResponse.HttpIdentityResponseBuilder builder = new HttpIdentityResponse.HttpIdentityResponseBuilder();
        String message = errorResponse.getMessage();
        StringBuilder out = new StringBuilder();
        out.append(message);
        builder.setBody(out.toString());
        builder.setContentType("text/html");
        builder.setStatusCode(500);
        return builder;
    }
}

