/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.idp.metadata.saml2;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import javax.crypto.SecretKey;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialContextSet;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.X509Credential;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.idp.metadata.saml2.internal.IDPMetadataSAMLServiceComponentHolder;
import org.wso2.carbon.idp.mgt.MetadataException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.security.keystore.KeyStoreAdmin;

public class SignKeyDataHolder
implements X509Credential {
    public static final String SECURITY_SAML_SIGN_KEY_STORE_LOCATION = "Security.SAMLSignKeyStore.Location";
    public static final String SECURITY_SAML_SIGN_KEY_STORE_TYPE = "Security.SAMLSignKeyStore.Type";
    public static final String SECURITY_SAML_SIGN_KEY_STORE_PASSWORD = "Security.SAMLSignKeyStore.Password";
    public static final String SECURITY_SAML_SIGN_KEY_STORE_KEY_ALIAS = "Security.SAMLSignKeyStore.KeyAlias";
    public static final String SECURITY_SAML_SIGN_KEY_STORE_KEY_PASSWORD = "Security.SAMLSignKeyStore.KeyPassword";
    private String signatureAlgorithm = null;
    private X509Certificate[] issuerCerts = null;
    private PrivateKey issuerPrivateKey = null;
    private static KeyStore superTenantSignKeyStore = null;
    private static final Log log = LogFactory.getLog(SignKeyDataHolder.class);

    public SignKeyDataHolder() throws MetadataException {
        try {
            String userTenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Key store used for signing is based on the tenant:  " + userTenantDomain));
            }
            if (tenantID != -1234) {
                this.initializeKeyDataForTenant(tenantID, userTenantDomain);
            } else if (this.isSignKeyStoreConfigured()) {
                this.initializeKeyDataForSuperTenantFromSignKeyStore();
            } else {
                this.initializeKeyDataForSuperTenantFromSystemKeyStore();
            }
        }
        catch (Exception e) {
            throw new MetadataException("Error occurred while creating certificate credentials", (Throwable)e);
        }
    }

    private void initializeKeyDataForTenant(int tenantID, String tenantDomain) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing Key Data for tenant: " + tenantDomain));
        }
        String keyStoreName = tenantDomain.trim().replace(".", "-") + ".jks";
        String keyAlias = tenantDomain;
        KeyStoreManager keyMan = KeyStoreManager.getInstance((int)tenantID);
        KeyStore keyStore = keyMan.getKeyStore(keyStoreName);
        this.issuerPrivateKey = (PrivateKey)keyMan.getPrivateKey(keyStoreName, tenantDomain);
        Certificate[] certificates = keyStore.getCertificateChain(keyAlias);
        this.issuerCerts = (X509Certificate[])Arrays.copyOf(certificates, certificates.length, X509Certificate[].class);
        this.signatureAlgorithm = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        String pubKeyAlgo = this.issuerCerts[0].getPublicKey().getAlgorithm();
        if ("DSA".equalsIgnoreCase(pubKeyAlgo)) {
            this.signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
    }

    private void initializeKeyDataForSuperTenantFromSystemKeyStore() throws Exception {
        String keyAlias;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing Key Data for super tenant using system key store");
        }
        if (StringUtils.isBlank((String)(keyAlias = ServerConfiguration.getInstance().getFirstProperty("Security.KeyStore.KeyAlias")))) {
            throw new MetadataException("Invalid file configurations. The key alias is not found.");
        }
        KeyStoreAdmin keyAdmin = new KeyStoreAdmin(-1234, (Registry)IDPMetadataSAMLServiceComponentHolder.getInstance().getRegistryService().getGovernanceSystemRegistry());
        KeyStoreManager keyMan = KeyStoreManager.getInstance((int)-1234);
        this.issuerPrivateKey = (PrivateKey)keyAdmin.getPrivateKey(keyAlias, true);
        Certificate[] certificates = keyMan.getPrimaryKeyStore().getCertificateChain(keyAlias);
        this.issuerCerts = (X509Certificate[])Arrays.copyOf(certificates, certificates.length, X509Certificate[].class);
        this.signatureAlgorithm = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        String pubKeyAlgo = this.issuerCerts[0].getPublicKey().getAlgorithm();
        if ("DSA".equalsIgnoreCase(pubKeyAlgo)) {
            this.signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
    }

    private boolean isSignKeyStoreConfigured() {
        String keyStoreLocation = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_LOCATION);
        String keyStoreType = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_TYPE);
        String keyStorePassword = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_PASSWORD);
        String keyAlias = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_KEY_ALIAS);
        String keyPassword = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_KEY_PASSWORD);
        return StringUtils.isNotBlank((String)keyStoreLocation) && StringUtils.isNotBlank((String)keyStoreType) && StringUtils.isNotBlank((String)keyStorePassword) && StringUtils.isNotBlank((String)keyAlias) && StringUtils.isNotBlank((String)keyPassword);
    }

    private void initializeKeyDataForSuperTenantFromSignKeyStore() throws MetadataException {
        block25: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initializing Key Data for super tenant using separate sign key store");
            }
            try {
                char[] keyPassword;
                String keyAlias;
                Key key;
                if (superTenantSignKeyStore == null) {
                    String keyStoreLocation = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_LOCATION);
                    try (FileInputStream is = new FileInputStream(keyStoreLocation);){
                        String keyStoreType = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_TYPE);
                        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                        char[] keyStorePassword = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_PASSWORD).toCharArray();
                        keyStore.load(is, keyStorePassword);
                        superTenantSignKeyStore = keyStore;
                    }
                    catch (FileNotFoundException e) {
                        throw new MetadataException("Unable to locate keystore", (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new MetadataException("Unable to read keystore", (Throwable)e);
                    }
                    catch (CertificateException e) {
                        throw new MetadataException("Unable to read certificate", (Throwable)e);
                    }
                }
                if ((key = superTenantSignKeyStore.getKey(keyAlias = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_KEY_ALIAS), keyPassword = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_KEY_PASSWORD).toCharArray())) instanceof PrivateKey) {
                    this.issuerPrivateKey = (PrivateKey)key;
                    Certificate[] certificates = superTenantSignKeyStore.getCertificateChain(keyAlias);
                    this.issuerCerts = (X509Certificate[])Arrays.copyOf(certificates, certificates.length, X509Certificate[].class);
                    this.signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                    Certificate cert = superTenantSignKeyStore.getCertificate(keyAlias);
                    PublicKey publicKey = cert.getPublicKey();
                    String pubKeyAlgo = publicKey.getAlgorithm();
                    if ("DSA".equalsIgnoreCase(pubKeyAlgo)) {
                        this.signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
                    }
                    break block25;
                }
                throw new MetadataException("Configured signing KeyStore private key is invalid");
            }
            catch (NoSuchAlgorithmException e) {
                throw new MetadataException("Unable to load algorithm", (Throwable)e);
            }
            catch (UnrecoverableKeyException e) {
                throw new MetadataException("Unable to load key", (Throwable)e);
            }
            catch (KeyStoreException e) {
                throw new MetadataException("Unable to load keystore", (Throwable)e);
            }
        }
    }

    public Collection<X509CRL> getCRLs() {
        return null;
    }

    public X509Certificate getEntityCertificate() {
        return this.issuerCerts[0];
    }

    public Collection<X509Certificate> getEntityCertificateChain() {
        return Arrays.asList(this.issuerCerts);
    }

    public CredentialContextSet getCredentialContextSet() {
        return null;
    }

    public Class<? extends Credential> getCredentialType() {
        return null;
    }

    public String getEntityId() {
        return null;
    }

    public Collection<String> getKeyNames() {
        return null;
    }

    public PrivateKey getPrivateKey() {
        return this.issuerPrivateKey;
    }

    public PublicKey getPublicKey() {
        return this.issuerCerts[0].getPublicKey();
    }

    public SecretKey getSecretKey() {
        return null;
    }

    public UsageType getUsageType() {
        return null;
    }
}

