/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.idp.metadata.saml2;

import java.security.cert.CertificateEncodingException;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.ElementProxy;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.w3c.dom.Document;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.idp.metadata.saml2.CryptoProvider;
import org.wso2.carbon.identity.idp.metadata.saml2.SignKeyDataHolder;
import org.wso2.carbon.identity.idp.metadata.saml2.util.BuilderUtil;
import org.wso2.carbon.idp.mgt.MetadataException;

public class MetadataCryptoProvider
implements CryptoProvider {
    private X509Credential credential;
    private static final Log log = LogFactory.getLog(MetadataCryptoProvider.class);

    public MetadataCryptoProvider() throws MetadataException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating the credential object");
        }
        this.credential = new SignKeyDataHolder();
    }

    @Override
    public void signMetadata(EntityDescriptor baseDescriptor) throws MetadataException {
        List roleDescriptors = baseDescriptor.getRoleDescriptors();
        if (roleDescriptors.size() > 0) {
            for (RoleDescriptor roleDesc : roleDescriptors) {
                roleDesc.getKeyDescriptors().add(this.createKeyDescriptor());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Key Descriptors set for all the role descriptor types");
        }
        try {
            ElementProxy.setDefaultPrefix((String)"http://www.w3.org/2000/09/xmldsig#", (String)"");
        }
        catch (XMLSecurityException e) {
            throw new MetadataException("Unable to set default prefix for signature element", (Throwable)e);
        }
        Init.init();
    }

    private KeyInfo createKeyInfo() throws MetadataException {
        String value;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating the KeyInfo element");
        }
        KeyInfo keyInfo = (KeyInfo)BuilderUtil.createSAMLObject("http://www.w3.org/2000/09/xmldsig#", "KeyInfo", "");
        X509Data data = (X509Data)BuilderUtil.createSAMLObject("http://www.w3.org/2000/09/xmldsig#", "X509Data", "");
        X509Certificate cert = (X509Certificate)BuilderUtil.createSAMLObject("http://www.w3.org/2000/09/xmldsig#", "X509Certificate", "");
        try {
            value = Base64.encode((byte[])this.credential.getEntityCertificate().getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new MetadataException("Error while encoding the certificate.", (Throwable)e);
        }
        cert.setValue(value);
        data.getX509Certificates().add(cert);
        keyInfo.getX509Datas().add(data);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Completed KeyInfo element creation");
        }
        return keyInfo;
    }

    private KeyDescriptor createKeyDescriptor() throws MetadataException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating the KeyDescriptor element");
        }
        KeyDescriptor keyDescriptor = (KeyDescriptor)BuilderUtil.createSAMLObject("urn:oasis:names:tc:SAML:2.0:metadata", "KeyDescriptor", "");
        keyDescriptor.setUse(UsageType.SIGNING);
        keyDescriptor.setKeyInfo(this.createKeyInfo());
        return keyDescriptor;
    }

    private Document marshallDescriptor(EntityDescriptor desc) throws MetadataException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = IdentityUtil.getSecuredDocumentBuilderFactory();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MetadataException("Error while creating the document.", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Marshalling the metadata element contents");
        }
        Document document = builder.newDocument();
        Marshaller out = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)desc);
        try {
            out.marshall((XMLObject)desc, document);
        }
        catch (MarshallingException e) {
            throw new MetadataException("Error while marshalling the descriptor.", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Marshalling completed");
        }
        return document;
    }

    public Signature getSignature(EntityDescriptor baseDescriptor) {
        QName qname = Signature.DEFAULT_ELEMENT_NAME;
        XMLObjectBuilder builder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(qname);
        Signature signature = (Signature)builder.buildObject(qname);
        signature.setSigningCredential((Credential)this.credential);
        signature.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        baseDescriptor.setSignature(signature);
        return signature;
    }
}

