/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.cors;

import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CORSRequestType {
    ACTUAL,
    PREFLIGHT,
    OTHER;


    public static CORSRequestType detect(HttpServletRequest request) {
        if (request.getHeader("Origin") == null) {
            return OTHER;
        }
        String serverOrigin = request.getScheme() + "://" + request.getHeader("Host");
        if (request.getHeader("Host") != null && request.getHeader("Origin").equals(serverOrigin)) {
            return OTHER;
        }
        if (request.getHeader("Access-Control-Request-Method") != null && request.getMethod() != null && request.getMethod().equals("OPTIONS")) {
            return PREFLIGHT;
        }
        return ACTUAL;
    }
}

