/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.soap;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.core.Property;
import org.wso2.carbon.event.output.adapter.soap.SoapEventAdapter;

public class SoapEventAdapterFactory
extends OutputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.output.adapter.soap.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "soap";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportedMessageFormats = new ArrayList<String>();
        supportedMessageFormats.add("xml");
        return supportedMessageFormats;
    }

    public List<Property> getStaticPropertyList() {
        return null;
    }

    public List<Property> getDynamicPropertyList() {
        ArrayList<Property> dynamicPropertyList = new ArrayList<Property>();
        Property host = new Property("url");
        host.setDisplayName(this.resourceBundle.getString("url"));
        host.setRequired(true);
        host.setHint(this.resourceBundle.getString("url.hint"));
        Property userNameProperty = new Property("username");
        userNameProperty.setDisplayName(this.resourceBundle.getString("username"));
        Property passwordProperty = new Property("password");
        passwordProperty.setSecured(true);
        passwordProperty.setEncrypted(true);
        passwordProperty.setDisplayName(this.resourceBundle.getString("password"));
        Property soapHeaderProperty = new Property("soapHeaders");
        soapHeaderProperty.setDisplayName(this.resourceBundle.getString("soapHeaders"));
        soapHeaderProperty.setHint(this.resourceBundle.getString("soapHeaders.hint"));
        soapHeaderProperty.setRequired(false);
        Property httpHeaderProperty = new Property("httpHeaders");
        httpHeaderProperty.setDisplayName(this.resourceBundle.getString("httpHeaders"));
        httpHeaderProperty.setHint(this.resourceBundle.getString("httpHeaders.hint"));
        httpHeaderProperty.setRequired(false);
        dynamicPropertyList.add(host);
        dynamicPropertyList.add(userNameProperty);
        dynamicPropertyList.add(passwordProperty);
        dynamicPropertyList.add(soapHeaderProperty);
        dynamicPropertyList.add(httpHeaderProperty);
        return dynamicPropertyList;
    }

    public String getUsageTips() {
        return null;
    }

    public OutputEventAdapter createEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new SoapEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

