/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.soap;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterRuntimeException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.output.adapter.soap.internal.util.SoapEventAdapterConstants;

public class SoapEventAdapter
implements OutputEventAdapter {
    private static final Log log = LogFactory.getLog(SoapEventAdapter.class);
    private OutputEventAdapterConfiguration eventAdapterConfiguration;
    private Map<String, String> globalProperties;
    private ExecutorService executorService;
    private ConfigurationContext configContext;
    private int tenantId;

    public SoapEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
    }

    public void init() throws OutputEventAdapterException {
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (this.executorService == null) {
            int minThread = this.globalProperties.get("minThread") != null ? Integer.parseInt(this.globalProperties.get("minThread")) : 8;
            int maxThread = this.globalProperties.get("maxThread") != null ? Integer.parseInt(this.globalProperties.get("maxThread")) : 100;
            long defaultKeepAliveTime = this.globalProperties.get("keepAliveTimeInMillis") != null ? (long)Integer.parseInt(this.globalProperties.get("keepAliveTimeInMillis")) : 20000L;
            int jobQueueSize = this.globalProperties.get("jobQueueSize") != null ? Integer.parseInt(this.globalProperties.get("jobQueueSize")) : 2000;
            this.executorService = new ThreadPoolExecutor(minThread, maxThread, defaultKeepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(jobQueueSize), new ThreadFactoryBuilder().setNameFormat("Thread pool- component - SoapEventAdapter.executorService;adapterName - " + this.eventAdapterConfiguration.getName()).build());
        }
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("Test connection is not available");
    }

    public void connect() {
        try {
            this.configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)(System.getProperty("carbon.home") + SoapEventAdapterConstants.SERVER_CLIENT_DEPLOYMENT_DIR), (String)(System.getProperty("carbon.config.dir.path") + SoapEventAdapterConstants.AXIS2_CLIENT_CONF_FILE));
            int axis2ClientTimeOutInMillis = 14400000;
            boolean isReuseHTTPClient = true;
            boolean isAutoReleaseConnection = true;
            int maxConnectionPerHostValue = 50;
            String axi2ClientTimeOut = this.globalProperties.get("axis2ClientConnectionTimeout");
            try {
                if (axi2ClientTimeOut != null) {
                    axis2ClientTimeOutInMillis = Integer.parseInt(axi2ClientTimeOut);
                }
            }
            catch (NumberFormatException e) {
                log.error((Object)("Invalid axis2 client timeout value " + axi2ClientTimeOut + " ignoring the configuration and using default value " + axis2ClientTimeOutInMillis));
            }
            String reuseHTTPClient = this.globalProperties.get("reuseHTTPClient");
            try {
                if (reuseHTTPClient != null) {
                    isReuseHTTPClient = Boolean.parseBoolean(reuseHTTPClient);
                }
            }
            catch (NumberFormatException e) {
                log.error((Object)("Invalid Reuse HTTP Client value " + reuseHTTPClient + " ignoring the configuration and using default value " + isReuseHTTPClient));
            }
            String autoReleaseConnection = this.globalProperties.get("autoReleaseConnection");
            try {
                if (autoReleaseConnection != null) {
                    isAutoReleaseConnection = Boolean.parseBoolean(autoReleaseConnection);
                }
            }
            catch (NumberFormatException e) {
                log.error((Object)("Invalid Auto release connection value " + autoReleaseConnection + " ignoring the configuration and using default value " + isAutoReleaseConnection));
            }
            String maxConnectionPerHost = this.globalProperties.get("maxConnectionsPerHost");
            try {
                if (maxConnectionPerHost != null) {
                    maxConnectionPerHostValue = Integer.parseInt(maxConnectionPerHost);
                }
            }
            catch (NumberFormatException e) {
                log.error((Object)("Invalid Max connection per host value " + maxConnectionPerHost + " ignoring the configuration and using default value " + maxConnectionPerHostValue));
            }
            this.configContext.setProperty("REUSE_HTTP_CLIENT", (Object)isReuseHTTPClient);
            this.configContext.setProperty("CACHED_HTTP_CLIENT", (Object)this.createMultiThreadedHttpConnectionManager(axis2ClientTimeOutInMillis, maxConnectionPerHostValue));
            this.configContext.setProperty("AutoReleaseConnection", (Object)isAutoReleaseConnection);
        }
        catch (AxisFault axisFault) {
            throw new OutputEventAdapterRuntimeException("Error while creating configuration context from filesystem ", (Throwable)axisFault);
        }
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        String url = dynamicProperties.get("url");
        String userName = dynamicProperties.get("username");
        String password = dynamicProperties.get("password");
        Map<String, String> soapHeaders = this.extractHeaders(dynamicProperties.get("soapHeaders"));
        Map<String, String> httpHeaders = this.extractHeaders(dynamicProperties.get("httpHeaders"));
        try {
            this.executorService.submit(new SoapSender(url, message, userName, password, soapHeaders, httpHeaders));
        }
        catch (RejectedExecutionException e) {
            EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Job queue is full", (Throwable)e, (Log)log, (int)this.tenantId);
        }
    }

    public void disconnect() {
    }

    public void destroy() {
    }

    public boolean isPolled() {
        return false;
    }

    private Map<String, String> extractHeaders(String headers) {
        if (headers == null || headers.trim().length() == 0) {
            return null;
        }
        String[] entries = headers.split(",");
        HashMap<String, String> result = new HashMap<String, String>();
        for (String header : entries) {
            try {
                String[] keyValue = header.split(":", 2);
                result.put(keyValue[0].trim(), keyValue[1].trim());
            }
            catch (Throwable e) {
                log.error((Object)("Header property \"" + header + "\" is not defined in the correct format."), e);
            }
        }
        return result;
    }

    private HttpClient createMultiThreadedHttpConnectionManager(int connectionTimeOut, int maxConnectionPerHost) {
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setDefaultMaxConnectionsPerHost(maxConnectionPerHost);
        params.setConnectionTimeout(connectionTimeOut);
        MultiThreadedHttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
        httpConnectionManager.setParams(params);
        return new HttpClient((HttpConnectionManager)httpConnectionManager);
    }

    public class SoapSender
    implements Runnable {
        private String url;
        private Object payload;
        private String username;
        private String password;
        private Map<String, String> soapHeaders;
        private Map<String, String> httpHeaders;

        public SoapSender(String url, Object payload, String username, String password, Map<String, String> soapHeaders, Map<String, String> httpHeaders) {
            this.url = url;
            this.payload = payload;
            this.username = username;
            this.password = password;
            this.soapHeaders = soapHeaders;
            this.httpHeaders = httpHeaders;
        }

        @Override
        public void run() {
            ServiceClient serviceClient = null;
            try {
                serviceClient = new ServiceClient(SoapEventAdapter.this.configContext, null);
                Options options = new Options();
                options.setTo(new EndpointReference(this.url));
                if (this.soapHeaders != null) {
                    serviceClient.engageModule("addressing");
                    this.setSoapHeaders(this.soapHeaders, options);
                }
                if (this.httpHeaders != null) {
                    this.setHttpHeaders(this.httpHeaders, options);
                }
                if (this.username != null || this.password != null) {
                    options.setUserName(this.username);
                    options.setPassword(this.password);
                    serviceClient.engageModule("rampart");
                    options.setProperty("rampartPolicy", (Object)this.loadPolicy());
                }
                serviceClient.setOptions(options);
                serviceClient.fireAndForget(AXIOMUtil.stringToOM((String)this.payload.toString()));
            }
            catch (AxisFault e) {
                EventAdapterUtil.logAndDrop((String)SoapEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.payload, (String)("Cannot send to endpoint '" + this.url + "'"), (Throwable)e, (Log)log, (int)SoapEventAdapter.this.tenantId);
            }
            catch (XMLStreamException e) {
                EventAdapterUtil.logAndDrop((String)SoapEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.payload, (String)"Cannot convert event to XML", (Throwable)e, (Log)log, (int)SoapEventAdapter.this.tenantId);
            }
            catch (Exception e) {
                EventAdapterUtil.logAndDrop((String)SoapEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.payload, null, (Throwable)e, (Log)log, (int)SoapEventAdapter.this.tenantId);
            }
            finally {
                if (serviceClient != null) {
                    try {
                        serviceClient.cleanup();
                    }
                    catch (AxisFault axisFault) {
                        log.error((Object)("Error while cleaning-up service client resources of Output SOAP Event Adapter '" + SoapEventAdapter.this.eventAdapterConfiguration.getName() + "' : " + axisFault.getMessage()), (Throwable)axisFault);
                    }
                }
            }
        }

        private Policy loadPolicy() throws XMLStreamException {
            OMElement omElement = AXIOMUtil.stringToOM((String)"<wsp:Policy xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"\n            xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"\n            wsu:Id=\"UTOverTransport\">\n    <wsp:ExactlyOne>\n        <wsp:All>\n            <sp:TransportBinding xmlns:sp=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy\">\n                <wsp:Policy>\n                    <sp:TransportToken>\n                        <wsp:Policy>\n                            <sp:HttpsToken RequireClientCertificate=\"false\"></sp:HttpsToken>\n                        </wsp:Policy>\n                    </sp:TransportToken>\n                    <sp:AlgorithmSuite>\n                        <wsp:Policy>\n                            <sp:Basic256></sp:Basic256>\n                        </wsp:Policy>\n                    </sp:AlgorithmSuite>\n                    <sp:Layout>\n                        <wsp:Policy>\n                            <sp:Lax></sp:Lax>\n                        </wsp:Policy>\n                    </sp:Layout>\n                    <sp:IncludeTimestamp></sp:IncludeTimestamp>\n                </wsp:Policy>\n            </sp:TransportBinding>\n            <sp:SignedSupportingTokens\n                    xmlns:sp=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy\">\n                <wsp:Policy>\n                    <sp:UsernameToken\n                            sp:IncludeToken=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient\"></sp:UsernameToken>\n                </wsp:Policy>\n            </sp:SignedSupportingTokens>\n        </wsp:All>\n    </wsp:ExactlyOne>\n</wsp:Policy>");
            return PolicyEngine.getPolicy((OMElement)omElement);
        }

        private void setSoapHeaders(Map<String, String> headers, Options options) {
            for (Map.Entry<String, String> headerValue : headers.entrySet()) {
                try {
                    if (headerValue.getKey().equalsIgnoreCase("SOAPAction")) {
                        options.setAction(headerValue.getValue());
                        continue;
                    }
                    if (headerValue.getKey().equalsIgnoreCase("From")) {
                        options.setFrom(new EndpointReference(headerValue.getValue()));
                        continue;
                    }
                    if (headerValue.getKey().equalsIgnoreCase("FaultTo")) {
                        options.setFaultTo(new EndpointReference(headerValue.getValue()));
                        continue;
                    }
                    if (headerValue.getKey().equalsIgnoreCase("TransportIn")) {
                        options.setTransportIn(new TransportInDescription(headerValue.getValue()));
                        continue;
                    }
                    if (headerValue.getKey().equalsIgnoreCase("TransportInProtocol")) {
                        options.setTransportInProtocol(headerValue.getValue());
                        continue;
                    }
                    if (headerValue.getKey().equalsIgnoreCase("MessageID")) {
                        options.setMessageId(headerValue.getValue());
                        continue;
                    }
                    if (headerValue.getKey().equalsIgnoreCase("RelatesTo")) {
                        options.addRelatesTo(new RelatesTo(headerValue.getValue()));
                        continue;
                    }
                    if (headerValue.getKey().equalsIgnoreCase("ReplyTo")) {
                        options.setReplyTo(new EndpointReference(headerValue.getValue()));
                        continue;
                    }
                    if (headerValue.getKey().equalsIgnoreCase("TransportOut")) {
                        options.setTransportOut(new TransportOutDescription(headerValue.getValue()));
                        continue;
                    }
                    if (headerValue.getKey().equalsIgnoreCase("SoapVersionURI")) {
                        options.setSoapVersionURI(headerValue.getValue());
                        continue;
                    }
                    if (headerValue.getKey().equalsIgnoreCase("To")) {
                        options.setTo(new EndpointReference(headerValue.getValue()));
                        continue;
                    }
                    if (headerValue.getKey().equalsIgnoreCase("ManageSession")) {
                        options.setManageSession(Boolean.parseBoolean(headerValue.getValue()));
                        continue;
                    }
                    try {
                        int headerParameterValue = Integer.parseInt(headerValue.getValue());
                        options.setProperty(headerValue.getKey(), (Object)headerParameterValue);
                    }
                    catch (NumberFormatException e) {
                        options.setProperty(headerValue.getKey(), (Object)headerValue.getValue());
                    }
                }
                catch (Throwable e) {
                    log.warn((Object)("Invalid soap header : \"" + headerValue + "\", ignoring corresponding header..." + e.getMessage()));
                }
            }
        }

        private void setHttpHeaders(Map<String, String> headers, Options options) {
            ArrayList<Header> list = new ArrayList<Header>();
            for (Map.Entry<String, String> headerValue : headers.entrySet()) {
                try {
                    Header header = new Header();
                    header.setName(headerValue.getKey());
                    header.setValue(headerValue.getValue());
                    list.add(header);
                }
                catch (Throwable e) {
                    log.warn((Object)("Invalid HTTP header : \"" + headerValue + "\", ignoring corresponding header..." + e.getMessage()));
                }
            }
            options.setProperty("HTTP_HEADERS", list);
        }
    }
}

