/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.dcr.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.dcr.DCRMConstants;
import org.wso2.carbon.identity.oauth.dcr.exception.DCRMClientException;
import org.wso2.carbon.identity.oauth.dcr.exception.DCRMServerException;

public class DCRMUtils {
    private static final Log log = LogFactory.getLog(DCRMUtils.class);
    private static Pattern spNameRegexPattern = null;
    private static final String SERVICE_PROVIDERS_NAME_REGEX = "ServiceProviders.SPNameRegex";
    private static final String APPLICATION_ROLE_PERMISSION_REQUIRED = "OAuth.DCRM.ApplicationRolePermissionRequiredToView";

    public static boolean isRedirectionUriValid(String redirectUri) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validating uri: " + redirectUri));
        }
        if (IdentityUtil.isBlank((String)redirectUri)) {
            log.error((Object)"The redirection URI is either null or blank.");
            return false;
        }
        try {
            new URI(redirectUri);
        }
        catch (URISyntaxException e) {
            if (log.isDebugEnabled()) {
                String errorMessage = "The redirection URI: " + redirectUri + ", is not a valid URI.";
                log.debug((Object)errorMessage, (Throwable)e);
            }
            return false;
        }
        return true;
    }

    public static boolean isBackchannelLogoutUriValid(String backchannelLogoutUri) {
        URI uri;
        if (StringUtils.isBlank((String)backchannelLogoutUri)) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validating back-channel logout uri: " + backchannelLogoutUri));
        }
        if (backchannelLogoutUri.contains("#")) {
            if (log.isDebugEnabled()) {
                String errorMessage = "The back-channel logout URI: " + backchannelLogoutUri + ", contains a fragment component.";
                log.debug((Object)errorMessage);
            }
            return false;
        }
        try {
            uri = new URI(backchannelLogoutUri);
        }
        catch (URISyntaxException e) {
            if (log.isDebugEnabled()) {
                String errorMessage = "The back-channel logout URI: " + backchannelLogoutUri + ", is not a valid URI.";
                log.debug((Object)errorMessage, (Throwable)e);
            }
            return false;
        }
        if (!uri.isAbsolute()) {
            if (log.isDebugEnabled()) {
                String errorMessage = "The back-channel logout URI: " + backchannelLogoutUri + ", is not an absolute URI.";
                log.debug((Object)errorMessage);
            }
            return false;
        }
        return true;
    }

    public static DCRMServerException generateServerException(DCRMConstants.ErrorMessages error, String data, Throwable e) throws DCRMServerException {
        String errorDescription = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return (DCRMServerException)IdentityException.error(DCRMServerException.class, (String)error.toString(), (String)errorDescription, (Throwable)e);
    }

    public static DCRMServerException generateServerException(DCRMConstants.ErrorMessages error, String data) throws DCRMServerException {
        String errorDescription = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return (DCRMServerException)IdentityException.error(DCRMServerException.class, (String)error.toString(), (String)errorDescription);
    }

    public static DCRMClientException generateClientException(DCRMConstants.ErrorMessages error, String data, Throwable e) throws DCRMClientException {
        String errorDescription = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return (DCRMClientException)IdentityException.error(DCRMClientException.class, (String)error.toString(), (String)errorDescription, (Throwable)e);
    }

    public static DCRMClientException generateClientException(DCRMConstants.ErrorMessages error, String data) throws DCRMClientException {
        String errorDescription = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return (DCRMClientException)IdentityException.error(DCRMClientException.class, (String)error.toString(), (String)errorDescription);
    }

    public static boolean isRegexValidated(String applicationName) {
        if (spNameRegexPattern == null) {
            String spValidatorRegex = DCRMUtils.getSPValidatorRegex();
            spNameRegexPattern = Pattern.compile(spValidatorRegex);
        }
        return spNameRegexPattern.matcher(applicationName).matches();
    }

    @Deprecated
    public static boolean isRegexValidated(String providedString, String regex) {
        Pattern regexPattern = Pattern.compile(regex);
        return regexPattern.matcher(providedString).matches();
    }

    public static String getSPValidatorRegex() {
        String spValidatorRegex = IdentityUtil.getProperty((String)SERVICE_PROVIDERS_NAME_REGEX);
        if (StringUtils.isBlank((String)spValidatorRegex)) {
            spValidatorRegex = "^[a-zA-Z0-9._-]*$";
        }
        return spValidatorRegex;
    }

    public static boolean isApplicationRolePermissionRequired() {
        String isApplicationRolePermissionRequired = IdentityUtil.getProperty((String)APPLICATION_ROLE_PERMISSION_REQUIRED);
        return StringUtils.isEmpty((String)isApplicationRolePermissionRequired) || Boolean.parseBoolean(isApplicationRolePermissionRequired);
    }
}

