/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.dcr.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.base.IdentityValidationException;
import org.wso2.carbon.identity.base.IdentityValidationUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.OAuthAdminService;
import org.wso2.carbon.identity.oauth.dcr.DCRException;
import org.wso2.carbon.identity.oauth.dcr.internal.DCRDataHolder;
import org.wso2.carbon.identity.oauth.dcr.model.RegistrationRequestProfile;
import org.wso2.carbon.identity.oauth.dcr.model.RegistrationResponseProfile;
import org.wso2.carbon.identity.oauth.dcr.util.DCRMUtils;
import org.wso2.carbon.identity.oauth.dcr.util.ErrorCodes;
import org.wso2.carbon.identity.oauth.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class DCRManagementService {
    private static final Log log = LogFactory.getLog(DCRManagementService.class);
    private static final String AUTH_TYPE_OAUTH_2 = "oauth2";
    private static final String OAUTH_CONSUMER_SECRET = "oauthConsumerSecret";
    private static final String OAUTH_VERSION = "OAuth-2.0";
    private static final String DEFAULT_CLIENT_SECRET_EXPIRY_TIME = "0";
    private static DCRManagementService dcrManagementService = new DCRManagementService();

    private DCRManagementService() {
    }

    public static DCRManagementService getInstance() {
        return dcrManagementService;
    }

    public RegistrationResponseProfile registerOAuthApplication(RegistrationRequestProfile profile) throws DCRException {
        String applicationName = profile.getClientName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to register OAuth application: '" + applicationName + "'"));
        }
        if (!DCRMUtils.isRegexValidated(applicationName)) {
            throw new DCRException("The Application name: " + applicationName + " is not valid! It is not adhering to the regex: " + DCRMUtils.getSPValidatorRegex());
        }
        RegistrationResponseProfile info = this.createOAuthApplication(profile);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegistrationResponseProfile createOAuthApplication(RegistrationRequestProfile profile) throws DCRException {
        String owner = profile.getOwner();
        String ownerName = owner.replaceAll(String.valueOf("[\\\\/:*?\"`,~!@#$&;%^*()+=<{}>'|]"), "_");
        String applicationName = ownerName + "_" + profile.getClientName();
        if (!DCRMUtils.isRegexValidated(applicationName)) {
            throw new DCRException("The Application name: " + applicationName + " is not valid! It is not adhering to the regex: " + DCRMUtils.getSPValidatorRegex());
        }
        String grantType = StringUtils.join(profile.getGrantTypes(), (String)" ");
        String baseUser = CarbonContext.getThreadLocalCarbonContext().getUsername();
        String userName = MultitenantUtils.getTenantAwareUsername((String)profile.getOwner());
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(profile.getTenantDomain(), true);
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(userName);
        try {
            OAuthConsumerAppDTO createdApp;
            ServiceProvider serviceProvider = new ServiceProvider();
            serviceProvider.setApplicationName(applicationName);
            User user = new User();
            user.setUserName(UserCoreUtil.removeDomainFromName((String)userName));
            user.setUserStoreDomain(UserCoreUtil.extractDomainFromName((String)userName));
            user.setTenantDomain(profile.getTenantDomain());
            serviceProvider.setOwner(user);
            serviceProvider.setDescription("Service Provider for application " + applicationName);
            ApplicationManagementService appMgtService = DCRDataHolder.getInstance().getApplicationManagementService();
            ServiceProvider existingServiceProvider = null;
            ServiceProvider createdServiceProvider = null;
            try {
                existingServiceProvider = appMgtService.getServiceProvider(applicationName, profile.getTenantDomain());
                if (existingServiceProvider != null) {
                    String errorMessage = "Service Provider with name: " + applicationName + " already registered";
                    throw (DCRException)IdentityException.error(DCRException.class, (String)ErrorCodes.META_DATA_VALIDATION_FAILED.toString(), (String)errorMessage);
                }
                appMgtService.createApplication(serviceProvider, profile.getTenantDomain(), userName);
                createdServiceProvider = appMgtService.getServiceProvider(applicationName, profile.getTenantDomain());
            }
            catch (IdentityApplicationManagementException e) {
                String errorMessage = "Error occurred while reading service provider, " + applicationName;
                throw (DCRException)IdentityException.error(DCRException.class, (String)ErrorCodes.BAD_REQUEST.toString(), (String)errorMessage, (Throwable)e);
            }
            if (createdServiceProvider == null) {
                String errorMessage = "Couldn't create Service Provider Application " + applicationName;
                throw (DCRException)IdentityException.error(DCRException.class, (String)ErrorCodes.META_DATA_VALIDATION_FAILED.toString(), (String)errorMessage);
            }
            createdServiceProvider.setSaasApp(false);
            OAuthAdminService oAuthAdminService = new OAuthAdminService();
            OAuthConsumerAppDTO oAuthConsumerApp = new OAuthConsumerAppDTO();
            oAuthConsumerApp.setApplicationName(applicationName);
            if (profile.getRedirectUris().size() == 0 && (profile.getGrantTypes().contains("authorization_code") || profile.getGrantTypes().contains("implicit"))) {
                String errorMessage = "RedirectUris property must have at least one URI value.";
                throw (DCRException)IdentityException.error(DCRException.class, (String)ErrorCodes.META_DATA_VALIDATION_FAILED.toString(), (String)errorMessage);
            }
            if (profile.getRedirectUris().size() == 1) {
                String redirectUri = profile.getRedirectUris().get(0);
                try {
                    IdentityValidationUtil.getValidInputOverWhiteListPatterns((String)redirectUri, (String[])new String[]{IdentityValidationUtil.ValidatorPattern.URL_WITHOUT_FRAGMENT.name()});
                    oAuthConsumerApp.setCallbackUrl(redirectUri);
                }
                catch (IdentityValidationException e) {
                    throw (DCRException)IdentityException.error(DCRException.class, (String)("Redirect URI: " + redirectUri + ", is invalid"), (Throwable)e);
                }
            } else if (profile.getRedirectUris().size() > 1) {
                oAuthConsumerApp.setCallbackUrl("regexp=" + this.createRegexPattern(profile.getRedirectUris()));
            }
            oAuthConsumerApp.setGrantTypes(grantType);
            oAuthConsumerApp.setOAuthVersion(OAUTH_VERSION);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating OAuth App " + applicationName));
            }
            try {
                createdApp = oAuthAdminService.registerAndRetrieveOAuthApplicationData(oAuthConsumerApp);
            }
            catch (IdentityOAuthAdminException e) {
                throw (DCRException)IdentityException.error(DCRException.class, (String)ErrorCodes.META_DATA_VALIDATION_FAILED.toString(), (String)e.getMessage());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created OAuth App " + applicationName));
                log.debug((Object)("Retrieved Details for OAuth App " + createdApp.getApplicationName()));
            }
            InboundAuthenticationConfig inboundAuthenticationConfig = new InboundAuthenticationConfig();
            ArrayList<InboundAuthenticationRequestConfig> inboundAuthenticationRequestConfigs = new ArrayList<InboundAuthenticationRequestConfig>();
            InboundAuthenticationRequestConfig inboundAuthenticationRequestConfig = new InboundAuthenticationRequestConfig();
            inboundAuthenticationRequestConfig.setInboundAuthKey(createdApp.getOauthConsumerKey());
            inboundAuthenticationRequestConfig.setInboundAuthType(AUTH_TYPE_OAUTH_2);
            String oauthConsumerSecret = createdApp.getOauthConsumerSecret();
            if (oauthConsumerSecret != null && !oauthConsumerSecret.isEmpty()) {
                Property property = new Property();
                property.setName(OAUTH_CONSUMER_SECRET);
                property.setValue(oauthConsumerSecret);
                Property[] properties = new Property[]{property};
                inboundAuthenticationRequestConfig.setProperties(properties);
            }
            inboundAuthenticationRequestConfigs.add(inboundAuthenticationRequestConfig);
            inboundAuthenticationConfig.setInboundAuthenticationRequestConfigs(inboundAuthenticationRequestConfigs.toArray(new InboundAuthenticationRequestConfig[inboundAuthenticationRequestConfigs.size()]));
            createdServiceProvider.setInboundAuthenticationConfig(inboundAuthenticationConfig);
            try {
                appMgtService.updateApplication(createdServiceProvider, profile.getTenantDomain(), userName);
            }
            catch (IdentityApplicationManagementException e) {
                throw (DCRException)IdentityException.error(DCRException.class, (String)ErrorCodes.BAD_REQUEST.toString(), (String)e.getMessage());
            }
            RegistrationResponseProfile registrationResponseProfile = new RegistrationResponseProfile();
            registrationResponseProfile.setClientId(createdApp.getOauthConsumerKey());
            registrationResponseProfile.getRedirectUrls().add(createdApp.getCallbackUrl());
            registrationResponseProfile.setClientSecret(oauthConsumerSecret);
            registrationResponseProfile.setClientName(createdApp.getApplicationName());
            registrationResponseProfile.setClientSecretExpiresAt(DEFAULT_CLIENT_SECRET_EXPIRY_TIME);
            if (StringUtils.isNotBlank((String)createdApp.getGrantTypes())) {
                String[] split = createdApp.getGrantTypes().split(" ");
                registrationResponseProfile.setGrantTypes(Arrays.asList(split));
            }
            RegistrationResponseProfile registrationResponseProfile2 = registrationResponseProfile;
            return registrationResponseProfile2;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(baseUser);
        }
    }

    public void unregisterOAuthApplication(String userId, String applicationName, String consumerKey) throws DCRException {
        OAuthConsumerAppDTO oAuthConsumerApp;
        OAuthAdminService oAuthAdminService;
        String userName;
        String tenantDomain;
        block12: {
            if (!(StringUtils.isNotEmpty((String)userId) && StringUtils.isNotEmpty((String)applicationName) && StringUtils.isNotEmpty((String)consumerKey))) {
                throw new DCRException("Username, Application Name and Consumer Key cannot be null or empty");
            }
            tenantDomain = MultitenantUtils.getTenantDomain((String)userId);
            userName = MultitenantUtils.getTenantAwareUsername((String)userId);
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(userName);
            oAuthAdminService = new OAuthAdminService();
            oAuthConsumerApp = null;
            try {
                oAuthConsumerApp = oAuthAdminService.getOAuthApplicationData(consumerKey);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block12;
                log.debug((Object)"Error occurred while oauth application data by consumer id.", (Throwable)e);
            }
        }
        if (oAuthConsumerApp != null) {
            try {
                oAuthAdminService.removeOAuthApplicationData(consumerKey);
                ApplicationManagementService appMgtService = DCRDataHolder.getInstance().getApplicationManagementService();
                if (appMgtService == null) {
                    throw new IllegalStateException("Error occurred while retrieving Application Management Service");
                }
                ServiceProvider createdServiceProvider = appMgtService.getServiceProvider(applicationName, tenantDomain);
                if (createdServiceProvider == null) {
                    throw new DCRException("Couldn't retrieve Service Provider Application " + applicationName);
                }
                appMgtService.deleteApplication(applicationName, tenantDomain, userName);
            }
            catch (IdentityApplicationManagementException e) {
                throw new DCRException("Error occurred while removing ServiceProvider for application '" + applicationName + "'", e);
            }
            catch (IdentityOAuthAdminException e) {
                throw new DCRException("Error occurred while removing application '" + applicationName + "'", e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    public boolean isOAuthApplicationAvailable(String applicationName) throws DCRException {
        ApplicationManagementService appMgtService = DCRDataHolder.getInstance().getApplicationManagementService();
        if (appMgtService == null) {
            throw new IllegalStateException("Error occurred while retrieving Application Management Service");
        }
        try {
            return appMgtService.getServiceProvider(applicationName, CarbonContext.getThreadLocalCarbonContext().getTenantDomain()) != null;
        }
        catch (IdentityApplicationManagementException e) {
            throw new DCRException("Error occurred while retrieving information of OAuthApp " + applicationName, e);
        }
    }

    private String createRegexPattern(List<String> redirectURIs) throws DCRException {
        StringBuilder regexPattern = new StringBuilder();
        for (String redirectURI : redirectURIs) {
            try {
                IdentityValidationUtil.getValidInputOverWhiteListPatterns((String)redirectURI, (String[])new String[]{IdentityValidationUtil.ValidatorPattern.URL_WITHOUT_FRAGMENT.name()});
                if (regexPattern.length() > 0) {
                    regexPattern.append("|").append(redirectURI);
                    continue;
                }
                regexPattern.append("(").append(redirectURI);
            }
            catch (IdentityValidationException e) {
                throw (DCRException)IdentityException.error(DCRException.class, (String)("Redirect URI: " + redirectURI + ", is invalid"), (Throwable)e);
            }
        }
        if (regexPattern.length() > 0) {
            regexPattern.append(")");
        }
        return regexPattern.toString();
    }

    protected Registry getConfigSystemRegistry() {
        return (Registry)PrivilegedCarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_CONFIGURATION);
    }
}

