/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.dcr.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.application.mgt.ApplicationMgtUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.OAuthAdminService;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dcr.DCRMConstants;
import org.wso2.carbon.identity.oauth.dcr.bean.Application;
import org.wso2.carbon.identity.oauth.dcr.bean.ApplicationRegistrationRequest;
import org.wso2.carbon.identity.oauth.dcr.bean.ApplicationUpdateRequest;
import org.wso2.carbon.identity.oauth.dcr.exception.DCRMClientException;
import org.wso2.carbon.identity.oauth.dcr.exception.DCRMException;
import org.wso2.carbon.identity.oauth.dcr.exception.DCRMServerException;
import org.wso2.carbon.identity.oauth.dcr.internal.DCRDataHolder;
import org.wso2.carbon.identity.oauth.dcr.util.DCRMUtils;
import org.wso2.carbon.identity.oauth.dcr.util.ErrorCodes;
import org.wso2.carbon.identity.oauth.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class DCRMService {
    private static final Log log = LogFactory.getLog(DCRMService.class);
    private static OAuthAdminService oAuthAdminService = new OAuthAdminService();
    private static final String AUTH_TYPE_OAUTH_2 = "oauth2";
    private static final String OAUTH_VERSION = "OAuth-2.0";
    private static final String GRANT_TYPE_SEPARATOR = " ";
    private static Pattern clientIdRegexPattern = null;

    public Application getApplication(String clientId) throws DCRMException {
        this.validateRequestTenantDomain(clientId);
        return this.buildResponse(this.getApplicationById(clientId, DCRMUtils.isApplicationRolePermissionRequired()));
    }

    public Application getApplicationByName(String clientName) throws DCRMException {
        if (StringUtils.isEmpty((String)clientName)) {
            throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.BAD_REQUEST_INSUFFICIENT_DATA, null);
        }
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if (!this.isServiceProviderExist(clientName, tenantDomain)) {
            throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.NOT_FOUND_APPLICATION_WITH_NAME, clientName);
        }
        try {
            OAuthConsumerAppDTO oAuthConsumerAppDTO = oAuthAdminService.getOAuthApplicationDataByAppName(clientName);
            if (!this.isUserAuthorized(oAuthConsumerAppDTO.getOauthConsumerKey())) {
                throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.FORBIDDEN_UNAUTHORIZED_USER, clientName);
            }
            return this.buildResponse(oAuthConsumerAppDTO);
        }
        catch (IdentityOAuthAdminException e) {
            throw DCRMUtils.generateServerException(DCRMConstants.ErrorMessages.FAILED_TO_GET_APPLICATION, clientName, e);
        }
    }

    public Application registerApplication(ApplicationRegistrationRequest registrationRequest) throws DCRMException {
        return this.createOAuthApplication(registrationRequest);
    }

    public void deleteApplication(String clientId) throws DCRMException {
        String spName;
        this.validateRequestTenantDomain(clientId);
        OAuthConsumerAppDTO appDTO = this.getApplicationById(clientId);
        String applicationOwner = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            spName = DCRDataHolder.getInstance().getApplicationManagementService().getServiceProviderNameByClientId(appDTO.getOauthConsumerKey(), AUTH_TYPE_OAUTH_2, tenantDomain);
        }
        catch (IdentityApplicationManagementException e) {
            throw new DCRMException("Error while retrieving the service provider.", e);
        }
        if (!StringUtils.equals((String)spName, (String)"default")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The application with consumer key: " + appDTO.getOauthConsumerKey() + " has an association with the service provider: " + spName));
            }
            this.deleteServiceProvider(spName, tenantDomain, applicationOwner);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The application with consumer key: " + appDTO.getOauthConsumerKey() + " doesn't have an associated service provider."));
            }
            this.deleteOAuthApplicationWithoutAssociatedSP(appDTO, tenantDomain, applicationOwner);
        }
    }

    public Application updateApplication(ApplicationUpdateRequest updateRequest, String clientId) throws DCRMException {
        this.validateRequestTenantDomain(clientId);
        OAuthConsumerAppDTO appDTO = this.getApplicationById(clientId);
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String applicationOwner = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
        String clientName = updateRequest.getClientName();
        ServiceProvider sp = this.getServiceProvider(appDTO.getApplicationName(), tenantDomain);
        if (StringUtils.isNotEmpty((String)clientName)) {
            if (!DCRMUtils.isRegexValidated(clientName)) {
                throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.BAD_REQUEST_INVALID_SP_NAME, DCRMUtils.getSPValidatorRegex(), null);
            }
            sp.setApplicationName(clientName);
            this.updateServiceProvider(sp, tenantDomain, applicationOwner);
        }
        try {
            if (StringUtils.isNotEmpty((String)clientName)) {
                if (!DCRMUtils.isRegexValidated(clientName)) {
                    throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.BAD_REQUEST_INVALID_SP_NAME, DCRMUtils.getSPValidatorRegex(), null);
                }
                appDTO.setApplicationName(clientName);
            }
            if (!updateRequest.getGrantTypes().isEmpty()) {
                String grantType = StringUtils.join(updateRequest.getGrantTypes(), (String)GRANT_TYPE_SEPARATOR);
                appDTO.setGrantTypes(grantType);
            }
            if (!updateRequest.getRedirectUris().isEmpty()) {
                String callbackUrl = this.validateAndSetCallbackURIs(updateRequest.getRedirectUris(), updateRequest.getGrantTypes());
                appDTO.setCallbackUrl(callbackUrl);
            }
            if (updateRequest.getTokenType() != null) {
                appDTO.setTokenType(updateRequest.getTokenType());
            }
            if (StringUtils.isNotEmpty((String)updateRequest.getBackchannelLogoutUri())) {
                String backChannelLogoutUri = this.validateBackchannelLogoutURI(updateRequest.getBackchannelLogoutUri());
                appDTO.setBackChannelLogoutUrl(backChannelLogoutUri);
            }
            oAuthAdminService.updateConsumerApplication(appDTO);
        }
        catch (IdentityOAuthAdminException e) {
            throw DCRMUtils.generateServerException(DCRMConstants.ErrorMessages.FAILED_TO_UPDATE_APPLICATION, clientId, e);
        }
        return this.buildResponse(this.getApplicationById(clientId));
    }

    private OAuthConsumerAppDTO getApplicationById(String clientId) throws DCRMException {
        return this.getApplicationById(clientId, true);
    }

    private OAuthConsumerAppDTO getApplicationById(String clientId, boolean isApplicationRolePermissionRequired) throws DCRMException {
        if (StringUtils.isEmpty((String)clientId)) {
            String errorMessage = "Invalid client_id";
            throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.BAD_REQUEST_INVALID_INPUT, errorMessage);
        }
        try {
            OAuthConsumerAppDTO dto = oAuthAdminService.getOAuthApplicationData(clientId);
            if (dto == null || StringUtils.isEmpty((String)dto.getApplicationName())) {
                throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.NOT_FOUND_APPLICATION_WITH_ID, clientId);
            }
            if (isApplicationRolePermissionRequired && !this.isUserAuthorized(clientId)) {
                throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.FORBIDDEN_UNAUTHORIZED_USER, clientId);
            }
            return dto;
        }
        catch (IdentityOAuthAdminException e) {
            if (e.getCause() instanceof InvalidOAuthClientException) {
                throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.NOT_FOUND_APPLICATION_WITH_ID, clientId);
            }
            throw DCRMUtils.generateServerException(DCRMConstants.ErrorMessages.FAILED_TO_GET_APPLICATION_BY_ID, clientId, e);
        }
    }

    private Application createOAuthApplication(ApplicationRegistrationRequest registrationRequest) throws DCRMException {
        OAuthConsumerAppDTO createdApp;
        String applicationOwner = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String spName = registrationRequest.getClientName();
        String templateName = registrationRequest.getSpTemplateName();
        if (!DCRMUtils.isRegexValidated(spName)) {
            throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.BAD_REQUEST_INVALID_SP_NAME, DCRMUtils.getSPValidatorRegex(), null);
        }
        if (this.isServiceProviderExist(spName, tenantDomain)) {
            throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.CONFLICT_EXISTING_APPLICATION, spName);
        }
        if (StringUtils.isNotEmpty((String)registrationRequest.getConsumerKey()) && this.isClientIdExist(registrationRequest.getConsumerKey())) {
            throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.CONFLICT_EXISTING_CLIENT_ID, registrationRequest.getConsumerKey());
        }
        ServiceProvider serviceProvider = this.createServiceProvider(applicationOwner, tenantDomain, spName, templateName);
        try {
            createdApp = this.createOAuthApp(registrationRequest, applicationOwner, tenantDomain, spName);
        }
        catch (DCRMException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth app: " + spName + " registration failed in tenantDomain: " + tenantDomain + ". Deleting the service provider: " + spName + " to rollback."));
            }
            this.deleteServiceProvider(spName, tenantDomain, applicationOwner);
            throw ex;
        }
        try {
            this.updateServiceProviderWithOAuthAppDetails(serviceProvider, createdApp, applicationOwner, tenantDomain);
        }
        catch (DCRMException ex) {
            this.deleteApplication(createdApp.getOauthConsumerKey());
            throw ex;
        }
        return this.buildResponse(createdApp);
    }

    private Application buildResponse(OAuthConsumerAppDTO createdApp) {
        Application application = new Application();
        application.setClientName(createdApp.getApplicationName());
        application.setClientId(createdApp.getOauthConsumerKey());
        application.setClientSecret(createdApp.getOauthConsumerSecret());
        ArrayList<String> redirectUrisList = new ArrayList<String>();
        redirectUrisList.add(createdApp.getCallbackUrl());
        application.setRedirectUris(redirectUrisList);
        List<String> grantTypesList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)createdApp.getGrantTypes())) {
            grantTypesList = Arrays.asList(createdApp.getGrantTypes().split(GRANT_TYPE_SEPARATOR));
        }
        application.setGrantTypes(grantTypesList);
        return application;
    }

    private void updateServiceProviderWithOAuthAppDetails(ServiceProvider serviceProvider, OAuthConsumerAppDTO createdApp, String applicationOwner, String tenantDomain) throws DCRMException {
        InboundAuthenticationConfig inboundAuthenticationConfig = new InboundAuthenticationConfig();
        ArrayList<InboundAuthenticationRequestConfig> inboundAuthenticationRequestConfigs = new ArrayList<InboundAuthenticationRequestConfig>();
        InboundAuthenticationRequestConfig inboundAuthenticationRequestConfig = new InboundAuthenticationRequestConfig();
        inboundAuthenticationRequestConfig.setInboundAuthKey(createdApp.getOauthConsumerKey());
        inboundAuthenticationRequestConfig.setInboundAuthType(AUTH_TYPE_OAUTH_2);
        inboundAuthenticationRequestConfigs.add(inboundAuthenticationRequestConfig);
        inboundAuthenticationConfig.setInboundAuthenticationRequestConfigs(inboundAuthenticationRequestConfigs.toArray(new InboundAuthenticationRequestConfig[inboundAuthenticationRequestConfigs.size()]));
        serviceProvider.setInboundAuthenticationConfig(inboundAuthenticationConfig);
        serviceProvider.setSaasApp(false);
        this.updateServiceProvider(serviceProvider, tenantDomain, applicationOwner);
    }

    private OAuthConsumerAppDTO createOAuthApp(ApplicationRegistrationRequest registrationRequest, String applicationOwner, String tenantDomain, String spName) throws DCRMException {
        OAuthConsumerAppDTO createdApp;
        OAuthConsumerAppDTO oAuthConsumerApp = new OAuthConsumerAppDTO();
        oAuthConsumerApp.setApplicationName(spName);
        oAuthConsumerApp.setCallbackUrl(this.validateAndSetCallbackURIs(registrationRequest.getRedirectUris(), registrationRequest.getGrantTypes()));
        String grantType = StringUtils.join(registrationRequest.getGrantTypes(), (String)GRANT_TYPE_SEPARATOR);
        oAuthConsumerApp.setGrantTypes(grantType);
        oAuthConsumerApp.setOAuthVersion(OAUTH_VERSION);
        oAuthConsumerApp.setTokenType(registrationRequest.getTokenType());
        oAuthConsumerApp.setBackChannelLogoutUrl(this.validateBackchannelLogoutURI(registrationRequest.getBackchannelLogoutUri()));
        if (StringUtils.isNotEmpty((String)registrationRequest.getConsumerKey())) {
            String clientIdRegex = OAuthServerConfiguration.getInstance().getClientIdValidationRegex();
            if (DCRMService.clientIdMatchesRegex(registrationRequest.getConsumerKey(), clientIdRegex)) {
                oAuthConsumerApp.setOauthConsumerKey(registrationRequest.getConsumerKey());
            } else {
                throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.BAD_REQUEST_CLIENT_ID_VIOLATES_PATTERN, clientIdRegex);
            }
        }
        if (StringUtils.isNotEmpty((String)registrationRequest.getConsumerSecret())) {
            oAuthConsumerApp.setOauthConsumerSecret(registrationRequest.getConsumerSecret());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating OAuth Application: " + spName + " in tenant: " + tenantDomain));
        }
        try {
            createdApp = oAuthAdminService.registerAndRetrieveOAuthApplicationData(oAuthConsumerApp);
        }
        catch (IdentityOAuthAdminException e) {
            throw DCRMUtils.generateServerException(DCRMConstants.ErrorMessages.FAILED_TO_REGISTER_APPLICATION, spName, e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created OAuth Application: " + spName + " in tenant: " + tenantDomain));
        }
        if (createdApp == null) {
            throw DCRMUtils.generateServerException(DCRMConstants.ErrorMessages.FAILED_TO_REGISTER_APPLICATION, spName);
        }
        return createdApp;
    }

    private ServiceProvider createServiceProvider(String applicationOwner, String tenantDomain, String spName, String templateName) throws DCRMException {
        ServiceProvider sp = new ServiceProvider();
        sp.setApplicationName(spName);
        User user = new User();
        user.setUserName(applicationOwner);
        user.setTenantDomain(tenantDomain);
        sp.setOwner(user);
        sp.setDescription("Service Provider for application " + spName);
        this.createServiceProvider(sp, tenantDomain, applicationOwner, templateName);
        ServiceProvider clientSP = this.getServiceProvider(spName, tenantDomain);
        if (clientSP == null) {
            throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.FAILED_TO_REGISTER_SP, spName);
        }
        return clientSP;
    }

    private boolean isServiceProviderExist(String serviceProviderName, String tenantDomain) {
        ServiceProvider serviceProvider = null;
        try {
            serviceProvider = this.getServiceProvider(serviceProviderName, tenantDomain);
        }
        catch (DCRMException e) {
            log.error((Object)("Error while retrieving service provider: " + serviceProviderName + " in tenant: " + tenantDomain));
        }
        return serviceProvider != null;
    }

    private boolean isClientIdExist(String clientId) throws DCRMException {
        try {
            OAuthConsumerAppDTO dto = oAuthAdminService.getOAuthApplicationData(clientId);
            return dto != null && StringUtils.isNotBlank((String)dto.getApplicationName());
        }
        catch (IdentityOAuthAdminException e) {
            if (e.getCause() instanceof InvalidOAuthClientException) {
                return false;
            }
            throw DCRMUtils.generateServerException(DCRMConstants.ErrorMessages.FAILED_TO_GET_APPLICATION_BY_ID, clientId, e);
        }
    }

    private ServiceProvider getServiceProvider(String applicationName, String tenantDomain) throws DCRMException {
        ServiceProvider serviceProvider = null;
        try {
            serviceProvider = DCRDataHolder.getInstance().getApplicationManagementService().getServiceProvider(applicationName, tenantDomain);
        }
        catch (IdentityApplicationManagementException e) {
            throw DCRMUtils.generateServerException(DCRMConstants.ErrorMessages.FAILED_TO_GET_SP, applicationName, e);
        }
        return serviceProvider;
    }

    private void updateServiceProvider(ServiceProvider serviceProvider, String tenantDomain, String userName) throws DCRMException {
        try {
            DCRDataHolder.getInstance().getApplicationManagementService().updateApplication(serviceProvider, tenantDomain, userName);
        }
        catch (IdentityApplicationManagementException e) {
            throw DCRMUtils.generateServerException(DCRMConstants.ErrorMessages.FAILED_TO_UPDATE_SP, serviceProvider.getApplicationName(), e);
        }
    }

    private void createServiceProvider(ServiceProvider serviceProvider, String tenantDomain, String username, String templateName) throws DCRMException {
        try {
            boolean isTemplateExists;
            if (templateName != null && !(isTemplateExists = DCRDataHolder.getInstance().getApplicationManagementService().isExistingApplicationTemplate(templateName, tenantDomain))) {
                throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.BAD_REQUEST_INVALID_SP_TEMPLATE_NAME, templateName);
            }
            DCRDataHolder.getInstance().getApplicationManagementService().createApplicationWithTemplate(serviceProvider, tenantDomain, username, templateName);
        }
        catch (IdentityApplicationManagementException e) {
            String errorMessage = "Error while creating service provider: " + serviceProvider.getApplicationName() + " in tenant: " + tenantDomain;
            throw new DCRMException(ErrorCodes.BAD_REQUEST.toString(), errorMessage, e);
        }
    }

    private void deleteServiceProvider(String applicationName, String tenantDomain, String userName) throws DCRMException {
        try {
            DCRDataHolder.getInstance().getApplicationManagementService().deleteApplication(applicationName, tenantDomain, userName);
        }
        catch (IdentityApplicationManagementException e) {
            throw DCRMUtils.generateServerException(DCRMConstants.ErrorMessages.FAILED_TO_DELETE_SP, applicationName, e);
        }
    }

    private void deleteOAuthApplicationWithoutAssociatedSP(OAuthConsumerAppDTO appDTO, String tenantDomain, String username) throws DCRMException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Delete OAuth application with the consumer key: " + appDTO.getOauthConsumerKey()));
            }
            oAuthAdminService.removeOAuthApplicationData(appDTO.getOauthConsumerKey());
        }
        catch (IdentityOAuthAdminException e) {
            throw new DCRMException("Error while deleting the OAuth application with consumer key: " + appDTO.getOauthConsumerKey(), e);
        }
        ApplicationManagementService applicationManagementService = DCRDataHolder.getInstance().getApplicationManagementService();
        try {
            ServiceProvider serviceProvider;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Get service provider with application name: " + appDTO.getApplicationName()));
            }
            if ((serviceProvider = applicationManagementService.getServiceProvider(appDTO.getApplicationName(), tenantDomain)) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("There is no service provider exists with the name: " + appDTO.getApplicationName()));
                }
            } else if (serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs().length == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Delete the service provider: " + serviceProvider.getApplicationName()));
                }
                applicationManagementService.deleteApplication(serviceProvider.getApplicationName(), tenantDomain, username);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Service provider with name: " + serviceProvider.getApplicationName() + " can not be deleted since it has association with other application/s"));
            }
        }
        catch (IdentityApplicationManagementException e) {
            throw new DCRMException("Error while deleting the service provider with the name: " + appDTO.getApplicationName(), e);
        }
    }

    private String validateAndSetCallbackURIs(List<String> redirectUris, List<String> grantTypes) throws DCRMException {
        if (redirectUris.size() == 0) {
            if (this.isRedirectURIMandatory(grantTypes)) {
                String errorMessage = "RedirectUris property must have at least one URI value when using Authorization code or implicit grant types.";
                throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.BAD_REQUEST_INVALID_INPUT, errorMessage);
            }
            return "";
        }
        if (redirectUris.size() == 1) {
            String redirectUri = redirectUris.get(0);
            if (DCRMUtils.isRedirectionUriValid(redirectUri)) {
                return redirectUri;
            }
            throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.BAD_REQUEST_INVALID_REDIRECT_URI, redirectUri);
        }
        return "regexp=" + this.createRegexPattern(redirectUris);
    }

    private String validateBackchannelLogoutURI(String backchannelLogoutUri) throws DCRMException {
        if (DCRMUtils.isBackchannelLogoutUriValid(backchannelLogoutUri)) {
            return backchannelLogoutUri;
        }
        throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.BAD_REQUEST_INVALID_BACKCHANNEL_LOGOUT_URI, backchannelLogoutUri);
    }

    private boolean isRedirectURIMandatory(List<String> grantTypes) {
        return grantTypes.contains("authorization_code") || grantTypes.contains("implicit");
    }

    private String createRegexPattern(List<String> redirectURIs) throws DCRMException {
        StringBuilder regexPattern = new StringBuilder();
        for (String redirectURI : redirectURIs) {
            if (DCRMUtils.isRedirectionUriValid(redirectURI)) {
                if (regexPattern.length() > 0) {
                    regexPattern.append("|").append(redirectURI);
                    continue;
                }
                regexPattern.append("(").append(redirectURI);
                continue;
            }
            throw DCRMUtils.generateClientException(DCRMConstants.ErrorMessages.BAD_REQUEST_INVALID_REDIRECT_URI, redirectURI);
        }
        if (regexPattern.length() > 0) {
            regexPattern.append(")");
        }
        return regexPattern.toString();
    }

    private boolean isUserAuthorized(String clientId) throws DCRMServerException {
        try {
            String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            String spName = DCRDataHolder.getInstance().getApplicationManagementService().getServiceProviderNameByClientId(clientId, AUTH_TYPE_OAUTH_2, tenantDomain);
            String threadLocalUserName = CarbonContext.getThreadLocalCarbonContext().getUsername();
            return ApplicationMgtUtil.isUserAuthorized((String)spName, (String)threadLocalUserName);
        }
        catch (IdentityApplicationManagementException e) {
            throw DCRMUtils.generateServerException(DCRMConstants.ErrorMessages.FAILED_TO_GET_APPLICATION_BY_ID, clientId, e);
        }
    }

    private static boolean clientIdMatchesRegex(String clientId, String clientIdValidatorRegex) {
        if (clientIdRegexPattern == null) {
            clientIdRegexPattern = Pattern.compile(clientIdValidatorRegex);
        }
        return clientIdRegexPattern.matcher(clientId).matches();
    }

    private void validateRequestTenantDomain(String clientId) throws DCRMException {
        try {
            String tenantDomainOfApp = OAuth2Util.getTenantDomainOfOauthApp((String)clientId);
            OAuth2Util.validateRequestTenantDomain((String)tenantDomainOfApp);
        }
        catch (InvalidOAuthClientException e) {
            throw new DCRMClientException(DCRMConstants.ErrorMessages.TENANT_DOMAIN_MISMATCH.getErrorCode(), String.format(DCRMConstants.ErrorMessages.TENANT_DOMAIN_MISMATCH.getMessage(), clientId));
        }
        catch (IdentityOAuth2Exception e) {
            throw new DCRMServerException(String.format(DCRMConstants.ErrorMessages.FAILED_TO_VALIDATE_TENANT_DOMAIN.getMessage(), clientId));
        }
    }
}

