/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.dcr.processor;

import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityMessageContext;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityProcessor;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityRequest;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityResponse;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.oauth.dcr.DCRException;
import org.wso2.carbon.identity.oauth.dcr.context.DCRMessageContext;
import org.wso2.carbon.identity.oauth.dcr.exception.RegistrationException;
import org.wso2.carbon.identity.oauth.dcr.exception.UnRegistrationException;
import org.wso2.carbon.identity.oauth.dcr.handler.RegistrationHandler;
import org.wso2.carbon.identity.oauth.dcr.handler.UnRegistrationHandler;
import org.wso2.carbon.identity.oauth.dcr.model.RegistrationRequest;
import org.wso2.carbon.identity.oauth.dcr.model.UnregistrationRequest;
import org.wso2.carbon.identity.oauth.dcr.util.DCRConstants;
import org.wso2.carbon.identity.oauth.dcr.util.ErrorCodes;
import org.wso2.carbon.identity.oauth.dcr.util.HandlerManager;

public class DCRProcessor
extends IdentityProcessor {
    private static final Log log = LogFactory.getLog(DCRProcessor.class);

    public IdentityResponse.IdentityResponseBuilder process(IdentityRequest identityRequest) throws DCRException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Request processing started by DCRProcessor.");
        }
        DCRMessageContext dcrMessageContext = new DCRMessageContext(identityRequest);
        IdentityResponse.IdentityResponseBuilder identityResponseBuilder = null;
        if (identityRequest instanceof RegistrationRequest) {
            identityResponseBuilder = this.registerOAuthApplication(dcrMessageContext);
        } else if (identityRequest instanceof UnregistrationRequest) {
            identityResponseBuilder = this.unRegisterOAuthApplication(dcrMessageContext);
        }
        return identityResponseBuilder;
    }

    public String getCallbackPath(IdentityMessageContext context) {
        return null;
    }

    public String getRelyingPartyId() {
        return null;
    }

    public String getRelyingPartyId(IdentityMessageContext identityMessageContext) {
        return null;
    }

    protected IdentityResponse.IdentityResponseBuilder registerOAuthApplication(DCRMessageContext dcrMessageContext) throws RegistrationException {
        IdentityResponse.IdentityResponseBuilder identityResponseBuilder = null;
        try {
            RegistrationHandler registrationHandler = HandlerManager.getInstance().getRegistrationHandler(dcrMessageContext);
            identityResponseBuilder = registrationHandler.handle(dcrMessageContext);
        }
        catch (DCRException e) {
            if (StringUtils.isBlank((String)e.getErrorCode())) {
                throw (RegistrationException)IdentityException.error(RegistrationException.class, (String)ErrorCodes.BAD_REQUEST.toString(), (String)e.getMessage(), (Throwable)((Object)e));
            }
            throw (RegistrationException)IdentityException.error(RegistrationException.class, (String)e.getErrorCode(), (String)e.getMessage(), (Throwable)((Object)e));
        }
        return identityResponseBuilder;
    }

    protected IdentityResponse.IdentityResponseBuilder unRegisterOAuthApplication(DCRMessageContext dcrMessageContext) throws DCRException {
        IdentityResponse.IdentityResponseBuilder identityResponseBuilder = null;
        try {
            UnRegistrationHandler unRegistrationHandler = HandlerManager.getInstance().getUnRegistrationHandler(dcrMessageContext);
            identityResponseBuilder = unRegistrationHandler.handle(dcrMessageContext);
        }
        catch (DCRException e) {
            if (StringUtils.isBlank((String)e.getErrorCode())) {
                throw (UnRegistrationException)IdentityException.error(UnRegistrationException.class, (String)ErrorCodes.BAD_REQUEST.toString(), (Throwable)((Object)e));
            }
            throw (UnRegistrationException)IdentityException.error(UnRegistrationException.class, (String)e.getErrorCode(), (Throwable)((Object)e));
        }
        return identityResponseBuilder;
    }

    public boolean canHandle(IdentityRequest identityRequest) {
        boolean canHandle = false;
        if (identityRequest != null) {
            Matcher registerMatcher = DCRConstants.DCR_ENDPOINT_REGISTER_URL_PATTERN.matcher(identityRequest.getRequestURI());
            Matcher unRegisterMatcher = DCRConstants.DCR_ENDPOINT_UNREGISTER_URL_PATTERN.matcher(identityRequest.getRequestURI());
            if (registerMatcher.matches() || unRegisterMatcher.matches()) {
                canHandle = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("canHandle " + canHandle + " by DCRProcessor."));
        }
        return canHandle;
    }
}

