/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.dcr.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityRequestFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityResponseFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityProcessor;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.oauth.dcr.factory.HttpRegistrationResponseFactory;
import org.wso2.carbon.identity.oauth.dcr.factory.HttpUnregistrationResponseFactory;
import org.wso2.carbon.identity.oauth.dcr.factory.RegistrationRequestFactory;
import org.wso2.carbon.identity.oauth.dcr.factory.UnregistrationRequestFactory;
import org.wso2.carbon.identity.oauth.dcr.handler.RegistrationHandler;
import org.wso2.carbon.identity.oauth.dcr.handler.UnRegistrationHandler;
import org.wso2.carbon.identity.oauth.dcr.internal.DCRDataHolder;
import org.wso2.carbon.identity.oauth.dcr.processor.DCRProcessor;
import org.wso2.carbon.identity.oauth.dcr.service.DCRMService;

@Component(name="identity.oauth.dcr", immediate=true)
public class DCRServiceComponent {
    private static final Log log = LogFactory.getLog(DCRServiceComponent.class);

    protected void activate(ComponentContext componentContext) {
        try {
            componentContext.getBundleContext().registerService(IdentityProcessor.class.getName(), (Object)new DCRProcessor(), null);
            componentContext.getBundleContext().registerService(HttpIdentityRequestFactory.class.getName(), (Object)new RegistrationRequestFactory(), null);
            componentContext.getBundleContext().registerService(HttpIdentityResponseFactory.class.getName(), (Object)new HttpRegistrationResponseFactory(), null);
            componentContext.getBundleContext().registerService(HttpIdentityRequestFactory.class.getName(), (Object)new UnregistrationRequestFactory(), null);
            componentContext.getBundleContext().registerService(HttpIdentityResponseFactory.class.getName(), (Object)new HttpUnregistrationResponseFactory(), null);
            componentContext.getBundleContext().registerService(RegistrationHandler.class.getName(), (Object)new RegistrationHandler(), null);
            componentContext.getBundleContext().registerService(UnRegistrationHandler.class.getName(), (Object)new UnRegistrationHandler(), null);
            componentContext.getBundleContext().registerService(DCRMService.class.getName(), (Object)new DCRMService(), null);
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while activating DCRServiceComponent", e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping DCRServiceComponent");
        }
    }

    @Reference(name="identity.oauth.dcr.handler.register", service=RegistrationHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistrationHandler")
    protected void setRegistrationHandler(RegistrationHandler registrationHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting RegistrationHandler Service");
        }
        DCRDataHolder.getInstance().getRegistrationHandlerList().add(registrationHandler);
    }

    protected void unsetRegistrationHandler(RegistrationHandler registrationHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting RegistrationHandler.");
        }
        DCRDataHolder.getInstance().getRegistrationHandlerList().add(null);
    }

    @Reference(name="identity.oauth.dcr.handler.unregister", service=UnRegistrationHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetUnRegistrationHandler")
    protected void setUnRegistrationHandler(UnRegistrationHandler unRegistrationHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting DCRManagementService.");
        }
        DCRDataHolder.getInstance().getUnRegistrationHandlerList().add(unRegistrationHandler);
    }

    protected void unsetUnRegistrationHandler(UnRegistrationHandler unRegistrationHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting UnRegistrationHandler.");
        }
        DCRDataHolder.getInstance().getUnRegistrationHandlerList().add(null);
    }

    @Reference(name="application.mgt.service", service=ApplicationManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetApplicationManagementService")
    protected void setApplicationManagementService(ApplicationManagementService applicationManagementService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting ApplicationManagement Service");
        }
        DCRDataHolder.getInstance().setApplicationManagementService(applicationManagementService);
    }

    protected void unsetApplicationManagementService(ApplicationManagementService applicationManagementService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting ApplicationManagement.");
        }
        DCRDataHolder.getInstance().setApplicationManagementService(null);
    }
}

