/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.dcr.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityResponse;
import org.wso2.carbon.identity.oauth.dcr.DCRException;
import org.wso2.carbon.identity.oauth.dcr.context.DCRMessageContext;
import org.wso2.carbon.identity.oauth.dcr.handler.AbstractDCRHandler;
import org.wso2.carbon.identity.oauth.dcr.model.RegistrationRequest;
import org.wso2.carbon.identity.oauth.dcr.model.RegistrationRequestProfile;
import org.wso2.carbon.identity.oauth.dcr.model.RegistrationResponse;
import org.wso2.carbon.identity.oauth.dcr.model.RegistrationResponseProfile;
import org.wso2.carbon.identity.oauth.dcr.service.DCRManagementService;

public class RegistrationHandler
extends AbstractDCRHandler {
    private static final Log log = LogFactory.getLog(RegistrationHandler.class);

    @Override
    public IdentityResponse.IdentityResponseBuilder handle(DCRMessageContext dcrMessageContext) throws DCRException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Request processing started by RegistrationRequestProcessor.");
        }
        RegistrationResponse.DCRRegisterResponseBuilder dcrRegisterResponseBuilder = null;
        RegistrationRequest registerRequest = (RegistrationRequest)dcrMessageContext.getIdentityRequest();
        RegistrationRequestProfile registrationRequestProfile = registerRequest.getRegistrationRequestProfile();
        registrationRequestProfile.setTenantDomain(registerRequest.getTenantDomain());
        RegistrationResponseProfile registrationResponseProfile = DCRManagementService.getInstance().registerOAuthApplication(registrationRequestProfile);
        dcrRegisterResponseBuilder = new RegistrationResponse.DCRRegisterResponseBuilder();
        dcrRegisterResponseBuilder.setRegistrationResponseProfile(registrationResponseProfile);
        return dcrRegisterResponseBuilder;
    }
}

