/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.dcr.factory;

import java.util.HashMap;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.FrameworkClientException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.FrameworkRuntimeException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityRequestFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityRequest;
import org.wso2.carbon.identity.oauth.dcr.model.UnregistrationRequest;
import org.wso2.carbon.identity.oauth.dcr.util.DCRConstants;

public class UnregistrationRequestFactory
extends HttpIdentityRequestFactory {
    private static final Log log = LogFactory.getLog(UnregistrationRequestFactory.class);

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) throws FrameworkRuntimeException {
        Matcher matcher;
        boolean canHandle = false;
        if (request != null && (matcher = DCRConstants.DCR_ENDPOINT_UNREGISTER_URL_PATTERN.matcher(request.getRequestURI())).matches() && "DELETE".equals(request.getMethod())) {
            canHandle = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("canHandle " + canHandle + " by UnregistrationRequestFactory."));
        }
        return canHandle;
    }

    public IdentityRequest.IdentityRequestBuilder create(HttpServletRequest request, HttpServletResponse response) throws FrameworkClientException {
        UnregistrationRequest.DCRUnregisterRequestBuilder unregisterRequestBuilder = new UnregistrationRequest.DCRUnregisterRequestBuilder();
        this.create(unregisterRequestBuilder, request, response);
        return unregisterRequestBuilder;
    }

    public void create(IdentityRequest.IdentityRequestBuilder builder, HttpServletRequest request, HttpServletResponse response) throws FrameworkClientException {
        UnregistrationRequest.DCRUnregisterRequestBuilder unregisterRequestBuilder = null;
        if (builder instanceof UnregistrationRequest.DCRUnregisterRequestBuilder) {
            unregisterRequestBuilder = (UnregistrationRequest.DCRUnregisterRequestBuilder)builder;
            super.create((IdentityRequest.IdentityRequestBuilder)unregisterRequestBuilder, request, response);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", request.getHeader("Authorization"));
            unregisterRequestBuilder.setMethod(request.getMethod());
            unregisterRequestBuilder.setHeaders(headers);
            String clientId = request.getParameter("userId");
            String applicationName = request.getParameter("applicationName");
            String consumerKey = null;
            Matcher matcher = DCRConstants.DCR_ENDPOINT_UNREGISTER_URL_PATTERN.matcher(request.getRequestURI());
            if (matcher.find()) {
                consumerKey = matcher.group(2);
            }
            unregisterRequestBuilder.setApplicationName(applicationName);
            unregisterRequestBuilder.setUserId(clientId);
            unregisterRequestBuilder.setConsumerKey(consumerKey);
        } else {
            log.error((Object)"Can't create unregisterRequestBuilder. builder is not an instance of UnregistrationRequest.DCRUnregisterRequestBuilder");
        }
    }
}

