/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.dcr.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.inbound.FrameworkClientException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.FrameworkRuntimeException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityRequestFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityResponse;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityRequest;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.dcr.model.RegistrationRequest;
import org.wso2.carbon.identity.oauth.dcr.model.RegistrationRequestProfile;
import org.wso2.carbon.identity.oauth.dcr.util.DCRConstants;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;

public class RegistrationRequestFactory
extends HttpIdentityRequestFactory {
    private static final Log log = LogFactory.getLog(RegistrationRequestFactory.class);

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) throws FrameworkRuntimeException {
        Matcher matcher;
        boolean canHandle = false;
        if (request != null && (matcher = DCRConstants.DCR_ENDPOINT_REGISTER_URL_PATTERN.matcher(request.getRequestURI())).matches() && "POST".equals(request.getMethod())) {
            canHandle = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("canHandle " + canHandle + " by RegistrationRequestFactory."));
        }
        return canHandle;
    }

    public RegistrationRequest.RegistrationRequestBuilder create(HttpServletRequest request, HttpServletResponse response) throws FrameworkClientException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"create RegistrationRequest.RegistrationRequestBuilder by RegistrationRequestFactory.");
        }
        RegistrationRequest.RegistrationRequestBuilder registerRequestBuilder = new RegistrationRequest.RegistrationRequestBuilder(request, response);
        this.create(registerRequestBuilder, request, response);
        return registerRequestBuilder;
    }

    public void create(IdentityRequest.IdentityRequestBuilder builder, HttpServletRequest request, HttpServletResponse response) throws FrameworkClientException {
        if (builder instanceof RegistrationRequest.RegistrationRequestBuilder) {
            RegistrationRequest.RegistrationRequestBuilder registerRequestBuilder = (RegistrationRequest.RegistrationRequestBuilder)builder;
            super.create((IdentityRequest.IdentityRequestBuilder)registerRequestBuilder, request, response);
            try {
                BufferedReader requestBodyReader = request.getReader();
                JSONParser jsonParser = new JSONParser();
                JSONObject jsonData = (JSONObject)jsonParser.parse((Reader)requestBodyReader);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DCR request json : " + jsonData.toJSONString()));
                }
                this.parseJson(jsonData, registerRequestBuilder);
            }
            catch (IOException e) {
                String errorMessage = "Error occurred while reading servlet request body, " + e.getMessage();
                FrameworkClientException.error((String)errorMessage, (Throwable)e);
            }
            catch (ParseException e) {
                String errorMessage = "Error occurred while parsing the json object, " + e.getMessage();
                FrameworkClientException.error((String)errorMessage, (Throwable)e);
            }
        }
    }

    protected void parseJson(JSONObject jsonData, RegistrationRequest.RegistrationRequestBuilder registerRequestBuilder) throws FrameworkClientException {
        String username;
        RegistrationRequestProfile registrationRequestProfile;
        block30: {
            Object objClient;
            String grantType;
            Object obj;
            registrationRequestProfile = registerRequestBuilder.getRegistrationRequestProfile();
            if (registrationRequestProfile == null) {
                registrationRequestProfile = new RegistrationRequestProfile();
            }
            if ((obj = jsonData.get((Object)"grant_types")) instanceof JSONArray) {
                JSONArray grantTypes = (JSONArray)obj;
                for (Object grantType2 : grantTypes) {
                    if (!(grantType2 instanceof String) || !IdentityUtil.isNotBlank((String)((String)grantType2))) continue;
                    registrationRequestProfile.getGrantTypes().add((String)grantType2);
                }
            } else if (obj instanceof String && IdentityUtil.isNotBlank((String)(grantType = (String)obj))) {
                registrationRequestProfile.getGrantTypes().add(grantType);
            }
            if ((obj = jsonData.get((Object)"redirect_uris")) instanceof JSONArray) {
                JSONArray redirectUris = (JSONArray)obj;
                for (Object redirectUri : redirectUris) {
                    if (!(redirectUri instanceof String)) continue;
                    registrationRequestProfile.getRedirectUris().add((String)redirectUri);
                }
            } else if (obj instanceof String) {
                registrationRequestProfile.getRedirectUris().add((String)obj);
            } else if (registrationRequestProfile.getGrantTypes().contains("authorization_code") || registrationRequestProfile.getGrantTypes().contains("implicit")) {
                throw (FrameworkClientException)IdentityException.error(FrameworkClientException.class, (String)"RedirectUris property must have at least one URI value.");
            }
            registrationRequestProfile.setTokenEndpointAuthMethod((String)jsonData.get((Object)"token_endpoint_auth_method"));
            obj = jsonData.get((Object)"response_types");
            if (obj instanceof JSONArray) {
                JSONArray responseTypes = (JSONArray)obj;
                for (int i = 0; i < responseTypes.size(); ++i) {
                    registrationRequestProfile.getResponseTypes().add(responseTypes.get(i).toString());
                }
            } else if (obj instanceof String) {
                registrationRequestProfile.getResponseTypes().add((String)obj);
            }
            if ((objClient = jsonData.get((Object)"client_name")) != null) {
                registrationRequestProfile.setClientName((String)objClient);
            } else {
                registrationRequestProfile.setClientName(UUIDGenerator.generateUUID());
            }
            registrationRequestProfile.setClientUri((String)jsonData.get((Object)"client_uri"));
            registrationRequestProfile.setLogoUri((String)jsonData.get((Object)"logo_uri"));
            obj = jsonData.get((Object)"scope");
            if (obj instanceof JSONArray) {
                JSONArray scopes = (JSONArray)obj;
                for (int i = 0; i < scopes.size(); ++i) {
                    registrationRequestProfile.getScopes().add(scopes.get(i).toString());
                }
            } else if (obj instanceof String) {
                registrationRequestProfile.getScopes().add((String)obj);
            }
            if ((obj = jsonData.get((Object)"contacts")) instanceof JSONArray) {
                JSONArray redirectUris = (JSONArray)obj;
                for (int i = 0; i < redirectUris.size(); ++i) {
                    registrationRequestProfile.getContacts().add(redirectUris.get(i).toString());
                }
            } else if (obj instanceof String) {
                registrationRequestProfile.getContacts().add((String)obj);
            }
            registrationRequestProfile.setTosUri((String)jsonData.get((Object)"tos_uri"));
            registrationRequestProfile.setPolicyUri((String)jsonData.get((Object)"policy_uri"));
            registrationRequestProfile.setJwksUri((String)jsonData.get((Object)"jwks_uri"));
            registrationRequestProfile.setJkws((String)jsonData.get((Object)"jwks"));
            registrationRequestProfile.setSoftwareId((String)jsonData.get((Object)"software_id"));
            registrationRequestProfile.setSoftwareVersion((String)jsonData.get((Object)"software_version"));
            username = CarbonContext.getThreadLocalCarbonContext().getUsername();
            if (StringUtils.isBlank((String)username)) {
                Object objOwner = jsonData.get((Object)"ext_param_owner");
                if (objOwner != null) {
                    username = (String)objOwner;
                    try {
                        UserRealm userRealm = CarbonContext.getThreadLocalCarbonContext().getUserRealm();
                        if (!userRealm.getUserStoreManager().isExistingUser(username)) {
                            throw (FrameworkClientException)IdentityException.error(FrameworkClientException.class, (String)"Invalid application owner.");
                        }
                        break block30;
                    }
                    catch (UserStoreException e) {
                        String errorMessage = "Invalid application owner, " + e.getMessage();
                        throw (FrameworkClientException)IdentityException.error(FrameworkClientException.class, (String)errorMessage, (Throwable)e);
                    }
                }
                throw (FrameworkClientException)IdentityException.error(FrameworkClientException.class, (String)"Invalid application owner.");
            }
        }
        registrationRequestProfile.setOwner(username);
        registerRequestBuilder.setRegistrationRequestProfile(registrationRequestProfile);
    }

    public HttpIdentityResponse.HttpIdentityResponseBuilder handleException(FrameworkClientException exception, HttpServletRequest request, HttpServletResponse response) {
        HttpIdentityResponse.HttpIdentityResponseBuilder builder = new HttpIdentityResponse.HttpIdentityResponseBuilder();
        String errorMessage = this.generateErrorResponse("invalid_client_metadata", exception.getMessage()).toJSONString();
        builder.setBody(errorMessage);
        builder.setStatusCode(400);
        builder.addHeader("Cache-Control", "no-store");
        builder.addHeader("Pragma", "no-cache");
        builder.addHeader("Content-Type", "application/json");
        return builder;
    }

    protected JSONObject generateErrorResponse(String error, String description) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"error", (Object)error);
        obj.put((Object)"error_description", (Object)description);
        return obj;
    }
}

