/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.dcr.factory;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityResponse;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityResponseFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityResponse;
import org.wso2.carbon.identity.oauth.dcr.exception.RegistrationException;
import org.wso2.carbon.identity.oauth.dcr.model.RegistrationResponse;
import org.wso2.carbon.identity.oauth.dcr.util.ErrorCodes;

public class HttpRegistrationResponseFactory
extends HttpIdentityResponseFactory {
    public static final String INVALID_REDIRECT_URI = "invalid_redirect_uri";
    public static final String INVALID_CLIENT_METADATA = "invalid_client_metadata";
    public static final String INVALID_SOFTWARE_STATEMENT = "invalid_software_statement";
    public static final String UNAPPROVED_SOFTWARE_STATEMENT = "unapproved_software_statement";
    public static final String BACKEND_FAILED = "backend_failed";
    public static final String FORBIDDEN = "forbidden";
    public static final String GONE = "gone";
    private static final Log log = LogFactory.getLog(HttpRegistrationResponseFactory.class);

    public HttpIdentityResponse.HttpIdentityResponseBuilder create(IdentityResponse identityResponse) {
        HttpIdentityResponse.HttpIdentityResponseBuilder httpIdentityResponseBuilder = new HttpIdentityResponse.HttpIdentityResponseBuilder();
        this.create(httpIdentityResponseBuilder, identityResponse);
        return httpIdentityResponseBuilder;
    }

    public void create(HttpIdentityResponse.HttpIdentityResponseBuilder httpIdentityResponseBuilder, IdentityResponse identityResponse) {
        RegistrationResponse registrationResponse = null;
        if (identityResponse instanceof RegistrationResponse) {
            registrationResponse = (RegistrationResponse)identityResponse;
            httpIdentityResponseBuilder.setBody(this.generateSuccessfulResponse(registrationResponse).toJSONString());
            httpIdentityResponseBuilder.setStatusCode(201);
            httpIdentityResponseBuilder.addHeader("Cache-Control", "no-store");
            httpIdentityResponseBuilder.addHeader("Pragma", "no-cache");
            httpIdentityResponseBuilder.addHeader("Content-Type", "application/json");
        } else {
            log.error((Object)"Can't create httpIdentityResponseBuilder. identityResponse is not an instance of RegistrationResponse");
        }
    }

    public HttpIdentityResponse.HttpIdentityResponseBuilder handleException(FrameworkException exception) {
        HttpIdentityResponse.HttpIdentityResponseBuilder builder = new HttpIdentityResponse.HttpIdentityResponseBuilder();
        String errorMessage = "";
        if (ErrorCodes.META_DATA_VALIDATION_FAILED.name().equals(exception.getErrorCode())) {
            errorMessage = this.generateErrorResponse(INVALID_CLIENT_METADATA, exception.getMessage()).toJSONString();
        } else {
            if (ErrorCodes.FORBIDDEN.name().equals(exception.getErrorCode())) {
                errorMessage = StringEscapeUtils.unescapeJava((String)this.generateErrorResponse(FORBIDDEN, exception.getMessage()).toJSONString());
                builder.setBody(errorMessage);
                builder.setStatusCode(403);
                return builder;
            }
            if (ErrorCodes.GONE.name().equals(exception.getErrorCode())) {
                errorMessage = StringEscapeUtils.unescapeJava((String)this.generateErrorResponse(GONE, exception.getMessage()).toJSONString());
                builder.setBody(errorMessage);
                builder.setStatusCode(410);
                return builder;
            }
            if (ErrorCodes.BAD_REQUEST.name().equals(exception.getErrorCode())) {
                errorMessage = this.generateErrorResponse(BACKEND_FAILED, exception.getMessage()).toJSONString();
            }
        }
        builder.setBody(errorMessage);
        builder.setStatusCode(400);
        builder.addHeader("Cache-Control", "no-store");
        builder.addHeader("Pragma", "no-cache");
        builder.addHeader("Content-Type", "application/json");
        return builder;
    }

    public boolean canHandle(IdentityResponse identityResponse) {
        return identityResponse instanceof RegistrationResponse;
    }

    public boolean canHandle(FrameworkException exception) {
        return exception instanceof RegistrationException;
    }

    protected JSONObject generateSuccessfulResponse(RegistrationResponse registrationResponse) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"client_id", (Object)registrationResponse.getRegistrationResponseProfile().getClientId());
        obj.put((Object)"client_name", (Object)registrationResponse.getRegistrationResponseProfile().getClientName());
        JSONArray jsonArray = new JSONArray();
        for (String redirectUri : registrationResponse.getRegistrationResponseProfile().getRedirectUrls()) {
            jsonArray.add((Object)redirectUri);
        }
        obj.put((Object)"redirect_uris", (Object)jsonArray);
        jsonArray = new JSONArray();
        for (String grantType : registrationResponse.getRegistrationResponseProfile().getGrantTypes()) {
            jsonArray.add((Object)grantType);
        }
        obj.put((Object)"grant_types", (Object)jsonArray);
        obj.put((Object)"client_secret", (Object)registrationResponse.getRegistrationResponseProfile().getClientSecret());
        obj.put((Object)"client_secret_expires_at", (Object)registrationResponse.getRegistrationResponseProfile().getClientSecretExpiresAt());
        return obj;
    }

    protected JSONObject generateErrorResponse(String error, String description) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"error", (Object)error);
        obj.put((Object)"error_description", (Object)description);
        return obj;
    }
}

