/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.dcr;

public class DCRMConstants {
    public static final String OAUTH2 = "oauth2";

    public static class ErrorCodes {
        public static final String INVALID_REDIRECT_URI = "invalid_redirect_uri";
        public static final String INVALID_CLIENT_METADATA = "invalid_client_metadata";
        public static final String INVALID_SOFTWARE_STATEMENT = "invalid_software_statement";
        public static final String UNAPPROVED_SOFTWARE_STATEMENT = "unapproved_software_statement";
    }

    public static enum ErrorMessages {
        CONFLICT_EXISTING_APPLICATION("Application with the name %s already exist in the system"),
        FAILED_TO_REGISTER_SP("Error occurred while creating service provider %s"),
        FAILED_TO_GET_SP("Error occurred while retrieving service provider %s"),
        FAILED_TO_UPDATE_SP("Error occurred while updating service provider %s"),
        FAILED_TO_DELETE_SP("Error occurred while deleting service provider %s"),
        FAILED_TO_REGISTER_APPLICATION("Error occurred while creating application with application name:  %s"),
        FAILED_TO_GET_APPLICATION("Error occurred while retrieving application with application name: %s"),
        FAILED_TO_GET_APPLICATION_BY_ID("Error occurred while retrieving application with client key: %s"),
        FAILED_TO_UPDATE_APPLICATION("Error occurred while updating application with client key: %s"),
        BAD_REQUEST_INVALID_REDIRECT_URI("Invalid redirect URI: %s"),
        BAD_REQUEST_INVALID_BACKCHANNEL_LOGOUT_URI("Invalid back-channel logout URI: %s"),
        BAD_REQUEST_INVALID_SP_NAME("Client Name is not adhering to the regex: %s"),
        BAD_REQUEST_INVALID_SP_TEMPLATE_NAME("Invalid service provider template name: %s"),
        BAD_REQUEST_INVALID_INPUT("%s"),
        BAD_REQUEST_INSUFFICIENT_DATA("Insufficient data in the request"),
        NOT_FOUND_APPLICATION_WITH_ID("Application not available for given client key: %s"),
        NOT_FOUND_APPLICATION_WITH_NAME("Application not available for given client name: %s"),
        CONFLICT_EXISTING_CLIENT_ID("Client id %s already exist in the system"),
        BAD_REQUEST_CLIENT_ID_VIOLATES_PATTERN("Provided client id is not adhering to the provided regex %s"),
        FORBIDDEN_UNAUTHORIZED_USER("User does not have access to the application %s"),
        ERROR_CODE_UNEXPECTED("Unexpected error"),
        TENANT_DOMAIN_MISMATCH("NOT_FOUND_60001", "Tenant domain in request does not match with the application tenant domain for consumer key: %s"),
        FAILED_TO_VALIDATE_TENANT_DOMAIN("Error occurred during validating tenant domain for consumer key: %s");

        private final String message;
        private final String errorCode;

        private ErrorMessages(String message) {
            this.message = message;
            this.errorCode = null;
        }

        private ErrorMessages(String errorCode, String message) {
            this.message = message;
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public String getErrorCode() {
            return this.errorCode;
        }
    }
}

