/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.eventing.internal;

import org.apache.axis2.engine.ListenerManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.governance.registry.eventing.handlers.GovernanceEventingHandler;
import org.wso2.carbon.governance.registry.eventing.internal.EventDataHolder;
import org.wso2.carbon.registry.app.RemoteRegistryService;
import org.wso2.carbon.registry.common.eventing.NotificationService;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.URLMatcher;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

@Component(name="org.wso2.carbon.governance.registry.eventing", immediate=true)
public class GovernanceRegistryEventingServiceComponent {
    private static Log log = LogFactory.getLog(GovernanceRegistryEventingServiceComponent.class);
    private Registry registry = null;
    private ListenerManager listenerManager = null;
    private boolean initialized = false;

    @Activate
    protected void activate(ComponentContext context) {
        log.debug((Object)"Governance Eventing bundle is activated ");
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Governance Eventing bundle is deactivated ");
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        EventDataHolder.getInstance().setRegistryService(registryService);
        this.initailize();
    }

    protected void unsetRegistryService(RegistryService registryService) {
        EventDataHolder.getInstance().setRegistryService(null);
    }

    @Reference(name="registry.notification.service", service=NotificationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryNotificationService")
    protected void setRegistryNotificationService(NotificationService notificationService) {
        EventDataHolder.getInstance().setRegistryNotificationService(notificationService);
        this.initailize();
    }

    protected void unsetRegistryNotificationService(NotificationService notificationService) {
        EventDataHolder.getInstance().setRegistryNotificationService(null);
    }

    @Reference(name="listener.manager.service", service=ListenerManager.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetListenerManager")
    protected void setListenerManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
        this.initailize();
    }

    protected void unsetListenerManager(ListenerManager listenerManager) {
        this.listenerManager = null;
    }

    private void initailize() {
        if (Boolean.toString(Boolean.TRUE).equals(System.getProperty("disable.event.handlers"))) {
            this.initialized = true;
            log.debug((Object)"Default Eventing Handlers have been disabled. Events will not be generated unless a custom handler has been configured.");
            return;
        }
        RegistryService registryService = EventDataHolder.getInstance().getRegistryService();
        if (!this.initialized && this.listenerManager != null && registryService != null && EventDataHolder.getInstance().getRegistryNotificationService() != null) {
            if (registryService instanceof RemoteRegistryService) {
                this.initialized = true;
                log.warn((Object)"Eventing is not available on Remote Registry");
                return;
            }
            this.initialized = true;
            try {
                UserRegistry systemRegistry = registryService.getConfigSystemRegistry();
                if (this.registry != null && this.registry == systemRegistry) {
                    return;
                }
                this.registry = systemRegistry;
                if (this.registry == null || this.registry.getRegistryContext() == null || this.registry.getRegistryContext().getHandlerManager() == null) {
                    String msg = "Error Initializing Governance Eventing Handler";
                    log.error((Object)msg);
                } else {
                    URLMatcher filter = new URLMatcher();
                    filter.setPutPattern(".*");
                    filter.setInvokeAspectPattern(".*");
                    GovernanceEventingHandler handler = new GovernanceEventingHandler();
                    this.registry.getRegistryContext().getHandlerManager().addHandler(null, (Filter)filter, (Handler)handler, "reporting");
                    handler.init(this.registry.getEventingServiceURL(null));
                    log.debug((Object)"Successfully Initialized the Governance Eventing Handler");
                }
            }
            catch (Exception e) {
                String msg = "Error Initializing Eventing on Registry";
                log.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
    }
}

