/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.eventing.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.common.GovernanceConfiguration;
import org.wso2.carbon.governance.common.GovernanceConfigurationException;
import org.wso2.carbon.governance.common.utils.GovernanceUtils;
import org.wso2.carbon.governance.lcm.tasks.LCNotificationScheduler;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.CheckListItemCheckedEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.CheckListItemUncheckedEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.LifeCycleApprovalNeededEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.LifeCycleApprovalWithdrawnEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.LifeCycleApprovedEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.LifeCycleCreatedEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.LifeCycleDeletedEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.LifeCycleStateChangedEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.PublisherCheckListItemCheckedEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.PublisherCheckListItemUncheckedEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.PublisherLifeCycleStateChangedEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.PublisherResourceUpdatedEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.StoreLifeCycleStateChangedEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.StoreResourceUpdatedEvent;
import org.wso2.carbon.governance.registry.eventing.internal.EventDataHolder;
import org.wso2.carbon.registry.common.eventing.RegistryEvent;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.eventing.services.EventingServiceImpl;

public class GovernanceEventingHandler
extends Handler {
    private static final Log log = LogFactory.getLog(GovernanceEventingHandler.class);
    private final String vote_click = "voteClick";
    private final String item_click = "itemClick";

    public void init(String defaultNotificationEndpoint) {
        EventDataHolder.getInstance().setDefaultNotificationServiceURL(defaultNotificationEndpoint);
    }

    public GovernanceEventingHandler() {
        try {
            EventDataHolder.getInstance().getRegistryNotificationService().registerEventType("checklist.item.checked", "CheckListItemChecked", "CheckListItemChecked");
            EventDataHolder.getInstance().getRegistryNotificationService().registerEventType("checklist.item.unchecked", "CheckListItemUnchecked", "CheckListItemUnchecked");
            EventDataHolder.getInstance().getRegistryNotificationService().registerEventType("lifecycle.state.changed", "LifeCycleStateChanged", "LifeCycleStateChanged");
            EventDataHolder.getInstance().getRegistryNotificationService().registerEventType("lifecycle.deleted", "LifeCycleDeleted", "LifeCycleDeleted");
            EventDataHolder.getInstance().getRegistryNotificationService().registerEventType("lifecycle.created", "LifeCycleCreated", "LifeCycleCreated");
            EventDataHolder.getInstance().getRegistryNotificationService().registerEventType("lifecycle.approved", "LifeCycleApproved", "LifeCycleApproved");
            EventDataHolder.getInstance().getRegistryNotificationService().registerEventType("lifecycle.approval.need", "LifeCycleApprovalNeeded", "LifeCycleApprovalNeeded");
            EventDataHolder.getInstance().getRegistryNotificationService().registerEventType("lifecycle.approval.withdrawn", "LifeCycleApprovalWithdrawn", "LifeCycleApprovalWithdrawn");
            EventDataHolder.getInstance().getRegistryNotificationService().registerEventType("lifecycle.checkpoint.notification", "CheckpointNotification", "CheckpointNotification");
            EventDataHolder.getInstance().getRegistryNotificationService().registerEventType("publisher.checklist.checked", "PublisherCheckListItemChecked", null);
            EventDataHolder.getInstance().getRegistryNotificationService().registerEventType("publisher.checklist.unchecked", "PublisherCheckListItemUnchecked", null);
            EventDataHolder.getInstance().getRegistryNotificationService().registerEventType("publisher.lifecycle.state.changed", "PublisherLifeCycleStateChanged", null);
            EventDataHolder.getInstance().getRegistryNotificationService().registerEventType("publisher.update", "PublisherResourceUpdated", null);
            EventDataHolder.getInstance().getRegistryNotificationService().registerEventType("store.lifecycle.state.changed", "StoreLifeCycleStateChanged", null);
            EventDataHolder.getInstance().getRegistryNotificationService().registerEventType("store.update", "StoreResourceUpdated", null);
        }
        catch (Exception e) {
            this.handleException("Unable to register Event Types", e);
        }
    }

    public void put(RequestContext requestContext) throws RegistryException {
        boolean isNotCollection;
        String path = requestContext.getResourcePath().getPath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        Resource oldResource = requestContext.getOldResource();
        Resource newResource = requestContext.getResource();
        boolean bl = isNotCollection = !(requestContext.getResource() instanceof Collection);
        if (oldResource == null || newResource == null || oldResource.getProperties() == null || newResource.getProperties() == null) {
            return;
        }
        if (!this.sendNotifications(requestContext, relativePath)) {
            return;
        }
        Properties props = oldResource.getProperties();
        Properties newProps = newResource.getProperties();
        String lcName = newResource.getProperty("registry.LC.name");
        String oldLcName = oldResource.getProperty("registry.LC.name");
        List oldLifecycleList = (List)props.get("registry.Aspects");
        List newLifecycleList = (List)newProps.get("registry.Aspects");
        boolean isNotificationSent = false;
        if (lcName == null && oldLcName != null) {
            StringBuilder messageBuilder = new StringBuilder("[").append(oldLcName).append("] The LifeCycle was deleted for resource at ").append(relativePath).append(".");
            LifeCycleDeletedEvent<String> event = new LifeCycleDeletedEvent<String>(messageBuilder.toString());
            event.setResourcePath(relativePath);
            event.setParameter("LifecycleName", oldLcName);
            event.setTenantId(CurrentSession.getCallerTenantId());
            try {
                this.notify(event, requestContext.getRegistry(), relativePath);
                isNotificationSent = true;
            }
            catch (Exception e) {
                this.handleException("Unable to send notification for Put Operation", e);
            }
            return;
        }
        if (lcName != null && oldLcName != null && !lcName.equals(oldLcName) && oldLifecycleList.size() < newLifecycleList.size()) {
            try {
                List stateList;
                GovernanceConfiguration configuration = GovernanceUtils.getGovernanceConfiguration();
                if (this.isLifecycleChecklistItemsEnabled(configuration) && (stateList = (List)newProps.get("registry.lifecycle." + lcName + ".state")) != null) {
                    String lifecycleState = (String)stateList.get(0);
                    this.addLCNotificationScheduler(newResource, lcName, lifecycleState, false);
                }
            }
            catch (GovernanceConfigurationException e) {
                this.handleException("Unable to load the configuration file", (Exception)((Object)e));
            }
        } else if (lcName != null && oldLcName == null) {
            try {
                List statesList;
                GovernanceConfiguration configuration = GovernanceUtils.getGovernanceConfiguration();
                if (this.isLifecycleChecklistItemsEnabled(configuration) && (statesList = (List)newProps.get("registry.lifecycle." + lcName + ".state")) != null) {
                    String lifecycleState = (String)statesList.get(0);
                    this.addLCNotificationScheduler(newResource, lcName, lifecycleState, false);
                }
            }
            catch (GovernanceConfigurationException e) {
                this.handleException("Unable to load the configuration file", (Exception)((Object)e));
            }
            StringBuilder messageBuilder = new StringBuilder("[").append(lcName).append("] The LifeCycle was created for resource at ").append(relativePath).append(".");
            LifeCycleCreatedEvent<String> event = new LifeCycleCreatedEvent<String>(messageBuilder.toString());
            event.setResourcePath(relativePath);
            event.setParameter("LifecycleName", lcName);
            event.setTenantId(CurrentSession.getCallerTenantId());
            try {
                this.notify(event, requestContext.getRegistry(), relativePath);
                isNotificationSent = true;
            }
            catch (Exception e) {
                this.handleException("Unable to send notification for Put Operation", e);
            }
            if (this.sendInitialNotification(requestContext, relativePath)) {
                LifeCycleApprovalNeededEvent<String> approvalEvent = new LifeCycleApprovalNeededEvent<String>("[" + lcName + "] The LifeCycle was created and some transitions are awating for approval, resource locate at " + relativePath + ".");
                approvalEvent.setResourcePath(relativePath);
                approvalEvent.setParameter("LifecycleName", lcName);
                approvalEvent.setTenantId(CurrentSession.getCallerTenantId());
                try {
                    this.notify(approvalEvent, requestContext.getRegistry(), relativePath);
                    isNotificationSent = true;
                }
                catch (Exception e) {
                    this.handleException("Unable to send notification for Put Operation", e);
                }
                return;
            }
            return;
        }
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String propKey = (String)e.getKey();
            if (!propKey.matches("registry\\p{Punct}.*\\p{Punct}checklist\\p{Punct}.*")) continue;
            List propValues = (List)e.getValue();
            List newPropValues = (List)newProps.get(propKey);
            if (propValues == null || newPropValues == null || propValues.size() <= 2 || newPropValues.size() <= 2) continue;
            String oldName = null;
            String oldValue = null;
            String oldLifeCycleState = null;
            String newName = null;
            String newValue = null;
            String newLifeCycleState = null;
            for (String param : propValues) {
                if (param.startsWith("status:")) {
                    oldLifeCycleState = param.substring(7);
                    continue;
                }
                if (param.startsWith("name:")) {
                    oldName = param.substring(5);
                    continue;
                }
                if (!param.startsWith("value:")) continue;
                oldValue = param.substring(6);
            }
            for (String param : newPropValues) {
                if (param.startsWith("status:")) {
                    newLifeCycleState = param.substring(7);
                    continue;
                }
                if (param.startsWith("name:")) {
                    newName = param.substring(5);
                    continue;
                }
                if (!param.startsWith("value:")) continue;
                newValue = param.substring(6);
            }
            if (oldName == null || oldValue == null || !oldName.equalsIgnoreCase(newName) || !oldLifeCycleState.equalsIgnoreCase(newLifeCycleState) || oldValue.equalsIgnoreCase(newValue)) continue;
            CheckListItemCheckedEvent<String> event = null;
            if (oldValue.equals(Boolean.toString(Boolean.TRUE)) || oldValue.equals(Boolean.toString(Boolean.FALSE))) {
                if (oldValue.equals(Boolean.toString(Boolean.TRUE))) {
                    event = new CheckListItemUncheckedEvent<String>("[" + lcName + "] The CheckList item '" + oldName + "' of LifeCycle State '" + oldLifeCycleState + "' was Unchecked for resource at " + relativePath + ".");
                    ((CheckListItemUncheckedEvent)((Object)event)).setResourcePath(relativePath);
                } else {
                    event = new CheckListItemCheckedEvent<String>("[" + lcName + "] The CheckList item '" + oldName + "' of LifeCycle State '" + oldLifeCycleState + "' was Checked for resource at " + relativePath + ".");
                    event.setResourcePath(relativePath);
                }
            } else {
                event = new CheckListItemCheckedEvent<String>("[" + lcName + "] The State of the CheckList item '" + oldName + "' of LifeCycle State '" + oldLifeCycleState + "' was changed for resource at " + relativePath + ".");
                event.setResourcePath(relativePath);
            }
            event.setParameter("LifecycleName", lcName);
            event.setParameter("LifecycleState", oldLifeCycleState);
            event.setParameter("CheckItem", oldName);
            event.setTenantId(CurrentSession.getCallerTenantId());
            try {
                this.notify(event, requestContext.getRegistry(), relativePath);
            }
            catch (Exception ex) {
                this.handleException("Unable to send notification for Put Operation", ex);
            }
            this.createPublisherLCNotification(event, requestContext, relativePath);
            isNotificationSent = true;
        }
        if (oldResource != null && this.sendNotifications(requestContext, relativePath) && isNotCollection && !isNotificationSent) {
            PublisherResourceUpdatedEvent<String> pubEvent = new PublisherResourceUpdatedEvent<String>("The resource at path " + relativePath + " was updated.");
            pubEvent.setResourcePath(relativePath);
            pubEvent.setParameter("RegistryOperation", "put");
            pubEvent.setTenantId(CurrentSession.getCallerTenantId());
            try {
                this.notify(pubEvent, requestContext.getRegistry(), relativePath);
            }
            catch (Exception e) {
                this.handleException("Unable to send notification for Update Operation", e);
            }
            StoreResourceUpdatedEvent<String> storeEvent = new StoreResourceUpdatedEvent<String>("The resource at path " + relativePath + " was updated.");
            storeEvent.setResourcePath(relativePath);
            storeEvent.setParameter("RegistryOperation", "put");
            storeEvent.setTenantId(CurrentSession.getCallerTenantId());
            try {
                this.notify(storeEvent, requestContext.getRegistry(), relativePath);
            }
            catch (Exception e) {
                this.handleException("Unable to send notification for Update Operation", e);
            }
        }
        this.invokeApprovalNotification(requestContext, relativePath);
    }

    public void invokeAspect(RequestContext requestContext) throws RegistryException {
        String newState;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Resource resource = requestContext.getOldResource();
        String oldPath = resource.getPath();
        Properties props = resource.getProperties();
        boolean isEnvironmentChange = false;
        ArrayList<String> properties = new ArrayList<String>();
        HashMap<String, String> changeStates = new HashMap<String, String>();
        HashMap<String, String> oldStates = new HashMap<String, String>();
        for (Object object : props.keySet()) {
            String string = (String)object;
            if (!string.matches("registry\\p{Punct}lifecycle\\p{Punct}.*\\p{Punct}state")) continue;
            properties.add(string);
        }
        if (properties.size() == 0) {
            return;
        }
        String relativeOldPath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)oldPath);
        for (String string : properties) {
            String oldState = resource.getProperty(string);
            oldStates.put(string, oldState);
        }
        if (requestContext.getAspect() == null || requestContext.getAction() == null) {
            return;
        }
        if (!requestContext.isProcessingComplete()) {
            Object object = requestContext.getProperty("parameterNames");
            if (object != null) {
                for (Object key : (Set)object) {
                    parameters.put((String)key, (String)requestContext.getProperty((String)key));
                }
                requestContext.getAspect().invoke(requestContext, requestContext.getAction(), parameters);
            } else {
                requestContext.getAspect().invoke(requestContext, requestContext.getAction());
            }
            requestContext.setProcessingComplete(true);
        }
        String string = requestContext.getResourcePath().getPath();
        String string2 = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)string);
        if (!requestContext.getRegistry().resourceExists(string)) {
            return;
        }
        resource = requestContext.getRegistry().get(string);
        if (resource == null) {
            return;
        }
        if (resource.getProperty("registry.is.environment.change.property") != null && !resource.getProperty("registry.is.environment.change.property").isEmpty()) {
            isEnvironmentChange = Boolean.parseBoolean(resource.getProperty("registry.is.environment.change.property"));
            resource.removeProperty("registry.is.environment.change.property");
            requestContext.setResource(resource);
            requestContext.getRegistry().put(string, resource);
        }
        for (String string3 : properties) {
            newState = resource.getProperty(string3);
            changeStates.put(string3, newState);
        }
        String action = requestContext.getAction();
        if (!"voteClick".equals(action) && !"itemClick".equals(action)) {
            for (String property : properties) {
                String lcName = this.getLCName(property);
                this.addLCNotificationScheduler(resource, lcName, (String)changeStates.get(property), true);
            }
        }
        Object var14_26 = null;
        newState = null;
        for (String property : properties) {
            if (changeStates.get(property) == null || oldStates.get(property) == null || ((String)changeStates.get(property)).equals(oldStates.get(property))) continue;
            String lcName = this.getLCName(property);
            String string4 = (String)oldStates.get(property);
            newState = (String)changeStates.get(property);
            String extendedMessage = "";
            boolean isUpdateOnly = false;
            if (!oldPath.equals(string)) {
                extendedMessage = resource instanceof Collection ? ". The collection has moved from: '" + relativeOldPath + "' to: '" + string2 + "'." : ". The resource has moved from: '" + relativeOldPath + "' to: '" + string2 + "'.";
            } else {
                extendedMessage = " for resource at " + string + ".";
                isUpdateOnly = true;
            }
            LifeCycleStateChangedEvent<String> event = new LifeCycleStateChangedEvent<String>("[" + lcName + "] The LifeCycle State Changed from '" + string4 + "' to '" + newState + "'" + extendedMessage);
            event.setParameter("LifecycleName", lcName);
            event.setParameter("OldLifecycleState", string4);
            event.setParameter("NewLifecycleState", newState);
            if (isEnvironmentChange) {
                event.setResourcePath(relativeOldPath);
            } else {
                event.setResourcePath(string2);
            }
            event.setTenantId(CurrentSession.getCallerTenantId());
            try {
                this.notify(event, requestContext.getRegistry(), string2);
            }
            catch (Exception e) {
                this.handleException("Unable to send notification for Aspect Invoke Operation", e);
            }
            if (isUpdateOnly) {
                this.sendPublisherLCNotification(lcName, string4, newState, isEnvironmentChange, relativeOldPath, string2, requestContext, extendedMessage);
                this.sendStoreLCNotification(lcName, string4, newState, isEnvironmentChange, relativeOldPath, string2, requestContext, extendedMessage);
            }
            if (!this.sendInitialNotification(requestContext, string2)) continue;
            LifeCycleApprovalNeededEvent<String> approveEvent = new LifeCycleApprovalNeededEvent<String>("[" + lcName + "] The LifeCycle State '" + newState + "' required approval for state transitions, for resource locate at " + string2 + ".");
            approveEvent.setParameter("LifecycleName", lcName);
            approveEvent.setParameter("OldLifecycleState", string4);
            approveEvent.setParameter("NewLifecycleState", newState);
            if (isEnvironmentChange) {
                approveEvent.setResourcePath(relativeOldPath);
            } else {
                approveEvent.setResourcePath(string2);
            }
            approveEvent.setTenantId(CurrentSession.getCallerTenantId());
            try {
                this.notify(approveEvent, requestContext.getRegistry(), string2);
            }
            catch (Exception e) {
                this.handleException("Unable to send notification for Put Operation", e);
            }
        }
    }

    protected void notify(RegistryEvent event, Registry registry, String path) throws Exception {
        try {
            if (EventDataHolder.getInstance().getRegistryNotificationService() == null) {
                log.debug((Object)"Eventing service is unavailable.");
                return;
            }
            if (registry == null || registry.getEventingServiceURL(path) == null) {
                EventDataHolder.getInstance().getRegistryNotificationService().notify(event);
                return;
            }
            if (EventDataHolder.getInstance().getDefaultNotificationServiceURL() != null) {
                if (registry.getEventingServiceURL(path).equals(EventDataHolder.getInstance().getDefaultNotificationServiceURL())) {
                    EventDataHolder.getInstance().getRegistryNotificationService().notify(event);
                    return;
                }
                EventDataHolder.getInstance().getRegistryNotificationService().notify(event, registry.getEventingServiceURL(path));
                return;
            }
            log.error((Object)"Governance Eventing Handler is not properly initialized");
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to send notification", (Throwable)e);
        }
        log.error((Object)"Unable to send notification");
    }

    private void handleException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
    }

    private void invokeApprovalNotification(RequestContext requestContext, String relativePath) {
        Resource oldResource = requestContext.getOldResource();
        Resource newResource = requestContext.getResource();
        Properties props = oldResource.getProperties();
        Properties newProps = newResource.getProperties();
        String lcName = newResource.getProperty("registry.LC.name");
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String propKey = (String)e.getKey();
            if (!propKey.matches("registry\\p{Punct}.*\\p{Punct}votes\\p{Punct}.*")) continue;
            List propValues = (List)e.getValue();
            List newPropValues = (List)newProps.get(propKey);
            if (propValues == null || newPropValues == null || propValues.size() <= 2 || newPropValues.size() <= 2) continue;
            String oldName = null;
            String oldValue = null;
            int oldVote = 0;
            String oldLifeCycleState = null;
            String newName = null;
            String newValue = null;
            int newVote = 0;
            String newLifeCycleState = null;
            for (String param : propValues) {
                if (param.startsWith("status:")) {
                    oldLifeCycleState = param.substring(7);
                    continue;
                }
                if (param.startsWith("name:")) {
                    oldName = param.substring(5);
                    continue;
                }
                if (!param.startsWith("current:")) continue;
                oldValue = param.substring(8);
                oldVote = Integer.parseInt(oldValue);
            }
            for (String param : newPropValues) {
                if (param.startsWith("status:")) {
                    newLifeCycleState = param.substring(7);
                    continue;
                }
                if (param.startsWith("name:")) {
                    newName = param.substring(5);
                    continue;
                }
                if (!param.startsWith("current:")) continue;
                newValue = param.substring(8);
                newVote = Integer.parseInt(newValue);
            }
            if (oldName == null || oldValue == null || !oldName.equalsIgnoreCase(newName) || !oldLifeCycleState.equalsIgnoreCase(newLifeCycleState) || oldValue.equalsIgnoreCase(newValue)) continue;
            RegistryEvent event = null;
            if (newVote > oldVote) {
                event = new LifeCycleApprovedEvent<String>("[" + lcName + "] LifeCycle State '" + oldLifeCycleState + "', transitions event '" + oldName + "' was approved for resource at " + relativePath + ".");
                ((LifeCycleApprovedEvent)event).setResourcePath(relativePath);
            } else {
                event = new LifeCycleApprovalWithdrawnEvent<String>("[" + lcName + "] LifeCycle State '" + oldLifeCycleState + "' transitions event '" + oldName + "' approvel was removed for resource at " + relativePath + ".");
                ((LifeCycleApprovalWithdrawnEvent)event).setResourcePath(relativePath);
            }
            event.setParameter("LifecycleName", lcName);
            event.setParameter("LifecycleState", oldLifeCycleState);
            event.setParameter("CheckItem", oldName);
            event.setTenantId(CurrentSession.getCallerTenantId());
            try {
                this.notify(event, requestContext.getRegistry(), relativePath);
            }
            catch (Exception ex) {
                this.handleException("Unable to send notification for Put Operation", ex);
            }
        }
    }

    private boolean sendInitialNotification(RequestContext requestContext, String relativePath) {
        Resource newResource = requestContext.getResource();
        Properties newProps = newResource.getProperties();
        boolean sendNotification = false;
        for (Map.Entry<Object, Object> e : newProps.entrySet()) {
            List newPropValues;
            String propKey = (String)e.getKey();
            if (!propKey.matches("registry\\p{Punct}.*\\p{Punct}votes\\p{Punct}.*") || (newPropValues = (List)newProps.get(propKey)) == null || newPropValues.size() <= 2) continue;
            String newName = null;
            for (String param : newPropValues) {
                if (!param.startsWith("name:")) continue;
                newName = param.substring(5);
            }
            if (newName == null || newName.isEmpty()) continue;
            sendNotification = true;
            return sendNotification;
        }
        return sendNotification;
    }

    private void addLCNotificationScheduler(Resource resource, String lifecycleName, String lifecycleState, boolean isInvokeAspect) {
        LCNotificationScheduler lifecycleNotificationScheduler = new LCNotificationScheduler();
        try {
            lifecycleNotificationScheduler.addScheduler((ResourceImpl)resource, lifecycleName, lifecycleState, isInvokeAspect);
        }
        catch (GovernanceException e) {
            log.error((Object)("Lifecycle '" + lifecycleName + "'checkpoint addition failed for state " + lifecycleState), (Throwable)e);
        }
    }

    private String getLCName(String property) {
        String[] peps = property.split("\\p{Punct}");
        if (peps != null && peps.length == 4) {
            return peps[2];
        }
        return null;
    }

    private void sendStoreLCNotification(String lcName, String oldState, String newState, boolean isEnvironmentChange, String relativeOldPath, String relativePath, RequestContext requestContext, String extendedMessage) {
        StoreLifeCycleStateChangedEvent<String> storeLCChanges = new StoreLifeCycleStateChangedEvent<String>("[" + lcName + "] The LifeCycle State Changed from '" + oldState + "' to '" + newState + "'" + extendedMessage);
        storeLCChanges.setParameter("LifecycleName", lcName);
        storeLCChanges.setParameter("OldLifecycleState", oldState);
        storeLCChanges.setParameter("NewLifecycleState", newState);
        if (isEnvironmentChange) {
            storeLCChanges.setResourcePath(relativeOldPath);
        } else {
            storeLCChanges.setResourcePath(relativePath);
        }
        storeLCChanges.setTenantId(CurrentSession.getCallerTenantId());
        try {
            this.notify(storeLCChanges, requestContext.getRegistry(), relativePath);
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Aspect Invoke Operation", e);
        }
    }

    private void sendPublisherLCNotification(String lcName, String oldState, String newState, boolean isEnvironmentChange, String relativeOldPath, String relativePath, RequestContext requestContext, String extendedMessage) {
        PublisherLifeCycleStateChangedEvent<String> publisherLCChanges = new PublisherLifeCycleStateChangedEvent<String>("[" + lcName + "] The LifeCycle State Changed from '" + oldState + "' to '" + newState + "'" + extendedMessage);
        publisherLCChanges.setParameter("LifecycleName", lcName);
        publisherLCChanges.setParameter("OldLifecycleState", oldState);
        publisherLCChanges.setParameter("NewLifecycleState", newState);
        if (isEnvironmentChange) {
            publisherLCChanges.setResourcePath(relativeOldPath);
        } else {
            publisherLCChanges.setResourcePath(relativePath);
        }
        publisherLCChanges.setTenantId(CurrentSession.getCallerTenantId());
        try {
            this.notify(publisherLCChanges, requestContext.getRegistry(), relativePath);
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Aspect Invoke Operation", e);
        }
    }

    private void createPublisherLCNotification(RegistryEvent event, RequestContext requestContext, String relativePath) {
        if (event instanceof CheckListItemUncheckedEvent) {
            PublisherCheckListItemUncheckedEvent<String> checkListEvent = new PublisherCheckListItemUncheckedEvent<String>(event.getMessage().toString());
            checkListEvent.setResourcePath(relativePath);
            checkListEvent.setParameter("LifecycleState", (String)event.getParameters().get("LifecycleState"));
            checkListEvent.setParameter("CheckItem", (String)event.getParameters().get("CheckItem"));
            checkListEvent.setParameter("LifecycleName", (String)event.getParameters().get("LifecycleName"));
            checkListEvent.setTenantId(CurrentSession.getCallerTenantId());
            try {
                this.notify(checkListEvent, requestContext.getRegistry(), relativePath);
            }
            catch (Exception e) {
                this.handleException("Unable to send notification for Aspect Invoke Operation", e);
            }
        } else if (event instanceof CheckListItemCheckedEvent) {
            PublisherCheckListItemCheckedEvent<String> checkListEvent = new PublisherCheckListItemCheckedEvent<String>(event.getMessage().toString());
            checkListEvent.setResourcePath(relativePath);
            checkListEvent.setParameter("LifecycleState", (String)event.getParameters().get("LifecycleState"));
            checkListEvent.setParameter("CheckItem", (String)event.getParameters().get("CheckItem"));
            checkListEvent.setTenantId(CurrentSession.getCallerTenantId());
            checkListEvent.setParameter("LifecycleName", (String)event.getParameters().get("LifecycleName"));
            try {
                this.notify(checkListEvent, requestContext.getRegistry(), relativePath);
            }
            catch (Exception e) {
                this.handleException("Unable to send notification for Aspect Invoke Operation", e);
            }
        }
    }

    private int getRequestDepth(RequestContext requestContext) {
        int requestDepth = -1;
        if (requestContext.getRegistry().getRegistryContext() != null && requestContext.getRegistry().getRegistryContext().getDataAccessManager() != null && requestContext.getRegistry().getRegistryContext().getDataAccessManager().getDatabaseTransaction() != null) {
            requestDepth = requestContext.getRegistry().getRegistryContext().getDataAccessManager().getDatabaseTransaction().getNestedDepth();
        }
        return requestDepth;
    }

    private boolean sendNotifications(RequestContext requestContext, String relativePath) {
        boolean isMountPath = false;
        List mediatypes = EventingServiceImpl.listOfMediaTypes;
        String resourceMediaType = null;
        if (requestContext.getResource() != null) {
            resourceMediaType = requestContext.getResource().getMediaType();
        }
        List mounts = requestContext.getRegistry().getRegistryContext().getMounts();
        for (Mount mount : mounts) {
            String mountPath = mount.getPath();
            if (!relativePath.startsWith(mountPath)) continue;
            isMountPath = true;
        }
        return !isMountPath || this.getRequestDepth(requestContext) == 1;
    }

    private boolean isLifecycleChecklistItemsEnabled(GovernanceConfiguration configuration) {
        return configuration.isLifecycleChecklistItemsEnabled();
    }
}

