/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.internal;

import com.hazelcast.core.HazelcastInstance;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.axis2.engine.ListenerManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.wso2.carbon.core.ServerStartupObserver;
import org.wso2.carbon.ntask.core.TaskStartupHandler;
import org.wso2.carbon.ntask.core.impl.QuartzCachedThreadPool;
import org.wso2.carbon.ntask.core.impl.TaskAxis2ConfigurationContextObserver;
import org.wso2.carbon.ntask.core.service.TaskService;
import org.wso2.carbon.ntask.core.service.impl.TaskServiceImpl;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.securevault.SecretCallbackHandlerService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="tasks.component", immediate=true)
public class TasksDSComponent {
    private static final String QUARTZ_PROPERTIES_FILE_NAME = "quartz.properties";
    private final Log log = LogFactory.getLog(TasksDSComponent.class);
    private static RegistryService registryService;
    private static RealmService realmService;
    private static Scheduler scheduler;
    private static ConfigurationContextService configCtxService;
    private static SecretCallbackHandlerService secretCallbackHandlerService;
    private static TaskService taskService;
    private static ExecutorService executor;

    @Activate
    protected void activate(ComponentContext ctx) {
        try {
            String quartzConfigFilePath;
            if (executor.isShutdown()) {
                executor = Executors.newCachedThreadPool();
            }
            StdSchedulerFactory fac = new File(quartzConfigFilePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "etc" + File.separator + QUARTZ_PROPERTIES_FILE_NAME).exists() ? new StdSchedulerFactory(quartzConfigFilePath) : new StdSchedulerFactory(this.getStandardQuartzProps());
            scheduler = fac.getScheduler();
            TasksDSComponent.getScheduler().start();
            if (TasksDSComponent.getTaskService() == null) {
                taskService = new TaskServiceImpl();
            }
            BundleContext bundleContext = ctx.getBundleContext();
            bundleContext.registerService(ServerStartupObserver.class.getName(), (Object)new TaskStartupHandler(taskService), null);
            bundleContext.registerService(TaskService.class.getName(), (Object)TasksDSComponent.getTaskService(), null);
            bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new TaskAxis2ConfigurationContextObserver(TasksDSComponent.getTaskService()), null);
            taskService.runAfterRegistrationActions();
        }
        catch (Throwable e) {
            this.log.error((Object)("Error in intializing Tasks component: " + e.getMessage()), e);
        }
    }

    private Properties getStandardQuartzProps() {
        Properties result = new Properties();
        result.put("org.quartz.scheduler.skipUpdateCheck", "true");
        result.put("org.quartz.threadPool.class", QuartzCachedThreadPool.class.getName());
        return result;
    }

    public static void executeTask(Runnable runnable) {
        executor.submit(runnable);
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        if (TasksDSComponent.getScheduler() != null) {
            try {
                TasksDSComponent.getScheduler().shutdown();
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
        executor.shutdown();
        taskService = null;
    }

    public static TaskService getTaskService() {
        return taskService;
    }

    public static Scheduler getScheduler() {
        return scheduler;
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        TasksDSComponent.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        TasksDSComponent.registryService = null;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        TasksDSComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        TasksDSComponent.realmService = null;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configCtxService) {
        TasksDSComponent.configCtxService = configCtxService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configCtxService) {
        TasksDSComponent.configCtxService = null;
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return configCtxService;
    }

    public static SecretCallbackHandlerService getSecretCallbackHandlerService() {
        return secretCallbackHandlerService;
    }

    @Reference(name="secret.callback.handler.service", service=SecretCallbackHandlerService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSecretCallbackHandlerService")
    protected void setSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        TasksDSComponent.secretCallbackHandlerService = secretCallbackHandlerService;
    }

    protected void unsetSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        TasksDSComponent.secretCallbackHandlerService = null;
    }

    public static HazelcastInstance getHazelcastInstance() {
        BundleContext ctx = FrameworkUtil.getBundle(TasksDSComponent.class).getBundleContext();
        ServiceReference ref = ctx.getServiceReference(HazelcastInstance.class);
        if (ref == null) {
            return null;
        }
        return (HazelcastInstance)ctx.getService(ref);
    }

    @Reference(name="listener.manager.service", service=ListenerManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetListenerManager")
    protected void setListenerManager(ListenerManager lm) {
    }

    protected void unsetListenerManager(ListenerManager lm) {
    }

    static {
        executor = Executors.newCachedThreadPool();
    }
}

