/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl.standalone;

import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.TaskManagerFactory;
import org.wso2.carbon.ntask.core.TaskManagerId;
import org.wso2.carbon.ntask.core.TaskRepository;
import org.wso2.carbon.ntask.core.impl.FileBasedTaskRepository;
import org.wso2.carbon.ntask.core.impl.RegistryBasedTaskRepository;
import org.wso2.carbon.ntask.core.impl.standalone.StandaloneTaskManager;

public class StandaloneTaskManagerFactory
implements TaskManagerFactory {
    private String taskRepositoryClass;

    @Override
    public TaskManager getTaskManager(TaskManagerId tmId) throws TaskException {
        return this.createTaskManager(tmId);
    }

    protected TaskManager createTaskManager(TaskManagerId tmId) throws TaskException {
        TaskRepository taskRepo = this.taskRepositoryClass != null && this.taskRepositoryClass.equalsIgnoreCase("org.wso2.carbon.ntask.core.impl.FileBasedTaskRepository") ? new FileBasedTaskRepository(tmId.getTenantId(), tmId.getTaskType()) : new RegistryBasedTaskRepository(tmId.getTenantId(), tmId.getTaskType());
        return new StandaloneTaskManager(taskRepo);
    }

    @Override
    public List<TaskManager> getStartupSchedulingTaskManagersForType(String taskType) throws TaskException {
        List<TaskManagerId> tmIds = this.taskRepositoryClass != null && this.taskRepositoryClass.equalsIgnoreCase("org.wso2.carbon.ntask.core.impl.FileBasedTaskRepository") ? FileBasedTaskRepository.getAllTenantTaskManagersForType(taskType) : RegistryBasedTaskRepository.getAllTenantTaskManagersForType(taskType);
        ArrayList<TaskManager> result = new ArrayList<TaskManager>();
        for (TaskManagerId tmId : tmIds) {
            result.add(this.createTaskManager(tmId));
        }
        return result;
    }

    @Override
    public List<TaskManager> getAllTenantTaskManagersForType(String taskType) throws TaskException {
        List<TaskManagerId> tmIds = this.taskRepositoryClass != null && this.taskRepositoryClass.equalsIgnoreCase("org.wso2.carbon.ntask.core.impl.FileBasedTaskRepository") ? FileBasedTaskRepository.getAllTenantTaskManagersForType(taskType) : RegistryBasedTaskRepository.getAllTenantTaskManagersForType(taskType);
        ArrayList<TaskManager> result = new ArrayList<TaskManager>();
        for (TaskManagerId tmId : tmIds) {
            result.add(this.createTaskManager(tmId));
        }
        return result;
    }

    public String getTaskRepositoryClass() {
        return this.taskRepositoryClass;
    }

    public void setTaskRepositoryClass(String taskRepositoryClass) {
        this.taskRepositoryClass = taskRepositoryClass;
    }
}

