/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl.remote;

import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.impl.RegistryBasedTaskRepository;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.remotetasks.stub.admin.common.xsd.StaticTaskInformation;
import org.wso2.carbon.remotetasks.stub.admin.common.xsd.TriggerInformation;
import org.wso2.carbon.user.api.UserStoreException;

public class RemoteTaskUtils {
    private static final String REMOTE_TASKS_CALLBACK_SERVLET_CONTEXT = "remote_tasks_callback";
    public static final String REG_REMOTE_TASK_PROPS_BASE_PATH = "/repository/components/org.wso2.carbon.tasks/remote_task_props";
    public static final String REMOTE_TASK_TENANT_ID = "REMOTE_TASK_TENANT_ID";
    public static final String REMOTE_TASK_TASK_TYPE = "REMOTE_TASK_TASK_TYPE";
    public static final String REMOTE_TASK_TASK_NAME = "REMOTE_TASK_TASK_NAME";

    public static String generateRemoteTaskID() {
        return UUID.randomUUID().toString() + UUID.randomUUID().toString();
    }

    private static String resourcePathFromRemoteTaskId(String remoteTaskId) {
        return "/repository/components/org.wso2.carbon.tasks/remote_task_props/" + remoteTaskId;
    }

    public static void removeRemoteTaskMapping(String remoteTaskId) throws TaskException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
            Registry registry = RegistryBasedTaskRepository.getRegistry();
            registry.delete(RemoteTaskUtils.resourcePathFromRemoteTaskId(remoteTaskId));
        }
        catch (Exception e) {
            throw new TaskException(e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public static String createRemoteTaskMapping(int tenantId, String taskType, String taskName) throws TaskException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
            Registry registry = RegistryBasedTaskRepository.getRegistry();
            Resource res = registry.newResource();
            res.setProperty(REMOTE_TASK_TENANT_ID, Integer.toString(tenantId));
            res.setProperty(REMOTE_TASK_TASK_TYPE, taskType);
            res.setProperty(REMOTE_TASK_TASK_NAME, taskName);
            String remoteTaskId = RemoteTaskUtils.generateRemoteTaskID();
            registry.put(RemoteTaskUtils.resourcePathFromRemoteTaskId(remoteTaskId), res);
            String string = remoteTaskId;
            return string;
        }
        catch (Exception e) {
            throw new TaskException(e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public static Object[] lookupRemoteTask(String remoteTaskId) throws TaskException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
            Registry registry = RegistryBasedTaskRepository.getRegistry();
            Resource res = registry.get(RemoteTaskUtils.resourcePathFromRemoteTaskId(remoteTaskId));
            Object[] result = new Object[]{Integer.parseInt(res.getProperty(REMOTE_TASK_TENANT_ID).toString()), res.getProperty(REMOTE_TASK_TASK_TYPE), res.getProperty(REMOTE_TASK_TASK_NAME)};
            Object[] objectArray = result;
            return objectArray;
        }
        catch (Exception e) {
            throw new TaskException(e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public static String getTenantDomainFromId(int tid) {
        try {
            return TasksDSComponent.getRealmService().getTenantManager().getTenant(tid).getDomain();
        }
        catch (UserStoreException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getTenantSectionInURL(int tenantId) {
        if (tenantId == -1234) {
            return "";
        }
        return "/t/" + RemoteTaskUtils.getTenantDomainFromId(tenantId);
    }

    private static String getTaskNodeBaseURL(int tenantId) {
        return TasksDSComponent.getTaskService().getServerConfiguration().getTaskClientDispatchAddress() + RemoteTaskUtils.getTenantSectionInURL(tenantId) + "/" + REMOTE_TASKS_CALLBACK_SERVLET_CONTEXT;
    }

    public static String remoteTaskNameFromTaskInfo(String taskType, String taskName) {
        return taskType + "_" + taskName;
    }

    public static StaticTaskInformation convert(TaskInfo taskInfo, String taskType, String remoteTaskId, int tenantId) throws TaskException {
        StaticTaskInformation stTaskInfo = new StaticTaskInformation();
        stTaskInfo.setName(RemoteTaskUtils.remoteTaskNameFromTaskInfo(taskType, taskInfo.getName()));
        stTaskInfo.setTargetURI(RemoteTaskUtils.getTaskNodeBaseURL(tenantId) + "/" + remoteTaskId);
        TaskInfo.TriggerInfo triggerInfo = taskInfo.getTriggerInfo();
        TriggerInformation stTriggerInfo = new TriggerInformation();
        stTriggerInfo.setCronExpression(triggerInfo.getCronExpression());
        stTriggerInfo.setStartTime(RemoteTaskUtils.dateToCal(triggerInfo.getStartTime()));
        stTriggerInfo.setEndTime(RemoteTaskUtils.dateToCal(triggerInfo.getEndTime()));
        stTriggerInfo.setTaskCount(triggerInfo.getRepeatCount());
        stTriggerInfo.setTaskInterval(triggerInfo.getIntervalMillis());
        stTaskInfo.setTriggerInformation(stTriggerInfo);
        stTaskInfo.setAllowConcurrentExecutions(!triggerInfo.isDisallowConcurrentExecution());
        return stTaskInfo;
    }

    private static Calendar dateToCal(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }
}

