/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl.remote;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.TaskManagerFactory;
import org.wso2.carbon.ntask.core.TaskManagerId;
import org.wso2.carbon.ntask.core.impl.RegistryBasedTaskRepository;
import org.wso2.carbon.ntask.core.impl.remote.RemoteTaskManager;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;
import org.wso2.carbon.ntask.core.service.TaskService;
import org.wso2.carbon.remotetasks.stub.admin.common.RemoteTaskAdmin;
import org.wso2.carbon.remotetasks.stub.admin.common.RemoteTaskAdminStub;

public class RemoteTaskManagerFactory
implements TaskManagerFactory {
    private static RemoteTaskAdminStub remoteTaskAdmin;

    @Override
    public TaskManager getTaskManager(TaskManagerId tmId) throws TaskException {
        RegistryBasedTaskRepository taskRepo = new RegistryBasedTaskRepository(tmId.getTenantId(), tmId.getTaskType());
        return new RemoteTaskManager(taskRepo, RemoteTaskManagerFactory.getRemoteTaskAdmin());
    }

    @Override
    public List<TaskManager> getStartupSchedulingTaskManagersForType(String taskType) throws TaskException {
        return new ArrayList<TaskManager>();
    }

    @Override
    public List<TaskManager> getAllTenantTaskManagersForType(String taskType) throws TaskException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RemoteTaskAdmin getRemoteTaskAdmin() throws TaskException {
        if (remoteTaskAdmin != null) return remoteTaskAdmin;
        Class<RemoteTaskManagerFactory> clazz = RemoteTaskManagerFactory.class;
        synchronized (RemoteTaskManagerFactory.class) {
            if (remoteTaskAdmin != null) return remoteTaskAdmin;
            TaskService.TaskServiceConfiguration serverConfig = TasksDSComponent.getTaskService().getServerConfiguration();
            String username = serverConfig.getRemoteServerUsername();
            String password = serverConfig.getRemoteServerPassword();
            String taskServerAddress = serverConfig.getRemoteServerAddress();
            try {
                remoteTaskAdmin = new RemoteTaskAdminStub(taskServerAddress + "/services/RemoteTaskAdmin");
            }
            catch (AxisFault e) {
                throw new TaskException(e.getMessage(), TaskException.Code.UNKNOWN, (Exception)((Object)e));
            }
            HttpTransportProperties.Authenticator auth = new HttpTransportProperties.Authenticator();
            auth.setUsername(username);
            auth.setPassword(password);
            auth.setPreemptiveAuthentication(true);
            remoteTaskAdmin._getServiceClient().getOptions().setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)auth);
            remoteTaskAdmin._getServiceClient().getOptions().setCallTransportCleanup(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return remoteTaskAdmin;
        }
    }
}

