/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl.remote;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.impl.remote.RemoteTaskManager;
import org.wso2.carbon.ntask.core.impl.remote.RemoteTaskUtils;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;

public class RemoteTaskCallbackServlet
extends HttpServlet {
    private final Log log = LogFactory.getLog(RemoteTaskCallbackServlet.class);
    private static final long serialVersionUID = -8777558000344655739L;
    public static final String REMOTE_SYSTEM_TASK_HEADER_ID = "REMOTE_SYSTEM_TASK_ID";

    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        this.doPost(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) {
        String taskType = null;
        try {
            String remoteTaskId = req.getHeader(REMOTE_SYSTEM_TASK_HEADER_ID);
            if (remoteTaskId == null) {
                return;
            }
            if (!TasksDSComponent.getTaskService().isServerInit()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Ignoring remote task triggered before server startup: " + remoteTaskId));
                }
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Remote Task Request Received: " + remoteTaskId));
            }
            Object[] taskInfo = RemoteTaskUtils.lookupRemoteTask(remoteTaskId);
            int tenantId = (Integer)taskInfo[0];
            taskType = (String)taskInfo[1];
            String taskName = (String)taskInfo[2];
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId, true);
                TaskManager tm = TasksDSComponent.getTaskService().getTaskManager(taskType);
                if (!(tm instanceof RemoteTaskManager)) {
                    this.log.error((Object)("The server is not running in remote task mode, the current task manager type used is '" + tm.getClass() + "'"));
                    return;
                }
                ((RemoteTaskManager)tm).runTask(taskName);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        catch (TaskException e) {
            if (e.getCode().equals((Object)TaskException.Code.TASK_NODE_NOT_AVAILABLE)) {
                this.log.debug((Object)("Remote task request dispatched to an unsupported task node with task type: " + taskType + " returning a SC_NOT_FOUND error code"));
                res.setStatus(404);
            }
            this.log.error((Object)("Error in executing remote task request: " + e.getMessage()), (Throwable)e);
        }
    }
}

