/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl.clustered.rpc;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.impl.clustered.ClusteredTaskManager;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;

public abstract class TaskCall<V>
implements Callable<V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int tenantId;
    private String taskType;

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public String getTaskType() {
        return this.taskType;
    }

    @Override
    public V call() throws Exception {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.getTenantId(), true);
            TaskManager tm = TasksDSComponent.getTaskService().getTaskManager(this.getTaskType());
            if (tm instanceof ClusteredTaskManager) {
                V v = this.doWork((ClusteredTaskManager)tm);
                return v;
            }
            throw new TaskException("Invalid task manager type, expected 'clustered' type, got: " + tm, TaskException.Code.CONFIG_ERROR);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public abstract V doWork(ClusteredTaskManager var1) throws Exception;
}

