/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl.clustered;

import com.hazelcast.core.ILock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskLocationResolver;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.TaskRepository;
import org.wso2.carbon.ntask.core.TaskServiceContext;
import org.wso2.carbon.ntask.core.TaskUtils;
import org.wso2.carbon.ntask.core.impl.AbstractQuartzTaskManager;
import org.wso2.carbon.ntask.core.impl.clustered.ClusterGroupCommunicator;
import org.wso2.carbon.ntask.core.impl.clustered.rpc.DeleteTaskCall;
import org.wso2.carbon.ntask.core.impl.clustered.rpc.PauseTaskCall;
import org.wso2.carbon.ntask.core.impl.clustered.rpc.RescheduleTaskCall;
import org.wso2.carbon.ntask.core.impl.clustered.rpc.ResumeTaskCall;
import org.wso2.carbon.ntask.core.impl.clustered.rpc.RunningTasksInServerCall;
import org.wso2.carbon.ntask.core.impl.clustered.rpc.ScheduleTaskCall;
import org.wso2.carbon.ntask.core.impl.clustered.rpc.TaskCall;
import org.wso2.carbon.ntask.core.impl.clustered.rpc.TaskStateCall;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;
import org.wso2.carbon.ntask.core.service.TaskService;

public class ClusteredTaskManager
extends AbstractQuartzTaskManager {
    private static final String TASK_MEMBER_LOCATION_META_PROP_ID = "TASK_MEMBER_LOCATION_META_PROP_ID";
    private static final int TASKSERVICE_AVAILABILITY_CHECK_RETRY_COUNT = 10;
    private final TaskService taskService = TasksDSComponent.getTaskService();
    private static final Log log = LogFactory.getLog(ClusteredTaskManager.class);

    public ClusteredTaskManager(TaskRepository taskRepository) throws TaskException {
        super(taskRepository);
    }

    @Override
    public int getTenantId() {
        return this.getTaskRepository().getTenantId();
    }

    @Override
    public String getTaskType() {
        return this.getTaskRepository().getTasksType();
    }

    public ClusterGroupCommunicator getClusterComm() throws TaskException {
        return ClusterGroupCommunicator.getInstance(this.getTaskType());
    }

    @Override
    public void initStartupTasks() throws TaskException {
        if (this.isLeader()) {
            try {
                this.scheduleMissingTasks();
            }
            catch (TaskException e) {
                log.error((Object)("Encountered error(s) in scheduling missing tasks [" + this.getTaskType() + "][" + this.getTenantId() + "]:-\n" + e.getMessage() + "\n"));
            }
        }
    }

    public void scheduleMissingTasks() throws TaskException {
        List<List<TaskInfo>> tasksInServers = this.getAllRunningTasksInServers();
        ArrayList<TaskInfo> scheduledTasks = new ArrayList<TaskInfo>();
        for (List<TaskInfo> entry : tasksInServers) {
            scheduledTasks.addAll(entry);
        }
        scheduledTasks.addAll(this.getAllFinishedTasks());
        List<TaskInfo> allTasks = this.getAllTasks();
        ArrayList<TaskInfo> missingTasks = new ArrayList<TaskInfo>(allTasks);
        missingTasks.removeAll(scheduledTasks);
        StringBuilder errors = new StringBuilder();
        boolean error = false;
        for (TaskInfo task : missingTasks) {
            try {
                this.scheduleTask(task.getName());
            }
            catch (Exception e) {
                errors.append(e.getMessage() + "\n");
                error = true;
            }
        }
        if (error) {
            throw new TaskException(errors.toString(), TaskException.Code.UNKNOWN);
        }
    }

    public void scheduleMissingTasks(String memberId) throws TaskException {
        List<TaskInfo> scheduledTasks = this.getAllRunningTasksInOtherMembers(memberId);
        scheduledTasks.addAll(this.getAllFinishedTasks());
        List<TaskInfo> allTasks = this.getAllTasks();
        ArrayList<TaskInfo> missingTasks = new ArrayList<TaskInfo>(allTasks);
        missingTasks.removeAll(scheduledTasks);
        StringBuilder errors = new StringBuilder();
        boolean error = false;
        for (TaskInfo task : missingTasks) {
            try {
                if (this.isTaskServiceAvailable(task.getName())) {
                    this.scheduleTask(task.getName());
                    continue;
                }
                throw new TaskException("The task service not available for the task: " + task.getName(), TaskException.Code.UNKNOWN);
            }
            catch (Exception e) {
                errors.append(e.getMessage() + "\n");
                error = true;
            }
        }
        if (error) {
            throw new TaskException(errors.toString(), TaskException.Code.UNKNOWN);
        }
    }

    private boolean isTaskServiceAvailable(String taskName) {
        long retryInterval = this.taskService.getServerConfiguration().getRetryInterval();
        for (int count = this.taskService.getServerConfiguration().getRetryCount(); count > 0; --count) {
            try {
                TaskManager.TaskState taskState = this.getTaskState(taskName);
                if (taskState.equals((Object)TaskManager.TaskState.NONE)) {
                    this.scheduleTask(taskName);
                }
                return true;
            }
            catch (TaskException e) {
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleTask(String taskName) throws TaskException {
        String taskLockId = this.getTaskType() + "_" + this.getTenantId() + "_" + taskName;
        ILock lock = this.getClusterComm().getHazelcast().getLock(taskLockId);
        try {
            lock.lock();
            String memberId = this.getMemberIdFromTaskName(taskName, true);
            this.setServerLocationOfTask(taskName, memberId);
            this.scheduleTask(memberId, taskName);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void rescheduleTask(String taskName) throws TaskException {
        String memberId = this.getMemberIdFromTaskName(taskName, true);
        this.setServerLocationOfTask(taskName, memberId);
        this.rescheduleTask(memberId, taskName);
    }

    public Map<String, TaskManager.TaskState> getAllTaskStates() throws TaskException {
        try {
            List<TaskInfo> tasks = this.getAllTasks();
            HashMap<String, TaskManager.TaskState> result = new HashMap<String, TaskManager.TaskState>();
            for (TaskInfo task : tasks) {
                result.put(task.getName(), this.getTaskState(task.getName()));
            }
            return result;
        }
        catch (Exception e) {
            throw new TaskException("Error in getting all task states: " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    @Override
    public TaskManager.TaskState getTaskState(String taskName) throws TaskException {
        try {
            String memberId = this.getMemberIdFromTaskName(taskName, false);
            return this.getTaskState(memberId, taskName);
        }
        catch (TaskException e) {
            if (e.getCode().equals((Object)TaskException.Code.NO_TASK_EXISTS)) {
                return TaskManager.TaskState.NONE;
            }
            throw e;
        }
        catch (Exception e) {
            throw new TaskException("Error in getting task state: " + taskName + " : " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    @Override
    public boolean deleteTask(String taskName) throws TaskException {
        String memberId;
        boolean result;
        block5: {
            result = true;
            memberId = null;
            try {
                memberId = this.getMemberIdFromTaskName(taskName, false);
            }
            catch (TaskException e) {
                if (TaskException.Code.NO_TASK_EXISTS.equals((Object)e.getCode())) break block5;
                throw e;
            }
        }
        try {
            if (memberId != null) {
                result = this.deleteTask(memberId, taskName);
            }
        }
        catch (Exception e) {
            throw new TaskException("Error in deleting task: " + taskName + " : " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
        return result &= this.getTaskRepository().deleteTask(taskName);
    }

    @Override
    public void pauseTask(String taskName) throws TaskException {
        String memberId = this.getMemberIdFromTaskName(taskName, false);
        this.pauseTask(memberId, taskName);
        TaskUtils.setTaskPaused(this.getTaskRepository(), taskName, true);
    }

    @Override
    public void resumeTask(String taskName) throws TaskException {
        String memberId = this.getMemberIdFromTaskName(taskName, false);
        this.resumeTask(memberId, taskName);
        TaskUtils.setTaskPaused(this.getTaskRepository(), taskName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTask(TaskInfo taskInfo) throws TaskException {
        String taskLockId = this.getTaskType() + "_" + this.getTenantId() + "_" + taskInfo.getName();
        ILock lock = this.getClusterComm().getHazelcast().getLock(taskLockId);
        try {
            lock.lock();
            String locationId = this.getTaskRepository().getTaskMetadataProp(taskInfo.getName(), TASK_MEMBER_LOCATION_META_PROP_ID);
            this.registerLocalTask(taskInfo);
            if (locationId != null) {
                this.getTaskRepository().setTaskMetadataProp(taskInfo.getName(), TASK_MEMBER_LOCATION_META_PROP_ID, locationId);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public TaskInfo getTask(String taskName) throws TaskException {
        return this.getTaskRepository().getTask(taskName);
    }

    @Override
    public List<TaskInfo> getAllTasks() throws TaskException {
        return this.getTaskRepository().getAllTasks();
    }

    public int getServerCount() throws TaskException {
        return this.getMemberIds().size();
    }

    private TaskServiceContext getTaskServiceContext() throws TaskException {
        TaskServiceContext context = new TaskServiceContext(this.getTaskRepository(), this.getMemberIds(), this.getClusterComm().getMemberMap());
        return context;
    }

    private String locateMemberForTask(String taskName) throws TaskException {
        List<String> ids;
        int location = this.getTaskLocation(taskName);
        try {
            ids = this.getMemberIds();
        }
        catch (Exception e) {
            throw new TaskException("Error in getting member ids: " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
        int index = location % ids.size();
        return ids.get(index);
    }

    private int getTaskLocation(String taskName) throws TaskException {
        TaskLocationResolver locationResolver;
        TaskInfo taskInfo = this.getTask(taskName);
        try {
            locationResolver = (TaskLocationResolver)Class.forName(taskInfo.getLocationResolverClass()).newInstance();
        }
        catch (Exception e) {
            throw new TaskException(e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
        TaskServiceContext ctx = this.getTaskServiceContext();
        if (ctx.getServerCount() == 0) {
            throw new TaskException("No available task nodes for resolving a task location", TaskException.Code.TASK_NODE_NOT_AVAILABLE);
        }
        Map<String, String> props = taskInfo.getLocationResolverProperties();
        if (props == null) {
            props = new HashMap<String, String>();
        }
        locationResolver.init(props);
        return locationResolver.getLocation(ctx, taskInfo);
    }

    public List<TaskInfo> getAllRunningTasksInOtherMembers(String memberId) throws TaskException {
        ArrayList<TaskInfo> results = new ArrayList<TaskInfo>();
        List<String> ids = this.getMemberIds();
        for (String id : ids) {
            if (id.equals(memberId)) continue;
            results.addAll(this.getRunningTasksInServer(id));
        }
        return results;
    }

    public List<List<TaskInfo>> getAllRunningTasksInServers() throws TaskException {
        ArrayList<List<TaskInfo>> result = new ArrayList<List<TaskInfo>>();
        List<String> ids = this.getMemberIds();
        for (String id : ids) {
            result.add(this.getRunningTasksInServer(id));
        }
        return result;
    }

    @Override
    public boolean isTaskScheduled(String taskName) throws TaskException {
        return this.getTaskState(taskName) != TaskManager.TaskState.NONE;
    }

    public <V> V sendReceive(String memberId, TaskCall<V> taskCall) throws TaskException {
        taskCall.setTenantId(this.getTenantId());
        taskCall.setTaskType(this.getTaskType());
        return this.getClusterComm().sendReceive(memberId, taskCall);
    }

    public List<String> getMemberIds() throws TaskException {
        return this.getClusterComm().getMemberIds();
    }

    public String getMemberId() throws TaskException {
        return this.getClusterComm().getMemberId();
    }

    public boolean isLeader() throws TaskException {
        return this.getClusterComm().isLeader();
    }

    public String getMemberIdFromTaskName(String taskName, boolean createIfNotExists) throws TaskException {
        String location = this.getServerLocationOfTask(taskName);
        if (location == null || !this.getMemberIds().contains(location)) {
            if (createIfNotExists) {
                location = this.locateMemberForTask(taskName);
            } else {
                throw new TaskException("The task server cannot be located for task: " + taskName, TaskException.Code.NO_TASK_EXISTS);
            }
        }
        return location;
    }

    public List<TaskInfo> getRunningTasksInServer(String memberId) throws TaskException {
        return this.sendReceive(memberId, new RunningTasksInServerCall());
    }

    public List<TaskInfo> getFinalRunningTasksInServer() throws Exception {
        return this.getAllLocalRunningTasks();
    }

    public TaskManager.TaskState getTaskState(String memberId, String taskName) throws Exception {
        return this.sendReceive(memberId, new TaskStateCall(taskName));
    }

    public TaskManager.TaskState getFinalTaskState(String taskName) throws Exception {
        return this.getLocalTaskState(taskName);
    }

    public void scheduleTask(String memberId, String taskName) throws TaskException {
        this.sendReceive(memberId, new ScheduleTaskCall(taskName));
    }

    public void finalScheduleTask(String taskName) throws Exception {
        this.scheduleLocalTask(taskName);
    }

    public void rescheduleTask(String memberId, String taskName) throws TaskException {
        this.sendReceive(memberId, new RescheduleTaskCall(taskName));
    }

    public void finalRescheduleTask(String taskName) throws Exception {
        this.rescheduleLocalTask(taskName);
    }

    public boolean deleteTask(String memberId, String taskName) throws Exception {
        return this.sendReceive(memberId, new DeleteTaskCall(taskName));
    }

    public boolean finalDeleteTask(String taskName) throws Exception {
        return this.deleteLocalTask(taskName, false);
    }

    public void pauseTask(String memberId, String taskName) throws TaskException {
        this.sendReceive(memberId, new PauseTaskCall(taskName));
    }

    public void finalPauseTask(String taskName) throws Exception {
        this.pauseLocalTask(taskName);
    }

    public void resumeTask(String memberId, String taskName) throws TaskException {
        this.sendReceive(memberId, new ResumeTaskCall(taskName));
    }

    public void finalResumeTask(String taskName) throws Exception {
        this.resumeLocalTask(taskName);
    }

    private void setServerLocationOfTask(String taskName, String memberId) throws TaskException {
        this.getTaskRepository().setTaskMetadataProp(taskName, TASK_MEMBER_LOCATION_META_PROP_ID, memberId);
    }

    private String getServerLocationOfTask(String taskName) throws TaskException {
        return this.getTaskRepository().getTaskMetadataProp(taskName, TASK_MEMBER_LOCATION_META_PROP_ID);
    }

    @Override
    public void deleteLocalTasks() throws TaskException {
        super.deleteLocalTasks();
    }
}

