/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl.clustered;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.impl.clustered.ClusteredTaskManager;
import org.wso2.carbon.ntask.core.impl.clustered.rpc.TaskCall;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;
import org.wso2.carbon.ntask.core.service.TaskService;

public class ClusterGroupCommunicator
implements MembershipListener {
    public static final String NTASK_P2P_COMM_EXECUTOR = "__NTASK_P2P_COMM_EXECUTOR__";
    private static final String TASK_SERVER_STARTUP_COUNTER = "__TASK_SERVER_STARTUP_COUNTER__";
    private static final int MISSING_TASKS_ON_ERROR_RETRY_COUNT = 3;
    private static final String CARBON_TASKS_MEMBER_ID_MAP = "__CARBON_TASKS_MEMBER_ID_MAP__";
    public static final String TASK_SERVER_COUNT_SYS_PROP = "task.server.count";
    private static final Log log = LogFactory.getLog(ClusterGroupCommunicator.class);
    private TaskService taskService;
    private HazelcastInstance hazelcast;
    private static Map<String, ClusterGroupCommunicator> communicatorMap = new HashMap<String, ClusterGroupCommunicator>();
    private Map<String, Member> membersMap;
    private String taskType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterGroupCommunicator getInstance(String taskType) throws TaskException {
        if (communicatorMap.containsKey(taskType)) {
            return communicatorMap.get(taskType);
        }
        Map<String, ClusterGroupCommunicator> map = communicatorMap;
        synchronized (map) {
            if (!communicatorMap.containsKey(taskType)) {
                communicatorMap.put(taskType, new ClusterGroupCommunicator(taskType));
            }
            return communicatorMap.get(taskType);
        }
    }

    private ClusterGroupCommunicator(String taskType) throws TaskException {
        this.taskType = taskType;
        this.taskService = TasksDSComponent.getTaskService();
        this.hazelcast = TasksDSComponent.getHazelcastInstance();
        if (this.getHazelcast() == null) {
            throw new TaskException("ClusterGroupCommunicator cannot initialize, Hazelcast is not initialized", TaskException.Code.CONFIG_ERROR);
        }
        this.getHazelcast().getCluster().addMembershipListener((MembershipListener)this);
        this.refreshMembers();
    }

    private void refreshMembers() {
        this.membersMap = this.getHazelcast().getMap("__CARBON_TASKS_MEMBER_ID_MAP__#" + this.taskType);
        this.checkAndRemoveExpiredMembers();
    }

    public void addMyselfToGroup() {
        Member member = this.getHazelcast().getCluster().getLocalMember();
        this.membersMap.put(this.getIdFromMember(member), member);
        this.getHazelcast().getAtomicLong(this.getStartupCounterName()).incrementAndGet();
    }

    private void checkAndRemoveExpiredMembers() {
        Set existingMembers = this.getHazelcast().getCluster().getMembers();
        Iterator<Map.Entry<String, Member>> itr = this.membersMap.entrySet().iterator();
        ArrayList<String> removeList = new ArrayList<String>();
        while (itr.hasNext()) {
            Map.Entry<String, Member> currentEntry = itr.next();
            if (existingMembers.contains(currentEntry.getValue())) continue;
            removeList.add(currentEntry.getKey());
        }
        for (String key : removeList) {
            this.membersMap.remove(key);
        }
    }

    public String getStartupCounterName() {
        return TASK_SERVER_STARTUP_COUNTER + this.getTaskType();
    }

    public String getTaskType() {
        return this.taskType;
    }

    private String getIdFromMember(Member member) {
        return member.getUuid();
    }

    private Member getMemberFromId(String id) throws TaskException {
        Member member = this.membersMap.get(id);
        if (member == null) {
            throw new TaskException("The member with id: " + id + " does not exist", TaskException.Code.UNKNOWN);
        }
        return member;
    }

    public void checkServers() throws TaskException {
        int serverCount = this.getTaskService().getServerConfiguration().getTaskServerCount();
        if (serverCount != -1) {
            log.info((Object)("Waiting for " + serverCount + " [" + this.getTaskType() + "] task executor nodes..."));
            try {
                while (this.getHazelcast().getAtomicLong(this.getStartupCounterName()).get() < (long)serverCount) {
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                throw new TaskException("Error in waiting for task [" + this.getTaskType() + "] executor nodes: " + e.getMessage(), TaskException.Code.UNKNOWN, e);
            }
            log.info((Object)("All task servers activated for [" + this.getTaskType() + "]."));
        }
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public HazelcastInstance getHazelcast() {
        return this.hazelcast;
    }

    public synchronized List<String> getMemberIds() throws TaskException {
        return new ArrayList<String>(this.membersMap.keySet());
    }

    public String getMemberId() {
        return this.getIdFromMember(this.getHazelcast().getCluster().getLocalMember());
    }

    public boolean isLeader() {
        if (this.getHazelcast().getLifecycleService().isRunning()) {
            for (Member member : this.getHazelcast().getCluster().getMembers()) {
                String id = this.getIdFromMember(member);
                if (!this.membersMap.containsKey(id)) continue;
                return this.getMemberId().equals(id);
            }
        }
        return false;
    }

    public <V> V sendReceive(String memberId, TaskCall<V> taskCall) throws TaskException {
        IExecutorService es = this.getHazelcast().getExecutorService(NTASK_P2P_COMM_EXECUTOR);
        Future taskExec = es.submitToMember(taskCall, this.getMemberFromId(memberId));
        try {
            return taskExec.get();
        }
        catch (Exception e) {
            throw new TaskException("Error in cluster message send-receive: " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    public void memberAdded(MembershipEvent event) {
        if (this.getHazelcast().getLifecycleService().isRunning()) {
            String id = this.getIdFromMember(event.getMember());
            this.membersMap.put(id, event.getMember());
            try {
                if (this.isLeader()) {
                    log.info((Object)("Task [" + this.getTaskType() + "] member joined [" + event.getMember().toString() + "], rescheduling missing tasks..."));
                    this.scheduleAllMissingTasks(id);
                }
            }
            catch (TaskException e) {
                log.error((Object)("Error in scheduling missing tasks [" + this.getTaskType() + "]: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void scheduleAllMissingTasks(String memberId) throws TaskException {
        for (TaskManager tm : this.getTaskService().getAllTenantTaskManagersForType(this.getTaskType())) {
            if (!(tm instanceof ClusteredTaskManager)) continue;
            this.scheduleMissingTasksWithRetryOnError((ClusteredTaskManager)tm, memberId);
        }
    }

    private void scheduleMissingTasksWithRetryOnError(ClusteredTaskManager tm, String memberId) {
        for (int count = 3; count > 0; --count) {
            try {
                if (memberId == null) {
                    tm.scheduleMissingTasks();
                    break;
                }
                tm.scheduleMissingTasks(memberId);
                break;
            }
            catch (TaskException e) {
                boolean retry = count > 1;
                log.error((Object)("Encountered error(s) in scheduling missing tasks [" + tm.getTaskType() + "][" + tm.getTenantId() + "]:- \n" + e.getMessage() + "\n" + (retry ? "Retrying [" + (3 - count + 1) + "]..." : "Giving up.")));
                if (!retry) continue;
                this.cleanupTaskCluster();
                continue;
            }
        }
    }

    private void cleanupTaskCluster() {
        this.refreshMembers();
    }

    public void memberRemoved(MembershipEvent event) {
        if (this.getHazelcast().getLifecycleService().isRunning()) {
            String id = this.getIdFromMember(event.getMember());
            this.membersMap.remove(id);
            try {
                if (this.isLeader()) {
                    log.info((Object)("Task [" + this.getTaskType() + "] member departed [" + event.getMember().toString() + "], rescheduling missing tasks..."));
                    this.scheduleAllMissingTasks(null);
                }
            }
            catch (TaskException e) {
                log.error((Object)("Error in scheduling missing tasks [" + this.getTaskType() + "]: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    public Map<String, Member> getMemberMap() {
        return this.membersMap;
    }
}

