/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ntask.core.Task;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;

public class TaskQuartzJobAdapter
implements Job {
    private static final Log log = LogFactory.getLog(TaskQuartzJobAdapter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext ctx) throws JobExecutionException {
        if (!TasksDSComponent.getTaskService().isServerInit()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ignoring task triggered before server startup: " + ctx.getJobDetail()));
            }
            return;
        }
        JobDataMap dataMap = ctx.getJobDetail().getJobDataMap();
        String taskClassName = dataMap.getString("__TASK_CLASS_NAME__");
        if (taskClassName == null) {
            throw new JobExecutionException("The task class is missing in the job data map");
        }
        try {
            Task task = (Task)Class.forName(taskClassName).newInstance();
            Map properties = (Map)dataMap.get((Object)"__TASK_PROPERTIES__");
            task.setProperties(properties);
            int tenantId = Integer.parseInt((String)properties.get("__TENANT_ID_PROP__"));
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId, true);
                task.init();
                task.execute();
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        catch (Throwable e) {
            String msg = "Error in executing task: " + e.getMessage();
            log.error((Object)msg, e);
            throw new JobExecutionException(msg, e);
        }
    }
}

