/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl;

import com.hazelcast.core.HazelcastInstance;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskLocationResolver;
import org.wso2.carbon.ntask.core.TaskServiceContext;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;

public class RuleBasedLocationResolver
implements TaskLocationResolver {
    private static final String RULE_BASED_TASK_RESOLVER_ID = "__RULE_BASED_TASK_RESOLVER_ID__";
    private static final Log log = LogFactory.getLog(RuleBasedLocationResolver.class);
    private List<Rule> rules = new ArrayList<Rule>();

    @Override
    public void init(Map<String, String> properties) throws TaskException {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            int seq;
            if (!entry.getKey().startsWith("rule-")) continue;
            try {
                seq = Integer.parseInt(entry.getKey().substring(5));
            }
            catch (NumberFormatException e) {
                throw new TaskException("The RuleBasedLocationResolver must have the property name in the format of rule-[sequence_number]", TaskException.Code.CONFIG_ERROR);
            }
            this.rules.add(new Rule(seq, entry.getValue()));
        }
        Collections.sort(this.rules);
    }

    @Override
    public int getLocation(TaskServiceContext ctx, TaskInfo taskInfo) throws TaskException {
        int result = -1;
        for (Rule rule : this.rules) {
            List<Integer> locations;
            try {
                locations = rule.evaluate(ctx, taskInfo);
            }
            catch (Exception e) {
                throw new TaskException("Error in rule evaluation in RuleBasedLocationResolver: " + e.getMessage(), TaskException.Code.UNKNOWN);
            }
            if (locations.size() <= 0) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Task rule hit: " + rule + " for task: [" + ctx.getTaskType() + "][" + taskInfo.getName() + "]"));
                log.debug((Object)("Task rule hit: " + rule + " Location count : " + locations.size()));
            }
            result = this.getRoundRobinLocation(rule, locations);
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Task location resolved to: " + result + " for task: [" + ctx.getTaskType() + "][" + taskInfo.getName() + "]"));
        }
        if (result == -1) {
            throw new TaskException("Task location unavailable for RuleBasedLocationResolver: " + ctx.getTaskType() + "#" + taskInfo.getName(), TaskException.Code.TASK_NODE_NOT_AVAILABLE);
        }
        return result;
    }

    private int getRoundRobinLocation(Rule rule, List<Integer> locations) {
        HazelcastInstance hz;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Performing RoundRobin for " + rule));
        }
        if ((hz = TasksDSComponent.getHazelcastInstance()) == null) {
            return 0;
        }
        int result = (int)Math.abs(hz.getAtomicLong(RULE_BASED_TASK_RESOLVER_ID + rule.hashCode()).incrementAndGet());
        result = locations.get(result % locations.size());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected Node for " + rule + " is " + result));
        }
        return result;
    }

    private class Rule
    implements Comparable<Rule> {
        private int sequence;
        private String taskTypePattern;
        private String taskNamePattern;
        private String addressPattern;

        public Rule(int sequence, String entry) throws TaskException {
            this.sequence = sequence;
            String[] tokens = entry.split(",");
            if (tokens.length != 3) {
                throw new TaskException("The RuleBasedLocationResolver must have the properties in the format of [task-type-pattern],[task-name-pattern],[address-pattern]", TaskException.Code.CONFIG_ERROR);
            }
            this.taskTypePattern = tokens[0];
            this.taskNamePattern = tokens[1];
            this.addressPattern = tokens[2];
        }

        public int getSequence() {
            return this.sequence;
        }

        public String getTaskTypePattern() {
            return this.taskTypePattern;
        }

        public String getTaskNamePattern() {
            return this.taskNamePattern;
        }

        public String getAddressPattern() {
            return this.addressPattern;
        }

        public int hashCode() {
            return (this.getSequence() + ":" + this.getTaskTypePattern() + ":" + this.getTaskNamePattern() + this.getAddressPattern()).hashCode();
        }

        @Override
        public int compareTo(Rule rhs) {
            return this.getSequence() - rhs.getSequence();
        }

        public String toString() {
            return "Rule [" + this.getSequence() + "] - " + this.getTaskTypePattern() + "," + this.getTaskNamePattern() + "," + this.getAddressPattern();
        }

        public List<Integer> evaluate(TaskServiceContext ctx, TaskInfo taskInfo) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            if (ctx.getTaskType().matches(this.getTaskTypePattern()) && taskInfo.getName().matches(this.getTaskNamePattern())) {
                int count = ctx.getServerCount();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Task server count : " + count));
                    log.debug((Object)("Address pattern : " + this.addressPattern));
                }
                String ip = null;
                String host2 = null;
                String identifier = null;
                for (int i = 0; i < count; ++i) {
                    InetSocketAddress sockAddr = ctx.getServerAddress(i);
                    identifier = ctx.getServerIdentifier(i);
                    if (sockAddr != null) {
                        InetAddress inetAddr;
                        String host1 = sockAddr.getHostName();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Hostname 1 : " + host1));
                        }
                        if ((inetAddr = sockAddr.getAddress()) != null) {
                            ip = inetAddr.getHostAddress();
                            host2 = inetAddr.getCanonicalHostName();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("IP address : " + ip));
                                log.debug((Object)("Hostname 1 : " + host2));
                            }
                        }
                        if (host1.matches(this.getAddressPattern())) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Hostname 1 matched");
                            }
                            result.add(i);
                            continue;
                        }
                        if (ip != null && ip.matches(this.getAddressPattern())) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"IP address matched");
                            }
                            result.add(i);
                            continue;
                        }
                        if (!host1.equals(host2) && host2 != null && host2.matches(this.getAddressPattern())) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Hostname 2 matched");
                            }
                            result.add(i);
                            continue;
                        }
                        if (identifier == null || !identifier.matches(this.getAddressPattern())) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("localMemberIdentifier : " + identifier));
                            log.debug((Object)"localMemberIdentifier matched");
                        }
                        result.add(i);
                        continue;
                    }
                    log.warn((Object)("RuleBasedLocationResolver: cannot find the host address for node: " + i));
                }
            }
            return result;
        }
    }
}

