/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskManagerId;
import org.wso2.carbon.ntask.core.TaskRepository;
import org.wso2.carbon.ntask.core.TaskUtils;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;

public class RegistryBasedTaskRepository
implements TaskRepository {
    public static final String REG_TASK_BASE_PATH = "/repository/components/org.wso2.carbon.tasks";
    public static final String REG_TASK_REPO_BASE_PATH = "/repository/components/org.wso2.carbon.tasks/definitions";
    private static Registry registry;
    private String taskType;
    private static Marshaller taskMarshaller;
    private static Unmarshaller taskUnmarshaller;
    private int tenantId;

    public RegistryBasedTaskRepository(int tenantId, String taskType) throws TaskException {
        this.tenantId = tenantId;
        this.taskType = taskType;
    }

    @Override
    public int getTenantId() {
        return this.tenantId;
    }

    private static Marshaller getTaskMarshaller() {
        return taskMarshaller;
    }

    private static Unmarshaller getTaskUnmarshaller() {
        return taskUnmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Registry getRegistry() throws TaskException {
        if (registry != null) return registry;
        Class<RegistryBasedTaskRepository> clazz = RegistryBasedTaskRepository.class;
        synchronized (RegistryBasedTaskRepository.class) {
            if (registry != null) return registry;
            registry = TaskUtils.getGovRegistryForTenant(-1234);
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry;
        }
    }

    public String getTaskType() {
        return this.taskType;
    }

    @Override
    public List<TaskInfo> getAllTasks() throws TaskException {
        HashSet<TaskInfo> result = new HashSet<TaskInfo>();
        String tasksPath = this.getMyTasksPath();
        try {
            Object tasksCollection;
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super");
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
            if (RegistryBasedTaskRepository.getRegistry().resourceExists(tasksPath)) {
                String[] taskPaths;
                tasksCollection = (Collection)RegistryBasedTaskRepository.getRegistry().get(tasksPath);
                for (String taskPath : taskPaths = tasksCollection.getChildren()) {
                    TaskInfo taskInfo = this.getTaskInfoRegistryPath(taskPath);
                    result.add(taskInfo);
                }
            }
            tasksCollection = new ArrayList(result);
            return tasksCollection;
        }
        catch (Exception e) {
            throw new TaskException("Error in getting all tasks from repository: " + e.getMessage(), TaskException.Code.CONFIG_ERROR, e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    @Override
    public TaskInfo getTask(String taskName) throws TaskException {
        String tasksPath = this.getMyTasksPath();
        String currentTaskPath = tasksPath + "/" + taskName;
        try {
            TaskInfo taskInfo;
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
            if (!RegistryBasedTaskRepository.getRegistry().resourceExists(currentTaskPath)) {
                throw new TaskException("The task '" + taskName + "' does not exist", TaskException.Code.NO_TASK_EXISTS);
            }
            TaskInfo taskInfo2 = taskInfo = this.getTaskInfoRegistryPath(currentTaskPath);
            return taskInfo2;
        }
        catch (TaskException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskException("Error in loading task '" + taskName + "' from registry: " + e.getMessage(), TaskException.Code.CONFIG_ERROR, e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    @Override
    public synchronized void addTask(TaskInfo taskInfo) throws TaskException {
        String tasksPath = this.getMyTasksPath();
        String currentTaskPath = tasksPath + "/" + taskInfo.getName();
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            RegistryBasedTaskRepository.getTaskMarshaller().marshal((Object)taskInfo, (OutputStream)out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            Resource resource = RegistryBasedTaskRepository.getRegistry().newResource();
            resource.setContentStream((InputStream)in);
            RegistryBasedTaskRepository.getRegistry().put(currentTaskPath, resource);
        }
        catch (Exception e) {
            throw new TaskException("Error in adding task '" + taskInfo.getName() + "' to the repository: " + e.getMessage(), TaskException.Code.CONFIG_ERROR, e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    @Override
    public synchronized boolean deleteTask(String taskName) throws TaskException {
        String tasksPath = this.getMyTasksPath();
        String currentTaskPath = tasksPath + "/" + taskName;
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
            if (!RegistryBasedTaskRepository.getRegistry().resourceExists(currentTaskPath)) {
                boolean bl = false;
                return bl;
            }
            RegistryBasedTaskRepository.getRegistry().delete(currentTaskPath);
            boolean bl = true;
            return bl;
        }
        catch (RegistryException e) {
            throw new TaskException("Error in deleting task '" + taskName + "' in the repository", TaskException.Code.CONFIG_ERROR, (Exception)((Object)e));
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private String getMyTasksPath() {
        return "/repository/components/org.wso2.carbon.tasks/definitions/" + this.getTenantId() + "/" + this.getTasksType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskInfo getTaskInfoRegistryPath(String path) throws Exception {
        try {
            TaskInfo taskInfo;
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
            Resource resource = RegistryBasedTaskRepository.getRegistry().get(path);
            InputStream in = resource.getContentStream();
            Object object = RegistryBasedTaskRepository.getTaskUnmarshaller();
            synchronized (object) {
                taskInfo = (TaskInfo)RegistryBasedTaskRepository.getTaskUnmarshaller().unmarshal(in);
            }
            in.close();
            taskInfo.getProperties().put("__TENANT_ID_PROP__", String.valueOf(this.getTenantId()));
            object = taskInfo;
            return object;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    @Override
    public String getTasksType() {
        return this.taskType;
    }

    public static List<TaskManagerId> getAvailableTenantTasksInRepo() throws TaskException {
        ArrayList<TaskManagerId> tmList = new ArrayList<TaskManagerId>();
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
            boolean result = RegistryBasedTaskRepository.getRegistry().resourceExists(REG_TASK_REPO_BASE_PATH);
            if (result) {
                Resource tmpRes = RegistryBasedTaskRepository.getRegistry().get(REG_TASK_REPO_BASE_PATH);
                if (!(tmpRes instanceof Collection)) {
                    ArrayList<TaskManagerId> arrayList = tmList;
                    return arrayList;
                }
                Collection tenantsCollection = (Collection)tmpRes;
                for (String tidPath : tenantsCollection.getChildren()) {
                    tmpRes = RegistryBasedTaskRepository.getRegistry().get(tidPath);
                    if (!(tmpRes instanceof Collection)) continue;
                    Collection tidPathCollection = (Collection)tmpRes;
                    for (String taskTypePath : tidPathCollection.getChildren()) {
                        Collection taskTypePathCollection;
                        tmpRes = RegistryBasedTaskRepository.getRegistry().get(taskTypePath);
                        if (!(tmpRes instanceof Collection) || (taskTypePathCollection = (Collection)tmpRes).getChildren().length <= 0) continue;
                        try {
                            int tid = Integer.parseInt(tidPath.substring(tidPath.lastIndexOf(47) + 1));
                            tmList.add(new TaskManagerId(tid, taskTypePath.substring(taskTypePath.lastIndexOf(47) + 1)));
                        }
                        catch (NumberFormatException ignore) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new TaskException(e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        return tmList;
    }

    public static List<TaskManagerId> getAllTenantTaskManagersForType(String taskType) throws TaskException {
        List<TaskManagerId> tmList = RegistryBasedTaskRepository.getAvailableTenantTasksInRepo();
        Iterator<TaskManagerId> itr = tmList.iterator();
        while (itr.hasNext()) {
            if (itr.next().getTaskType().equals(taskType)) continue;
            itr.remove();
        }
        return tmList;
    }

    private Resource getTaskMetadataPropResource(String taskName) throws TaskException, RegistryException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
            Resource resource = RegistryBasedTaskRepository.getRegistry().get("/repository/components/org.wso2.carbon.tasks/definitions/" + this.getTenantId() + "/" + this.getTasksType() + "/" + taskName);
            return resource;
        }
        catch (ResourceNotFoundException e) {
            throw new TaskException("The task '" + taskName + "' does not exist", TaskException.Code.NO_TASK_EXISTS, (Exception)((Object)e));
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    @Override
    public void setTaskMetadataProp(String taskName, String key, String value) throws TaskException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
            Resource res = this.getTaskMetadataPropResource(taskName);
            res.setProperty(key, value);
            RegistryBasedTaskRepository.getRegistry().put(res.getPath(), res);
        }
        catch (RegistryException e) {
            throw new TaskException("Error in setting task metadata properties: " + e.getMessage(), TaskException.Code.UNKNOWN, (Exception)((Object)e));
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    @Override
    public String getTaskMetadataProp(String taskName, String key) throws TaskException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
            String string = this.getTaskMetadataPropResource(taskName).getProperty(key);
            return string;
        }
        catch (TaskException e) {
            if (TaskException.Code.NO_TASK_EXISTS.equals((Object)e.getCode())) {
                String string = null;
                return string;
            }
            throw e;
        }
        catch (RegistryException e) {
            throw new TaskException("Error in getting task metadata properties: " + e.getMessage(), TaskException.Code.UNKNOWN, (Exception)((Object)e));
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    static {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TaskInfo.class});
            taskMarshaller = ctx.createMarshaller();
            taskUnmarshaller = ctx.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Error creating task marshaller/unmarshaller: " + e.getMessage());
        }
    }
}

