/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskManagerId;
import org.wso2.carbon.ntask.core.TaskRepository;

public class FileBasedTaskRepository
implements TaskRepository {
    private static final Log log = LogFactory.getLog(FileBasedTaskRepository.class);
    private static final String REG_TASK_BASE_PATH = "/repository/components/org.wso2.carbon.tasks";
    private static final String REG_TASK_REPO_BASE_PATH = "/repository/components/org.wso2.carbon.tasks/definitions";
    private static String resourcePath = FileBasedTaskRepository.getHome() + File.separator + "registry" + File.separator + "governance" + File.separator;
    private static final char URL_SEPARATOR_CHAR = '/';
    private String taskType;
    private static Marshaller taskMarshaller;
    private static Unmarshaller taskUnmarshaller;
    private int tenantId;
    HashMap<String, Properties> taskMetaPropMap = new HashMap();

    public FileBasedTaskRepository(int tenantId, String taskType) {
        this.tenantId = tenantId;
        this.taskType = taskType;
    }

    private String getMyTasksPath() {
        return "/repository/components/org.wso2.carbon.tasks/definitions/" + this.getTenantId() + "/" + this.getTasksType();
    }

    private static String getHome() {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null || "".equals(carbonHome) || ".".equals(carbonHome)) {
            carbonHome = FileBasedTaskRepository.getSystemDependentPath(new File(".").getAbsolutePath());
        }
        return carbonHome;
    }

    private static String getSystemDependentPath(String path) {
        return path.replace('/', File.separatorChar);
    }

    @Override
    public List<TaskInfo> getAllTasks() throws TaskException {
        HashSet<TaskInfo> result = new HashSet<TaskInfo>();
        String tasksPath = this.getMyTasksPath();
        try {
            File[] taskPaths;
            File resource = new File(FileBasedTaskRepository.getSystemDependentPath(resourcePath + tasksPath));
            if (resource.exists() && (taskPaths = resource.listFiles()) != null) {
                for (File taskPath : taskPaths) {
                    if (taskPath.getName().startsWith("_meta_")) continue;
                    TaskInfo taskInfo = this.getTaskInfoRegistryPath(taskPath.getAbsolutePath());
                    result.add(taskInfo);
                }
            }
            return new ArrayList<TaskInfo>(result);
        }
        catch (Exception e) {
            throw new TaskException("Error in getting all tasks from repository: " + e.getMessage(), TaskException.Code.CONFIG_ERROR, e);
        }
    }

    private static Marshaller getTaskMarshaller() {
        return taskMarshaller;
    }

    private static Unmarshaller getTaskUnmarshaller() {
        return taskUnmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskInfo getTaskInfoRegistryPath(String path) throws Exception {
        try (FileInputStream in = null;){
            TaskInfo taskInfo;
            in = new FileInputStream(path);
            Object object = FileBasedTaskRepository.getTaskUnmarshaller();
            synchronized (object) {
                taskInfo = (TaskInfo)FileBasedTaskRepository.getTaskUnmarshaller().unmarshal(FileBasedTaskRepository.getXMLStreamReader(in));
            }
            ((InputStream)in).close();
            taskInfo.getProperties().put("__TENANT_ID_PROP__", String.valueOf(this.getTenantId()));
            object = taskInfo;
            return object;
        }
    }

    @Override
    public TaskInfo getTask(String taskName) throws TaskException {
        String tasksPath = this.getMyTasksPath();
        String currentTaskPath = tasksPath + "/" + taskName;
        try {
            File task = new File(FileBasedTaskRepository.getSystemDependentPath(resourcePath + currentTaskPath));
            if (!task.exists()) {
                throw new TaskException("The task '" + taskName + "' does not exist", TaskException.Code.NO_TASK_EXISTS);
            }
            return this.getTaskInfoRegistryPath(resourcePath + currentTaskPath);
        }
        catch (TaskException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskException("Error in loading task '" + taskName + "' from registry: " + e.getMessage(), TaskException.Code.CONFIG_ERROR, e);
        }
    }

    public static List<TaskManagerId> getAllTenantTaskManagersForType(String taskType) throws TaskException {
        List<TaskManagerId> tmList = FileBasedTaskRepository.getAvailableTenantTasksInRepo();
        Iterator<TaskManagerId> itr = tmList.iterator();
        while (itr.hasNext()) {
            if (itr.next().getTaskType().equals(taskType)) continue;
            itr.remove();
        }
        return tmList;
    }

    private static List<TaskManagerId> getAvailableTenantTasksInRepo() throws TaskException {
        ArrayList<TaskManagerId> tmList = new ArrayList<TaskManagerId>();
        try {
            File file = new File(FileBasedTaskRepository.getSystemDependentPath(resourcePath + REG_TASK_BASE_PATH));
            boolean result = file.exists();
            if (result) {
                if (!file.isDirectory()) {
                    return tmList;
                }
                if (file.listFiles() != null) {
                    for (File tidPath : file.listFiles()) {
                        if (!tidPath.isDirectory() || tidPath.listFiles() == null) continue;
                        for (File taskTypePath : tidPath.listFiles()) {
                            if (!taskTypePath.isDirectory() || taskTypePath.listFiles() == null || taskTypePath.listFiles().length <= 0) continue;
                            try {
                                int tid = Integer.parseInt(tidPath.getAbsolutePath().substring(tidPath.getAbsolutePath().lastIndexOf(47) + 1));
                                tmList.add(new TaskManagerId(tid, taskTypePath.getAbsolutePath().substring(taskTypePath.getAbsolutePath().lastIndexOf(47) + 1)));
                            }
                            catch (NumberFormatException ignore) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new TaskException(e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
        return tmList;
    }

    @Override
    public void addTask(TaskInfo taskInfo) throws TaskException {
        String tasksPath = this.getMyTasksPath();
        String currentTaskPath = tasksPath + "/" + taskInfo.getName();
        File file = new File(FileBasedTaskRepository.getSystemDependentPath(resourcePath + tasksPath));
        if (!file.exists()) {
            file.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(FileBasedTaskRepository.getSystemDependentPath(resourcePath + currentTaskPath));){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            FileBasedTaskRepository.getTaskMarshaller().marshal((Object)taskInfo, (OutputStream)out);
            fos.write(out.toByteArray());
        }
        catch (Exception e) {
            throw new TaskException("Error in adding task '" + taskInfo.getName() + "' to the repository: " + e.getMessage(), TaskException.Code.CONFIG_ERROR, e);
        }
    }

    @Override
    public boolean deleteTask(String taskName) throws TaskException {
        String tasksPath = this.getMyTasksPath();
        String currentTaskPath = tasksPath + "/" + taskName;
        boolean deleteSuccess = false;
        try {
            File metaFile;
            File file = new File(FileBasedTaskRepository.getSystemDependentPath(resourcePath + currentTaskPath));
            if (file.exists()) {
                if (file.delete()) {
                    deleteSuccess = true;
                } else {
                    log.error((Object)("Error occurred while deleting task. Unable to delete: " + FileBasedTaskRepository.getSystemDependentPath(resourcePath + currentTaskPath)));
                }
            }
            if ((metaFile = new File(FileBasedTaskRepository.getSystemDependentPath(resourcePath + tasksPath + "/_meta_" + taskName))).exists()) {
                if (metaFile.delete()) {
                    deleteSuccess = true;
                } else {
                    log.error((Object)("Error occurred while deleting task. Unable to delete: " + FileBasedTaskRepository.getSystemDependentPath(resourcePath + tasksPath + "/_meta_" + taskName)));
                }
            }
            return deleteSuccess;
        }
        catch (Exception e) {
            throw new TaskException("Error in deleting task '" + taskName + "' in the repository", TaskException.Code.CONFIG_ERROR, e);
        }
    }

    @Override
    public String getTasksType() {
        return this.taskType;
    }

    @Override
    public int getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTaskMetadataProp(String taskName, String key, String value) throws TaskException {
        Properties propertyMap = this.taskMetaPropMap.get(FileBasedTaskRepository.getSystemDependentPath(resourcePath + taskName));
        if (propertyMap == null) {
            propertyMap = new Properties();
            this.taskMetaPropMap.put(FileBasedTaskRepository.getSystemDependentPath(resourcePath + taskName), propertyMap);
        }
        try {
            propertyMap.put(key, value);
            this.writeToMetaFile(propertyMap, taskName);
        }
        catch (Exception e) {
            throw new TaskException("Error in setting task metadata properties: " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    private void writeToMetaFile(Properties properties, String taskName) throws Exception {
        String tasksPath = this.getMyTasksPath();
        String currentTaskMetaPath = tasksPath + "/_meta_" + taskName;
        try (FileOutputStream fos = new FileOutputStream(FileBasedTaskRepository.getSystemDependentPath(resourcePath + currentTaskMetaPath));){
            properties.store(fos, null);
        }
    }

    private Properties loadFromMetaFile(String taskName) throws Exception {
        Properties properties = new Properties();
        String tasksPath = this.getMyTasksPath();
        String currentTaskMetaPath = tasksPath + "/_meta_" + taskName;
        try (FileInputStream fis = new FileInputStream(FileBasedTaskRepository.getSystemDependentPath(resourcePath + currentTaskMetaPath));){
            properties.load(fis);
        }
        catch (Exception e) {
            log.debug((Object)"Retrieving Meta file is failed.");
        }
        return properties;
    }

    @Override
    public String getTaskMetadataProp(String taskName, String key) throws TaskException {
        Properties propertyMap = this.taskMetaPropMap.get(FileBasedTaskRepository.getSystemDependentPath(resourcePath + taskName));
        try {
            if (propertyMap == null) {
                propertyMap = this.loadFromMetaFile(taskName);
                this.taskMetaPropMap.put(FileBasedTaskRepository.getSystemDependentPath(resourcePath + taskName), propertyMap);
            }
            return propertyMap.getProperty(key);
        }
        catch (Exception e) {
            throw new TaskException("Error in getting task metadata properties: " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    private static XMLStreamReader getXMLStreamReader(InputStream input) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(new StreamSource(input));
        return xmlStreamReader;
    }

    static {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TaskInfo.class});
            taskMarshaller = ctx.createMarshaller();
            taskUnmarshaller = ctx.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Error creating task marshaller/unmarshaller: " + e.getMessage());
        }
    }
}

