/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.OMElement;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.TaskRepository;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class TaskUtils {
    public static final String SECURE_VAULT_NS = "http://org.wso2.securevault/configuration";
    public static final String SECRET_ALIAS_ATTR_NAME = "secretAlias";
    public static final String TASK_STATE_PROPERTY = "TASK_STATE_PROPERTY";
    private static SecretResolver secretResolver;

    public static Registry getGovRegistryForTenant(int tid) throws TaskException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tid, true);
            UserRegistry userRegistry = TasksDSComponent.getRegistryService().getGovernanceSystemRegistry(tid);
            return userRegistry;
        }
        catch (RegistryException e) {
            throw new TaskException("Error in retrieving registry instance", TaskException.Code.UNKNOWN, (Exception)((Object)e));
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public static Document convertToDocument(File file) throws TaskException {
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        fac.setNamespaceAware(true);
        fac.setXIncludeAware(false);
        fac.setExpandEntityReferences(false);
        try {
            fac.setFeature("http://xml.org/sax/features/external-general-entities", false);
            fac.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            fac.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SecurityManager securityManager = new SecurityManager();
            securityManager.setEntityExpansionLimit(0);
            fac.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
            return fac.newDocumentBuilder().parse(file);
        }
        catch (Exception e) {
            throw new TaskException("Error in creating an XML document from file: " + e.getMessage(), TaskException.Code.CONFIG_ERROR, e);
        }
    }

    private static void secureLoadElement(Element element) throws CryptoException {
        Attr secureAttr = element.getAttributeNodeNS(SECURE_VAULT_NS, SECRET_ALIAS_ATTR_NAME);
        if (secureAttr != null) {
            element.setTextContent(TaskUtils.loadFromSecureVault(secureAttr.getValue()));
            element.removeAttributeNode(secureAttr);
        }
        NodeList childNodes = element.getChildNodes();
        int count = childNodes.getLength();
        for (int i = 0; i < count; ++i) {
            Node tmpNode = childNodes.item(i);
            if (!(tmpNode instanceof Element)) continue;
            TaskUtils.secureLoadElement((Element)tmpNode);
        }
    }

    private static synchronized String loadFromSecureVault(String alias) {
        if (secretResolver == null) {
            secretResolver = SecretResolverFactory.create((OMElement)null, (boolean)false);
            secretResolver.init(TasksDSComponent.getSecretCallbackHandlerService().getSecretCallbackHandler());
        }
        return secretResolver.resolve(alias);
    }

    public static void secureResolveDocument(Document doc) throws TaskException {
        Element element = doc.getDocumentElement();
        if (element != null) {
            try {
                TaskUtils.secureLoadElement(element);
            }
            catch (CryptoException e) {
                throw new TaskException("Error in secure load of document: " + e.getMessage(), TaskException.Code.UNKNOWN, (Exception)((Object)e));
            }
        }
    }

    public static void setTaskState(TaskRepository taskRepo, String taskName, TaskManager.TaskState taskState) throws TaskException {
        taskRepo.setTaskMetadataProp(taskName, TASK_STATE_PROPERTY, taskState.toString());
    }

    public static TaskManager.TaskState getTaskState(TaskRepository taskRepo, String taskName) throws TaskException {
        String currentTaskState = taskRepo.getTaskMetadataProp(taskName, TASK_STATE_PROPERTY);
        if (currentTaskState != null) {
            for (TaskManager.TaskState taskState : TaskManager.TaskState.values()) {
                if (!currentTaskState.equalsIgnoreCase(taskState.toString())) continue;
                return taskState;
            }
        }
        return null;
    }

    public static void setTaskPaused(TaskRepository taskRepo, String taskName, boolean paused) throws TaskException {
        if (paused) {
            TaskUtils.setTaskState(taskRepo, taskName, TaskManager.TaskState.PAUSED);
        } else {
            TaskUtils.setTaskState(taskRepo, taskName, TaskManager.TaskState.NORMAL);
        }
    }

    public static boolean isTaskPaused(TaskRepository taskRepo, String taskName) throws TaskException {
        TaskManager.TaskState currentState = TaskUtils.getTaskState(taskRepo, taskName);
        return currentState != null && currentState.equals((Object)TaskManager.TaskState.PAUSED);
    }

    public static void setTaskFinished(TaskRepository taskRepo, String taskName, boolean finished) throws TaskException {
        if (finished) {
            TaskUtils.setTaskState(taskRepo, taskName, TaskManager.TaskState.FINISHED);
        } else {
            TaskUtils.setTaskState(taskRepo, taskName, TaskManager.TaskState.NORMAL);
        }
    }

    public static boolean isTaskFinished(TaskRepository taskRepo, String taskName) throws TaskException {
        TaskManager.TaskState currentState = TaskUtils.getTaskState(taskRepo, taskName);
        return currentState != null && currentState.equals((Object)TaskManager.TaskState.FINISHED);
    }
}

