/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core;

import com.hazelcast.core.Member;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskRepository;

public class TaskServiceContext {
    private TaskRepository taskRepo;
    private List<String> memberIds;
    private Map<String, Member> memberMap;
    private static final String LOCAL_MEMBER_IDENTIFIER = "localMemberIdentifier";

    public TaskServiceContext(TaskRepository taskRepo, List<String> memberIds, Map<String, Member> memberMap) {
        this.taskRepo = taskRepo;
        this.memberIds = memberIds;
        this.memberMap = memberMap;
    }

    public int getTenantId() {
        return this.taskRepo.getTenantId();
    }

    public String getTaskType() {
        return this.taskRepo.getTasksType();
    }

    public List<TaskInfo> getTasks() throws TaskException {
        return this.taskRepo.getAllTasks();
    }

    public int getServerCount() {
        return this.memberIds.size();
    }

    public InetSocketAddress getServerAddress(int index) {
        String memberId = this.memberIds.get(index);
        Member member = this.memberMap.get(memberId);
        if (member == null) {
            return null;
        }
        return member.getSocketAddress();
    }

    public String getServerIdentifier(int index) {
        String memberId = this.memberIds.get(index);
        Member member = this.memberMap.get(memberId);
        if (member == null) {
            return null;
        }
        return member.getStringAttribute(LOCAL_MEMBER_IDENTIFIER);
    }
}

